/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.bizmodel;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.mmc.phm.common.util.DataCopyTaskUtil;

public class ModSchedulePlanDeleteOp
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_PHM_MODELSCHEDULEPLAN = "phm_modelscheduleplan";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DBRoute dbRoute = new DBRoute("phm");
        for (DynamicObject obj : e.getDataEntities()) {
            this.clearModSchedule(dbRoute, obj.getLong("id"));
            DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)obj.getLong("id"), (String)ENTITY_PHM_MODELSCHEDULEPLAN);
            DynamicObjectCollection entitys = planObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entitys) {
                DynamicObject mod = entity.getDynamicObject("bizmodel");
                String num = mod.getString("number");
                num = num.toUpperCase();
                String jobNum = "JOB-PHM-" + num;
                String planNum = "PLAN-PHM-" + num;
                String jobId = this.getIdByNum(ENTITY_SCH_JOB, jobNum);
                String planId = this.getIdByNum(ENTITY_SCH_SCHEDULE, planNum);
                try (TXHandle handle = TX.requiresNew();){
                    DataCopyTaskUtil.deleteSchDynamicObject((String)ENTITY_SCH_SCHEDULE, (String)"sch_task", (String[])new String[]{planId});
                    DeleteServiceHelper.delete((String)ENTITY_SCH_JOB, (QFilter[])new QFilter("id", "=", (Object)jobId).toArray());
                }
            }
        }
    }

    private String getIdByNum(String entityName, String num) {
        QFilter f1 = new QFilter("number", "=", (Object)num);
        DynamicObject job = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{f1});
        if (job != null) {
            return job.getString("id");
        }
        return "";
    }

    private void clearModSchedule(DBRoute dbRoute, Long planId) {
        String sql = String.format("update t_phm_bizmodel_i set fscheduleplan = 0 where fscheduleplan = %d", planId);
        DB.execute((DBRoute)dbRoute, (String)sql);
    }
}

