/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.bizmodel;

import java.util.HashMap;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class ModSchedulePlanRunOp
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_PHM_MODELSCHEDULEPLAN = "phm_modelscheduleplan";
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String PROP_NUMBER = "number";

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        for (ExtendedDataEntity dataEntity : e.getValidExtDataEntities()) {
            DynamicObject entity = dataEntity.getDataEntity();
            DynamicObject modRunPlan = BusinessDataServiceHelper.loadSingle((Object)entity.getLong("id"), (String)ENTITY_PHM_MODELSCHEDULEPLAN);
            DynamicObjectCollection tasks = modRunPlan.getDynamicObjectCollection("entryentity");
            for (DynamicObject task : tasks) {
                DynamicObject bizMod = task.getDynamicObject("bizmodel");
                String modNum = bizMod.getString(PROP_NUMBER);
                String jobNum = "JOB-PHM-" + modNum.toUpperCase();
                String jobId = this.getIdByNum(ENTITY_SCH_JOB, jobNum);
                if (StringUtils.isEmpty((CharSequence)jobId)) {
                    e.setCancel(true);
                    this.addErrMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5ea6\u8ba1\u5212\u7f3a\u5931\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u6a21\u578b\u8c03\u5ea6\u8ba1\u5212\uff01", (String)"ModSchedulePlanRunOp_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                    continue;
                }
                DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)ENTITY_SCH_JOB);
                if (job != null) {
                    JobInfo jobInfo = this.jobInfoInit(job);
                    JobClient.dispatch((JobInfo)jobInfo);
                    continue;
                }
                e.setCancel(true);
                this.addErrMessage(dataEntity, ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a\u7f3a\u5931\uff0c\u8bf7\u91cd\u65b0\u63d0\u4ea4\u6a21\u578b\u8c03\u5ea6\u8ba1\u5212\uff01", (String)"ModSchedulePlanRunOp_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
            }
        }
    }

    private JobInfo jobInfoInit(DynamicObject job) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId(job.getPkValue().toString());
        jobInfo.setNumber(job.getString(PROP_NUMBER));
        jobInfo.setName(job.getString("name"));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        DynamicObject classObj = job.getDynamicObject("taskclassname");
        jobInfo.setTaskDefineId(classObj.getString("id"));
        jobInfo.setTaskClassname(classObj.getString("classname"));
        HashMap<String, String> params = new HashMap<String, String>();
        DynamicObjectCollection pms = job.getDynamicObjectCollection("entryentity");
        for (DynamicObject pm : pms) {
            params.put(pm.getString("paramname"), pm.getString("paramvalue"));
        }
        jobInfo.setParams(params);
        return jobInfo;
    }

    private String getIdByNum(String entityName, String num) {
        QFilter f1 = new QFilter(PROP_NUMBER, "=", (Object)num);
        DynamicObject job = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{f1});
        if (job != null) {
            return job.getString("id");
        }
        return "";
    }

    private void addErrMessage(ExtendedDataEntity dataEntity, String errMsg) {
        Object pkId = dataEntity.getDataEntity().getPkValue();
        int dataIndex = dataEntity.getDataEntityIndex();
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", pkId, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u8c03\u5ea6\u4f5c\u4e1a/\u8ba1\u5212", (String)"ModSchedulePlanRunOp_2", (String)"mmc-phm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

