/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.bizmodel;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.orm.dataentity.DynamicObjectResultSetCallback;

public class ModSchedulePlanSaveOp
extends AbstractOperationServicePlugIn {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DBRoute dbRoute = new DBRoute("phm");
        for (DynamicObject obj : e.getDataEntities()) {
            this.clearModSchedule(dbRoute, obj.getLong("id"));
            DynamicObjectCollection rows = obj.getDynamicObjectCollection("entryentity");
            for (DynamicObject row : rows) {
                DynamicObject mod = row.getDynamicObject("bizmodel");
                this.updateModSchedule(dbRoute, obj.getLong("id"), mod.getLong("id"));
            }
        }
    }

    private void clearModSchedule(DBRoute dbRoute, Long planId) {
        String sql = String.format("update t_phm_bizmodel_i set fscheduleplan = 0 where fscheduleplan = %d", planId);
        DB.execute((DBRoute)dbRoute, (String)sql);
    }

    private void updateModSchedule(DBRoute dbRoute, Long planId, Long modId) {
        StringBuilder insertSql = new StringBuilder();
        if (!this.scheduleExists(dbRoute, modId)) {
            insertSql.append("insert into t_phm_bizmodel_i (FID,fscheduleplan,fallowedrunstatus) values(");
            insertSql.append(modId);
            insertSql.append(',');
            insertSql.append(planId);
            insertSql.append(",1");
            insertSql.append(')');
        } else {
            insertSql.append("update t_phm_bizmodel_i set fscheduleplan = ");
            insertSql.append(planId);
            insertSql.append(" where fid = ");
            insertSql.append(modId);
        }
        DB.execute((DBRoute)dbRoute, (String)insertSql.toString());
    }

    private boolean scheduleExists(DBRoute dbRoute, Long id) {
        String sql = "select fid from t_phm_bizmodel_i where fid =" + id;
        DynamicObjectCollection dataSet = (DynamicObjectCollection)DB.query((DBRoute)dbRoute, (String)sql, null, (ResultSetHandler)new DynamicObjectResultSetCallback(null));
        return !dataSet.isEmpty();
    }
}

