/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.bizmodel;

import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ModschedulePlanEnableOp
extends AbstractOperationServicePlugIn {
    private static final String ENTITY_SCH_JOB = "sch_job";
    private static final String ENTITY_SCH_SCHEDULE = "sch_schedule";
    private static final String ENTITY_PHM_MODELSCHEDULEPLAN = "phm_modelscheduleplan";
    private static final String PROP_ENABLE = "enable";

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        String opKey = e.getOperationKey();
        if (!(opKey.equals("disable") || opKey.equals("unsubmit") || opKey.equals(PROP_ENABLE))) {
            return;
        }
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        for (DynamicObject dataEntity : e.getDataEntities()) {
            String id = dataEntity.getString("id");
            DynamicObject planObj = BusinessDataServiceHelper.loadSingle((Object)id, (String)ENTITY_PHM_MODELSCHEDULEPLAN);
            DynamicObjectCollection entitys = planObj.getDynamicObjectCollection("entryentity");
            for (DynamicObject entity : entitys) {
                DynamicObject mod = entity.getDynamicObject("bizmodel");
                String num = mod.getString("number");
                String jobNum = "JOB-PHM-" + num.toUpperCase();
                String planNum = "PLAN-PHM-" + num.toUpperCase();
                String jobId = this.getIdByNum(ENTITY_SCH_JOB, jobNum);
                String planId = this.getIdByNum(ENTITY_SCH_SCHEDULE, planNum);
                OperationResult result = this.jobDisable(jobId, opKey);
                if (!result.isSuccess()) {
                    throw new KDException(ModschedulePlanEnableOp.createErrorCode(this.getErrorInfo(result)), new Object[0]);
                }
                result = this.planDisable(planId, opKey);
                if (!result.isSuccess()) {
                    throw new KDException(ModschedulePlanEnableOp.createErrorCode(this.getErrorInfo(result)), new Object[0]);
                }
                if (opKey.equals(PROP_ENABLE)) {
                    scheduleManager.enableJob(jobId);
                    scheduleManager.enableSchedule(planId);
                    continue;
                }
                scheduleManager.disableJob(jobId);
                scheduleManager.disableSchedule(planId);
            }
        }
    }

    private OperationResult planDisable(String planId, String opKey) {
        DynamicObject plan = BusinessDataServiceHelper.loadSingle((Object)planId, (String)ENTITY_SCH_SCHEDULE, (String)"id,status");
        int i = opKey.equals(PROP_ENABLE) ? 1 : 0;
        plan.set("status", (Object)i);
        return SaveServiceHelper.saveOperate((String)ENTITY_SCH_SCHEDULE, (DynamicObject[])new DynamicObject[]{plan}, (OperateOption)OperateOption.create());
    }

    private OperationResult jobDisable(String jobId, String opKey) {
        DynamicObject job = BusinessDataServiceHelper.loadSingle((Object)jobId, (String)ENTITY_SCH_JOB, (String)"id,status");
        int i = opKey.equals(PROP_ENABLE) ? 1 : 0;
        job.set("status", (Object)i);
        return SaveServiceHelper.saveOperate((String)ENTITY_SCH_JOB, (DynamicObject[])new DynamicObject[]{job}, (OperateOption)OperateOption.create());
    }

    private String getIdByNum(String entityName, String num) {
        QFilter f1 = new QFilter("number", "=", (Object)num);
        DynamicObject job = QueryServiceHelper.queryOne((String)entityName, (String)"id", (QFilter[])new QFilter[]{f1});
        if (job != null) {
            return job.getString("id");
        }
        return "";
    }

    private String getErrorInfo(OperationResult result) {
        List vErr;
        List err = result.getAllErrorInfo();
        StringBuilder sb = new StringBuilder();
        if (err.size() > 0) {
            for (OperateErrorInfo errInfo : err) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        if ((vErr = result.getAllErrorOrValidateInfo()).size() > 0) {
            for (IOperateInfo errInfo : vErr) {
                sb.append('|');
                sb.append(errInfo.getMessage());
            }
        }
        return sb.toString();
    }

    public static ErrorCode createErrorCode(String message) {
        return new ErrorCode("mmc.phm.500", message);
    }
}

