/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.bos.basedataref.BaseDataCheckRefrence;
import kd.bos.basedataref.BaseDataCheckRefrenceResult;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.RefObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.validate.AbstractValidator;

public class BaseDataRefValidator
extends AbstractValidator {
    private BasedataEntityType entityType;
    private OperateOption option;
    private boolean draftValidReference;

    public OperateOption getOption() {
        return this.option;
    }

    public void setOption(OperateOption option) {
        this.option = option;
    }

    public void setEntityType(BasedataEntityType entityType) {
        this.entityType = entityType;
    }

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.draftValidReference = true;
    }

    public void validate() {
        HashMap<Object, ExtendedDataEntity> objMap = new HashMap<Object, ExtendedDataEntity>(16);
        for (ExtendedDataEntity dataObj : this.dataEntities) {
            Object idValue = dataObj.getBillPkId();
            objMap.put(idValue, dataObj);
        }
        if (!objMap.isEmpty()) {
            BaseDataCheckRefrence checker = new BaseDataCheckRefrence();
            this.addIgnoreRefEntityIds(checker);
            checker.setDraftValidReference(this.draftValidReference);
            Map checkResult = checker.checkRef(this.entityType, objMap.keySet().toArray());
            Iterator var15 = checkResult.entrySet().iterator();
            while (true) {
                if (!var15.hasNext()) {
                    return;
                }
                Map.Entry entry = var15.next();
                ExtendedDataEntity dataObj = (ExtendedDataEntity)objMap.get(entry.getKey());
                if (dataObj == null) continue;
                BaseDataCheckRefrenceResult refrenceResult = (BaseDataCheckRefrenceResult)entry.getValue();
                if (!((BaseDataCheckRefrenceResult)entry.getValue()).isRefence()) continue;
                MainEntityType refMainType = EntityMetadataCache.getDataEntityType((String)refrenceResult.getRefenceKey().getRefEntityKey());
                String billName = refMainType.getDisplayName().toString();
                String fieldName = refrenceResult.getRefenceKey().getRefCol();
                for (IDataEntityProperty property : refMainType.getAllFields().values()) {
                    if (property instanceof IFieldHandle && StringUtils.equalsIgnoreCase((CharSequence)property.getAlias(), (CharSequence)refrenceResult.getRefenceKey().getRefCol())) {
                        fieldName = ((IFieldHandle)property).getDisplayName().toString();
                        break;
                    }
                    if (!(property instanceof MulBasedataProp) || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefCol(), (CharSequence)"fbasedataid") || !StringUtils.equalsIgnoreCase((CharSequence)refrenceResult.getRefenceKey().getRefTable(), (CharSequence)((MulBasedataProp)property).getAlias())) continue;
                    fieldName = ((MulBasedataProp)property).getDisplayName().toString();
                    break;
                }
                String msg = String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5f15\u7528\u4e0d\u80fd\u88ab%s\uff1a[%s]\u7684\u5b57\u6bb5[%s]\u5f15\u7528\u4e86\u6b64\u8d44\u6599\u6570\u636e", (String)"BaseDataRefValidator_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]), this.getOperationName(), billName, fieldName);
                this.addErrorMessage(dataObj, msg);
            }
        }
    }

    private void addIgnoreRefEntityIds(BaseDataCheckRefrence checker) {
        String entityId;
        int var6;
        int var5;
        String[] var4;
        String[] entityIds;
        RefObject opValue = new RefObject();
        if (this.option.tryGetVariableValue("ignorerefentityids", opValue) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            var4 = entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",");
            var5 = entityIds.length;
            for (var6 = 0; var6 < var5; ++var6) {
                entityId = var4[var6];
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getIgnoreRefEntityIds().add(entityId);
            }
        }
        if (this.option.tryGetVariableValue("checkrefentityids", opValue = new RefObject()) && StringUtils.isNotBlank((CharSequence)((CharSequence)opValue.getValue()))) {
            var4 = entityIds = StringUtils.split((String)((String)opValue.getValue()), (String)",");
            var5 = entityIds.length;
            for (var6 = 0; var6 < var5; ++var6) {
                entityId = var4[var6];
                if (!StringUtils.isNotBlank((CharSequence)entityId)) continue;
                checker.getCheckRefEntityIds().add(entityId);
            }
        }
    }
}

