/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.phm.common.basemanager.ErrMsgEnum;

public class DataMapSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity extendedDataEntity = this.dataEntities[0];
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        DynamicObject metaObj = dataEntity.getDynamicObject("meta");
        DynamicObjectCollection srcTableInfos = metaObj.getDynamicObjectCollection("sourcetable");
        if (srcTableInfos != null && srcTableInfos.size() > 1) {
            for (DynamicObject srcTableInfo : srcTableInfos) {
                if (srcTableInfo.getBoolean("ismaintable")) continue;
                String table = this.getTableName(srcTableInfo);
                DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("entryentity");
                int result = this.hasSetPk(rows, table);
                if (result <= 0) continue;
                this.addErrorMessage(extendedDataEntity, ErrMsgEnum.fromValue((int)result).getName());
            }
        }
    }

    private int hasSetPk(DynamicObjectCollection rows, String table) {
        for (DynamicObject row : rows) {
            if (!row.getString("key_srctable").equalsIgnoreCase(table)) continue;
            return 0;
        }
        return ErrMsgEnum.NEEDSETFIELDLINK.getValue();
    }

    private String getTableName(DynamicObject srcTableInfo) {
        DynamicObject link = srcTableInfo.getDynamicObject("link");
        StringBuilder sb = new StringBuilder();
        sb.append(link.getString("number"));
        sb.append('-');
        sb.append(srcTableInfo.getString("srctable"));
        return sb.toString();
    }
}

