/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator;

import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.mmc.phm.common.basemanager.ErrMsgEnum;

public class DataTableSaveValidator
extends AbstractValidator {
    private static final String TYPE_BIGINT = "BIGINT";
    private static final String TYPE_DECIMAL = "DECIMAL";
    private static final String TYPE_NVARCHAR = "NVARCHAR";
    private static final String PROP_DEFVALUE = "defvalue";
    private static final String PROP_FIELDTYPE = "fieldtype";
    private static final String PROP_FIELDLENGTH = "fieldlength";
    private static final String PROP_ENTRYENTITY = "entryentity";

    public void validate() {
        ExtendedDataEntity extendedDataEntity = this.dataEntities[0];
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        int result = this.tableExists(dataEntity);
        if (result == 0) {
            result = this.rowCheck(dataEntity);
        }
        if (result == 0) {
            result = this.colCheck(dataEntity);
        }
        if (result > 0) {
            this.addErrorMessage(extendedDataEntity, ErrMsgEnum.fromValue((int)result).getName());
        }
    }

    private int tableExists(DynamicObject dataEntity) {
        QFilter f;
        DBRoute dbRoute = new DBRoute("phm");
        String table = dataEntity.getString("number");
        ORM orm = ORM.create();
        DynamicObject tbObj = orm.queryOne("phm_datatable", new QFilter[]{f = new QFilter("number", "=", (Object)table)});
        if (tbObj != null) {
            return 0;
        }
        if (!StringUtils.isEmail((String)table) && DB.exitsTable((DBRoute)dbRoute, (String)table)) {
            return ErrMsgEnum.TABLEEXISTS.getValue();
        }
        return 0;
    }

    private int rowCheck(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(PROP_ENTRYENTITY);
        for (DynamicObject row : rows) {
            int result = this.check(row);
            if (result <= 0) continue;
            return result;
        }
        return 0;
    }

    private int colCheck(DynamicObject dataEntity) {
        int result = this.tablePkChecker(dataEntity);
        if (result > 0) {
            return result;
        }
        return this.sameFieldChecker(dataEntity);
    }

    private int sameFieldChecker(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(PROP_ENTRYENTITY);
        ArrayList<String> fields = new ArrayList<String>();
        if (rows != null && rows.size() > 0) {
            for (DynamicObject row : rows) {
                if (fields.contains(row.getString("fieldname"))) {
                    return ErrMsgEnum.SAMEFIELD.getValue();
                }
                fields.add(row.getString("fieldname"));
            }
        }
        return 0;
    }

    private int tablePkChecker(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection(PROP_ENTRYENTITY);
        if (rows != null && rows.size() > 0) {
            for (DynamicObject row : rows) {
                if (!row.getBoolean("primarykey")) continue;
                if (row.getString(PROP_FIELDTYPE) == null) {
                    return 0;
                }
                if (row.getString(PROP_FIELDTYPE).equals(TYPE_NVARCHAR) && row.getLong(PROP_FIELDLENGTH) > 767L) {
                    return ErrMsgEnum.PKLENGLIMITED.getValue();
                }
                return 0;
            }
        }
        return ErrMsgEnum.NEEDPK.getValue();
    }

    private int check(DynamicObject row) {
        if (row.getString(PROP_FIELDTYPE) == null) {
            return 0;
        }
        if (row.getString(PROP_FIELDTYPE).equalsIgnoreCase(TYPE_BIGINT)) {
            return this.intChecker(row.getString(PROP_DEFVALUE));
        }
        if (row.getString(PROP_FIELDTYPE).equalsIgnoreCase(TYPE_DECIMAL)) {
            return this.decimalChecker(row.getString(PROP_DEFVALUE));
        }
        if (row.getString(PROP_FIELDTYPE).equalsIgnoreCase(TYPE_NVARCHAR)) {
            return this.strChecker(row.getLong(PROP_FIELDLENGTH), row.getString(PROP_DEFVALUE));
        }
        return 0;
    }

    private int intChecker(String value) {
        String pattern = "^-?[0-9]\\d*$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(value);
        return m.matches() ? 0 : 1;
    }

    private int decimalChecker(String value) {
        String pattern = "^(\\-|\\+)?\\d+(\\.\\d+)?$";
        Pattern r = Pattern.compile(pattern);
        Matcher m = r.matcher(value);
        return m.matches() ? 0 : 2;
    }

    private int strChecker(Long length, String value) {
        if (length <= 0L || length > 2000L) {
            return 3;
        }
        if (length < (long)value.length()) {
            return 4;
        }
        return 0;
    }
}

