/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator;

import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.phm.common.basemanager.ErrMsgEnum;

public class MetaDataSaveValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity extendedDataEntity = this.dataEntities[0];
        DynamicObject dataEntity = extendedDataEntity.getDataEntity();
        int result = this.check(dataEntity);
        if (result > 0) {
            this.addErrorMessage(extendedDataEntity, ErrMsgEnum.fromValue((int)result).getName());
        }
    }

    private int check(DynamicObject dataEntity) {
        int i = this.fieldChecker(dataEntity);
        if (i > 0) {
            return i;
        }
        i = this.destFieldCheck(dataEntity);
        if (i > 0) {
            return i;
        }
        return this.pkChecker(dataEntity);
    }

    private int destFieldCheck(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("fieldlink");
        if (rows == null || rows.size() == 0) {
            return 0;
        }
        HashMap<String, String> temp = new HashMap<String, String>();
        for (DynamicObject row : rows) {
            String destField = row.getString("destfield");
            if (StringUtils.isBlank((CharSequence)destField)) continue;
            if (temp.containsKey(destField)) {
                return ErrMsgEnum.DESTFIELDREPEAT.getValue();
            }
            temp.put(destField, destField);
        }
        return 0;
    }

    private int fieldChecker(DynamicObject dataEntity) {
        if (dataEntity.getString("type").equals("QUERY") || dataEntity.getString("type").equals("STRUCT")) {
            if (dataEntity.getString("apilink") == null) {
                return ErrMsgEnum.APILINK_NOEMPTY.getValue();
            }
            if (dataEntity.getString("fullname").isEmpty()) {
                return ErrMsgEnum.FULLNAME_NOTEMPTY.getValue();
            }
        }
        return this.destTablePkChecker(dataEntity);
    }

    private int destTablePkChecker(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("fieldlink");
        if (rows != null && rows.size() > 0) {
            for (DynamicObject row : rows) {
                if (!row.getBoolean("destpkfield")) continue;
                return 0;
            }
        }
        return ErrMsgEnum.DESTTABLENEEDPK.getValue();
    }

    private int pkChecker(DynamicObject dataEntity) {
        DynamicObjectCollection rows = dataEntity.getDynamicObjectCollection("sourcetable");
        if (rows != null && rows.size() > 0) {
            for (DynamicObject row : rows) {
                if (!row.getBoolean("ismaintable")) continue;
                return 0;
            }
        }
        return ErrMsgEnum.MAINTABLEREQUIRED.getValue();
    }
}

