/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.formula.RowDataModel;
import kd.bos.entity.validate.AbstractValidator;

public class ModelRunPlanValidator
extends AbstractValidator {
    public static final String KEY_START_DATE = "validated_time";
    public static final String KEY_EXPIRED_DATE = "expired_time";
    public static final String ENTRY_ENTITY = "entryentity";

    public void initializeConfiguration() {
        super.initializeConfiguration();
        this.entityKey = "phm_modelscheduleplan";
    }

    public void validate() {
        RowDataModel rowDataModel = new RowDataModel(this.entityKey, this.getValidateContext().getSubEntityType());
        SimpleDateFormat timesdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        for (ExtendedDataEntity rowDataEntity : this.getDataEntities()) {
            rowDataModel.setRowContext(rowDataEntity.getDataEntity());
            Date startDate = (Date)rowDataModel.getValue(KEY_START_DATE);
            Date endDate = (Date)rowDataModel.getValue(KEY_EXPIRED_DATE);
            Object[] entryentity = (Object[])rowDataModel.getValue("bizmodel");
            if (null != startDate && null != endDate && startDate.compareTo(endDate) > 0) {
                this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u5f00\u59cb\u65f6\u95f4\u4e0d\u80fd\u5927\u4e8e\u8fc7\u671f\u65f6\u95f4\uff01", (String)"ModelRunPlanValidator_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                return;
            }
            if (entryentity != null && entryentity.length != 0) continue;
            this.addErrorMessage(rowDataEntity, ResManager.loadKDString((String)"\u8fd0\u884c\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a\uff01", (String)"ModelRunPlanValidator_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
            return;
        }
    }
}

