/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator.flow;

import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class FlowDefineSubFlowValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            long id;
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection flowNodes = dataEntity.getDynamicObjectCollection("flownodeentryentity");
            if (flowNodes == null || flowNodes.isEmpty() || (id = dataEntity.getLong("id")) == 0L) continue;
            for (DynamicObject node : flowNodes) {
                DynamicObjectCollection subFlows;
                IDataEntityProperty pt = (IDataEntityProperty)node.getDynamicObjectType().getProperties().get((Object)"flowsubentryentity");
                if (pt == null || (subFlows = node.getDynamicObjectCollection("flowsubentryentity")) == null || subFlows.isEmpty()) continue;
                String nodeName = node.getString("nodename");
                for (DynamicObject subFlow : subFlows) {
                    long subFlowId = subFlow.getLong("flownumber_id");
                    int seq = subFlow.getInt("seq");
                    DBRoute dbRoute = new DBRoute(dataEntity.getDataEntityType().getDBRouteKey());
                    boolean existsSelf = this.subFlowExistsSelf(id, subFlowId, dbRoute);
                    if (!existsSelf) continue;
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9:%s\u7684\u201c\u5b50\u6d41\u7a0b\u201d\u7b2c%s\u884c\u7684\u5b50\u6d41\u7a0b\u5b58\u5728\u5f53\u524d\u6d41\u7a0b\u3002", (String)"FlowDefineSubFlowValidator_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]), nodeName, seq));
                }
            }
        }
    }

    private boolean subFlowExistsSelf(long id, long subFlowId, DBRoute dbRoute) {
        block23: {
            try (DataSet dataSet = DB.queryDataSet((String)((Object)((Object)this)).getClass().getName(), (DBRoute)dbRoute, (String)"select B.fflowdefineid from t_phm_flownode A left join t_phm_subflow B on A.fentryid = B.fentryid where A.fid = ? ", (Object[])new Object[]{subFlowId});){
                if (dataSet.hasNext()) {
                    for (Row row : dataSet) {
                        Long subSubFlowId = row.getLong(0);
                        if (id == subSubFlowId) {
                            boolean bl = true;
                            return bl;
                        }
                        boolean esixts = this.subFlowExistsSelf(id, subSubFlowId, dbRoute);
                        if (!esixts) continue;
                        boolean bl = esixts;
                        return bl;
                    }
                    break block23;
                }
                boolean bl = false;
                return bl;
            }
        }
        return false;
    }
}

