/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator.flow;

import java.math.BigDecimal;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.phm.common.enums.ComparisonOperators;
import kd.mmc.phm.common.enums.DealTypeEnum;

public class FlowDefineValidate
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection flowNodes = dataEntity.getDynamicObjectCollection("flownodeentryentity");
            if (flowNodes == null || flowNodes.isEmpty()) continue;
            boolean hasEmptyNodeName = false;
            boolean nodeHasCycleResource = false;
            for (DynamicObject flowNode : flowNodes) {
                IDataEntityProperty pt = (IDataEntityProperty)flowNode.getDynamicObjectType().getProperties().get((Object)"resourcesubentryentity");
                if (pt == null) continue;
                String nodeName = flowNode.getString("nodename");
                if (StringUtils.isEmpty((CharSequence)nodeName)) {
                    hasEmptyNodeName = true;
                }
                boolean hasCycleResource = false;
                BigDecimal cycle = flowNode.getBigDecimal("nodecycle");
                if (cycle.compareTo(BigDecimal.ZERO) == 0) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6d41\u7a0b\u8282\u70b9%s\u7684\u5468\u671f\uff08\u5929\uff09\u3002", (String)"FlowDefineValidate_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]), nodeName));
                }
                DynamicObjectCollection resources = flowNode.getDynamicObjectCollection("resourcesubentryentity");
                for (DynamicObject resource : resources) {
                    String[] conf;
                    int seq = resource.getInt("seq");
                    boolean control = resource.getBoolean("control");
                    String formula = resource.getString("formula");
                    DynamicObjectCollection roles = resource.getDynamicObjectCollection("depersonliable");
                    if (roles == null || roles.isEmpty()) continue;
                    if (control && StringUtils.isEmpty((CharSequence)formula)) {
                        this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\uff1a%s\u7684\u201c\u4ea4\u4ed8\u7269\u201d\u7b2c%s\u884c\uff0c\u8bf7\u586b\u5199\u201c\u63a7\u5236\u914d\u7f6e\u201d", (String)"FlowDefineValidate_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]), nodeName, seq));
                    } else if (control && StringUtils.isNotEmpty((CharSequence)formula) && (conf = formula.split(";")).length > 2) {
                        int value = Integer.parseInt(conf[2]);
                        String logic = conf[1];
                        if (StringUtils.equals((CharSequence)logic, (CharSequence)ComparisonOperators.GT.getValue())) {
                            if (value >= roles.size()) {
                                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\uff1a%s\u7684\u201c\u4ea4\u4ed8\u7269\u201d\u7b2c%s\u884c\uff0c\u63a7\u5236\u914d\u7f6e\u201c\u6bd4\u8f83\u503c\u201d\u5fc5\u987b\u5c0f\u4e8e\u8d23\u4efb\u4eba\u6570\u91cf\u3002", (String)"FlowDefineValidate_2", (String)"mmc-phm-opplugin", (Object[])new Object[0]), nodeName, seq));
                            }
                        } else if (value > roles.size()) {
                            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u6d41\u7a0b\u8282\u70b9\uff1a%s\u7684\u201c\u8d44\u6e90\u201d\u7b2c%s\u884c\uff0c\u63a7\u5236\u914d\u7f6e\u201c\u6bd4\u8f83\u503c\u201d\u4e0d\u80fd\u5927\u4e8e\u8d23\u4efb\u4eba\u6570\u91cf\u3002", (String)"FlowDefineValidate_3", (String)"mmc-phm-opplugin", (Object[])new Object[0]), nodeName, seq));
                        }
                    }
                    String dealType = resource.getString("dealtype");
                    if (!DealTypeEnum.CYCLE.getName().equals(dealType)) continue;
                    hasCycleResource = true;
                }
                if (!hasCycleResource || BigDecimal.ZERO.compareTo(cycle) != 0) continue;
                nodeHasCycleResource = true;
            }
            if (hasEmptyNodeName) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u6d41\u7a0b\u8282\u70b9\u201c\u540d\u79f0\u201d\u672a\u586b\u5199\u3002", (String)"FlowDefineValidate_4", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
            }
            if (!nodeHasCycleResource) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u4ea4\u4ed8\u7269\"\u5904\u7406\u65b9\u5f0f\"\u4e3a\"\u5b9a\u65f6\"\u7684\u8282\u70b9,\u8282\u70b9\"\u5468\u671f\"\u672a\u586b\u5199\u3002", (String)"FlowDefineValidate_5", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
        }
    }
}

