/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator.flow;

import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.phm.common.util.FlowUtils;

public class FlowSubmitValidator
extends AbstractValidator {
    private static final Log log = LogFactory.getLog(FlowSubmitValidator.class);

    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            String flowConfig = dataEntity.getString("flowconf_tag");
            DynamicObjectCollection nodeEntrys = dataEntity.getDynamicObjectCollection("flownodeentryentity");
            HashMap<String, String> nodesMap = new HashMap<String, String>(8);
            for (DynamicObject nodeEntry : nodeEntrys) {
                String nodeId = nodeEntry.getString("nodeid");
                String nodeName = nodeEntry.getString("nodename");
                nodesMap.put(nodeId, nodeName);
            }
            if (nodesMap.size() == 0) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5fc5\u987b\u5b58\u5728\u4e00\u4e2a\u8282\u70b9\u3002", (String)"FlowSubmitValidator_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
            }
            try {
                if (nodesMap.size() > 1) {
                    FlowUtils.resolveFlowTree((String)flowConfig);
                }
            }
            catch (Exception e) {
                log.error((Throwable)e);
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u89e3\u6790\u6d41\u7a0b\u5f02\u5e38\uff1a", (String)"FlowSubmitValidator_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]) + e.getMessage());
            }
            List aloneNodes = FlowUtils.getAloneNodes(nodesMap, (String)flowConfig);
            if (aloneNodes.isEmpty() || nodesMap.size() <= 1) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u5b58\u5728\u672a\u5173\u8054\u7684\u6d41\u7a0b\u8282\u70b9\uff1a", (String)"FlowSubmitValidator_2", (String)"mmc-phm-opplugin", (Object[])new Object[0]) + aloneNodes);
        }
    }
}

