/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.validator.version;

import java.util.Map;
import kd.bos.coderule.enums.CodeRuleEntryTypeEnum;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;

public class VersionRuleSaveValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity extendedDataEntity : this.getDataEntities()) {
            DynamicObject dataEntity = extendedDataEntity.getDataEntity();
            DynamicObjectCollection collection = dataEntity.getDynamicObjectCollection("entryentity");
            if (collection.isEmpty()) {
                this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u81f3\u5c11\u9700\u8981\u4e00\u6761\u7f16\u7801\u89c4\u5219\u5206\u6bb5\u3002", (String)"VersionRuleSaveValidator_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean hasSerialOrRandomNumber = false;
            for (DynamicObject dynamicObject : collection) {
                String codeType = dynamicObject.getString("codetype");
                CodeRuleEntryTypeEnum ruleType = CodeRuleEntryTypeEnum.getEnums((String)codeType);
                switch (ruleType) {
                    case TYPE_FIX_TEXT: {
                        this.validateConstsValue(extendedDataEntity, dynamicObject);
                        break;
                    }
                    case TYPE_RANDOM_NUMBER: {
                        hasSerialOrRandomNumber = true;
                        break;
                    }
                    case TYPE_SEQ: {
                        hasSerialOrRandomNumber = true;
                        this.validateSerialNumber(extendedDataEntity, dynamicObject);
                        break;
                    }
                    case TYPE_SYSTEM_TIME_FIELD: {
                        this.validateSystemTime(extendedDataEntity, dynamicObject);
                        break;
                    }
                }
            }
            if (hasSerialOrRandomNumber) continue;
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u89c4\u5219\u4e2d\u5fc5\u987b\u5305\u542b\u4e00\u6bb5\u201c\u968f\u673a\u7801\u201d\u6216\u8005\u201c\u6d41\u6c34\u53f7\u201d\u7c7b\u578b\u7684\u7f16\u7801\u6bb5\u3002", (String)"VersionRuleSaveValidator_1", (String)"mmc-phm-opplugin", (Object[])new Object[0]));
        }
    }

    private void validateSerialNumber(ExtendedDataEntity extendedDataEntity, DynamicObject dynamicObject) {
        int length;
        int initialValue;
        String codeSegment = dynamicObject.getString("codesegment");
        int step = dynamicObject.getInt("step");
        if (step <= 0) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u6b65\u957f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_2", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
        }
        if ((initialValue = dynamicObject.getInt("initialvalue")) <= 0) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u8d77\u59cb\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_3", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
        }
        if ((length = dynamicObject.getInt("length")) <= 0) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u957f\u5ea6\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_4", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
        }
        if (initialValue > length) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u8d77\u59cb\u503c\u201d\u4f4d\u6570\u8981\u5c0f\u4e8e\u7b49\u4e8e\u201c\u957f\u5ea6\u201d\u3002", (String)"VersionRuleSaveValidator_5", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
        }
    }

    private void validateSystemTime(ExtendedDataEntity extendedDataEntity, DynamicObject dynamicObject) {
        String codeSegment = dynamicObject.getString("codesegment");
        String dateFormat = dynamicObject.getString("dateformat");
        if (StringUtils.isBlank((CharSequence)dateFormat)) {
            this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u663e\u793a\u683c\u5f0f\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_6", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
        }
    }

    private void validateConstsValue(ExtendedDataEntity extendedDataEntity, DynamicObject dynamicObject) {
        String codeSegment = dynamicObject.getString("codesegment");
        boolean isPeriodConsts = dynamicObject.getBoolean("isperiodconsts");
        if (isPeriodConsts) {
            String constsJson = dynamicObject.getString("constsjson");
            String periodConsts = dynamicObject.getString("periodconsts");
            if (StringUtils.isBlank((CharSequence)constsJson) || StringUtils.isBlank((CharSequence)periodConsts)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u5468\u671f\u5e38\u91cf\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_7", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
                return;
            }
            Map constsMap = (Map)SerializationUtils.fromJsonString((String)constsJson, Map.class);
            for (Map.Entry entry : constsMap.entrySet()) {
                String value = String.valueOf(entry.getValue());
                if (StringUtils.isBlank((CharSequence)value)) {
                    this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c%s\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_8", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment, entry.getKey()));
                    continue;
                }
                if (!value.contains("!")) continue;
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c%s\u201d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d\u3002", (String)"VersionRuleSaveValidator_9", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment, entry.getKey()));
            }
        } else {
            String constsValue = dynamicObject.getString("constantvalue");
            if (StringUtils.isBlank((CharSequence)constsValue)) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u8bbe\u7f6e\u503c\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"VersionRuleSaveValidator_10", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
            } else if (constsValue.contains("!")) {
                this.addErrorMessage(extendedDataEntity, String.format(ResManager.loadKDString((String)"\u201c%s\u201d\u7684\u201c\u8bbe\u7f6e\u503c\u201d\u4e0d\u53ef\u5305\u542b\u7b26\u53f7\u201c!\u201d\u3002", (String)"VersionRuleSaveValidator_11", (String)"mmc-phm-opplugin", (Object[])new Object[0]), codeSegment));
            }
        }
    }
}

