/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.workbench;

import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.enums.NodeStatusChangeEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.enums.WorkbenchSubType;
import kd.mmc.phm.common.util.process.ProcessQueryUtil;
import kd.mmc.phm.common.util.process.ProcessUpdateUtil;
import kd.mmc.phm.mservice.process.ProcessAutoUpdateRunner;
import kd.mmc.phm.opplugin.validator.workbench.EventCloseValidator;

public class EventCloseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("entryid_id");
        e.getFieldKeys().add("event_startnodeid_id");
        e.getFieldKeys().add("statuschange");
        e.getFieldKeys().add("entry_node");
        e.getFieldKeys().add("event_processid");
        e.getFieldKeys().add("nodestatus");
        e.getFieldKeys().add("event_startnodeid");
        e.getFieldKeys().add("targetnodestatus");
        e.getFieldKeys().add("number");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new EventCloseValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objs;
        super.beginOperationTransaction(e);
        for (DynamicObject obj : objs = e.getDataEntities()) {
            obj.set("status", (Object)WorkbenchSubType.EVENT_PROCESSED.getValue());
        }
        SaveServiceHelper.save((DynamicObject[])objs);
        for (DynamicObject obj : objs) {
            boolean isFinish;
            long currentNodeId = obj.getLong("entry_node_id");
            long startNodeId = obj.getLong("event_startnodeid_id");
            if (this.queryEventIsExist(currentNodeId, startNodeId)) continue;
            String statuschange = obj.getString("statuschange");
            if (statuschange.equals(NodeStatusChangeEnum.RETURN_BEFROE.getValue())) {
                if (!this.queryEventIsExist(currentNodeId, null)) {
                    this.regainOrgStatus(obj, currentNodeId, "targetnodestatus");
                }
                if (!this.queryEventIsExist(startNodeId, null)) {
                    this.regainOrgStatus(obj, startNodeId, "nodestatus");
                }
                if (!this.isCanAutoUpdate(currentNodeId)) continue;
                String currentNode = obj.getDynamicObject("entry_node").getString("nodeid");
                long processHistoryId = obj.getLong("event_processid_id");
                this.invokeAutoUpdate(processHistoryId, currentNodeId, currentNode);
                continue;
            }
            if (statuschange.equals(NodeStatusChangeEnum.STOP.getValue())) {
                boolean isFinish2;
                if (this.queryEventIsExist(currentNodeId, null)) continue;
                this.regainOrgStatus(obj, currentNodeId, "nodestatus");
                if (RunningState.COMPLETED.getValue().equals(obj.getString("nodestatus")) || !(isFinish2 = ProcessQueryUtil.queryNodeFinish((Long)currentNodeId))) continue;
                this.transferNextNode(obj, currentNodeId);
                continue;
            }
            if (!statuschange.equals(NodeStatusChangeEnum.NO_CHANGE.getValue()) || this.queryEventIsExist(currentNodeId, null)) continue;
            this.regainOrgStatus(obj, currentNodeId, "nodestatus");
            if (RunningState.COMPLETED.getValue().equals(obj.getString("nodestatus")) || !(isFinish = ProcessQueryUtil.queryNodeFinish((Long)currentNodeId))) continue;
            this.transferNextNode(obj, currentNodeId);
        }
    }

    private boolean queryEventIsExist(Long currentNodeId, Long startNodeId) {
        QFilter qFilter = new QFilter("entry_node", "=", (Object)currentNodeId);
        qFilter.and(new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{WorkbenchSubType.EVENT_PROCESSING.getValue(), WorkbenchSubType.EVENT_UNPROCESSED.getValue()})));
        if (startNodeId != null) {
            qFilter.and(new QFilter("event_startnodeid", "=", (Object)startNodeId));
        }
        boolean exists = QueryServiceHelper.exists((String)"phm_process_event", (QFilter[])qFilter.toArray());
        return exists;
    }

    private boolean isCanAutoUpdate(Long currentNodeId) {
        QFilter qFilter = new QFilter("entry_node", "=", (Object)currentNodeId);
        qFilter.and(new QFilter("status", "in", (Object)Lists.newArrayList((Object[])new String[]{WorkbenchSubType.EVENT_PROCESSING.getValue(), WorkbenchSubType.EVENT_UNPROCESSED.getValue()})));
        qFilter.and(new QFilter("statuschange", "=", (Object)NodeStatusChangeEnum.RETURN_BEFROE.getValue()));
        boolean exists = QueryServiceHelper.exists((String)"phm_process_event", (QFilter[])qFilter.toArray());
        return !exists;
    }

    private void invokeAutoUpdate(Long processHistoryId, Long currentNodeId, String currentNode) {
        QFilter qFilter = new QFilter("entry_node", "=", (Object)currentNodeId);
        qFilter.and(new QFilter("status", "=", (Object)WorkbenchSubType.EVENT_PROCESSED.getValue()));
        qFilter.and(new QFilter("statuschange", "=", (Object)NodeStatusChangeEnum.RETURN_BEFROE.getValue()));
        qFilter.and(new QFilter("updatefinish", "=", (Object)"0"));
        DynamicObject[] query = BusinessDataServiceHelper.load((String)"phm_process_event", (String)"id,entry_node,event_startnodeid", (QFilter[])qFilter.toArray());
        List eventEntryIdList = Arrays.stream(query).map(x -> x.getLong("id")).collect(Collectors.toList());
        List startNodeIdSet = Arrays.stream(query).map(x -> x.getDynamicObject("event_startnodeid").getString("nodeid")).distinct().collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("update t_phm_node_event set fupdatefinish = ? where", new Object[]{"1"});
        sqlBuilder.appendIn("fdetailid", eventEntryIdList);
        DB.update((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
        ProcessAutoUpdateRunner.autoUpdate((long)processHistoryId, (String)currentNode, startNodeIdSet, (boolean)false);
    }

    private void transferNextNode(DynamicObject obj, long currentNodeId) {
        DynamicObject processHistory = obj.getDynamicObject("event_processid");
        ProcessUpdateUtil.updateNodeStatusByNodeEntryId((Long)currentNodeId, (String)RunningState.COMPLETED.getValue());
        Long processHistoryId = processHistory.getLong("id");
        ProcessUpdateUtil.processFinish((Long)processHistoryId);
    }

    private void regainOrgStatus(DynamicObject obj, long currentNodeId, String nodeType) {
        String status = obj.getString(nodeType);
        String startNodeUpdateSql = "update t_phm_process_node set fstatus = ? where  fentryid = ? ";
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (String)startNodeUpdateSql, (Object[])new Object[]{status, currentNodeId});
    }
}

