/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.workbench;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.enums.NodeStatusChangeEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.util.FlowActiveUtil;
import kd.mmc.phm.common.util.FlowNode;
import kd.mmc.phm.common.util.FlowUtils;
import kd.mmc.phm.opplugin.validator.workbench.LaunchEventValidator;

public class LaunchEventOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("subprocess_id");
        e.getFieldKeys().add("event_processid_id");
        e.getFieldKeys().add("event_startnodeid");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] objs = e.getDataEntities();
        DynamicObject obj = objs[0];
        this.dealLaunchEvent(obj);
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new LaunchEventValidator());
    }

    private void dealLaunchEvent(DynamicObject obj) {
        this.changeCurrentNodeStatus(obj);
        long subProcess = obj.getLong("subprocess_id");
        if (subProcess != 0L) {
            long currentProcess = obj.getLong("event_processid_id");
            this.creatSubProcessHistoryData(subProcess, currentProcess);
        }
    }

    private void changeCurrentNodeStatus(DynamicObject obj) {
        DynamicObject processNode;
        String statuschange = obj.getString("statuschange");
        if (statuschange.equals(NodeStatusChangeEnum.STOP.getValue()) || statuschange.equals(NodeStatusChangeEnum.RETURN_BEFROE.getValue())) {
            DynamicObject currentNode = obj.getDynamicObject("event_startnodeid");
            processNode = BusinessDataServiceHelper.loadSingle((Object)currentNode.getPkValue(), (String)"phm_process_node");
            processNode.set("node_status", (Object)RunningState.SUSPEND.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{processNode});
        }
        if (statuschange.equals(NodeStatusChangeEnum.RETURN_BEFROE.getValue())) {
            DynamicObject entryNode = obj.getDynamicObject("entry_node");
            processNode = BusinessDataServiceHelper.loadSingle((Object)entryNode.getPkValue(), (String)"phm_process_node");
            processNode.set("node_status", (Object)RunningState.RUNNING.getValue());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{processNode});
        }
    }

    private void creatSubProcessHistoryData(long subProcess, long currentProcess) {
        DynamicObject flow = BusinessDataServiceHelper.loadSingle((Object)subProcess, (String)"phm_flow_define");
        String flowConfig = flow.getString("flowconf_tag");
        if (StringUtils.isBlank((CharSequence)flowConfig)) {
            return;
        }
        DynamicObjectCollection flowNodeEntry = flow.getDynamicObjectCollection("flownodeentryentity");
        Map nodesMap = FlowActiveUtil.getNodesMap((DynamicObjectCollection)flowNodeEntry);
        FlowNode rootNode = FlowUtils.resolveFlowTree((String)flowConfig);
        if (rootNode == null) {
            return;
        }
        FlowActiveUtil.removeNotExitNode((Map)nodesMap, (FlowNode)rootNode);
        ArrayList runNodeIds = new ArrayList(8);
        ArrayList finishNodeIds = new ArrayList(8);
        FlowActiveUtil.addRunNodeId(runNodeIds, finishNodeIds, (Map)nodesMap, (List)rootNode.getChildren(), (int)rootNode.getChildren().size());
        FlowActiveUtil.addDatasToHistory((DynamicObject)flow, runNodeIds, finishNodeIds, (Map)nodesMap, (long)currentProcess, (String)"1");
    }
}

