/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.workbench;

import java.util.Collection;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeforeOperationArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.entity.validate.ErrorLevel;
import kd.bos.entity.validate.ValidationErrorInfo;
import kd.bos.orm.util.CollectionUtils;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.mservice.process.ManualUpdate;
import kd.mmc.phm.opplugin.validator.workbench.ManualUpdateValidator;

public class ProcessManualUpdateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        e.getFieldKeys().add("status");
        e.getFieldKeys().add("flowdefine_id");
        e.getFieldKeys().add("updatestatus");
        e.getFieldKeys().add("parentid");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ManualUpdateValidator());
    }

    public void beforeExecuteOperationTransaction(BeforeOperationArgs e) {
        List dataEntities = e.getValidExtDataEntities();
        for (ExtendedDataEntity entity : dataEntities) {
            this.manualUpdate(entity);
        }
    }

    public void manualUpdate(ExtendedDataEntity entity) {
        DynamicObject dynamicObject = entity.getDataEntity();
        long historyId = dynamicObject.getLong("id");
        long flowDefineId = dynamicObject.getLong("flowdefine_id");
        long parentId = dynamicObject.getLong("parentid");
        if (parentId == 0L) {
            DynamicObjectCollection errorLogs = ProcessCalcLogService.getRightErrorLogs((Long)historyId, null);
            if (errorLogs == null || errorLogs.isEmpty()) {
                return;
            }
            List errorMsg = ManualUpdate.dealProcessError((DynamicObject)dynamicObject, (DynamicObjectCollection)errorLogs);
            if (!CollectionUtils.isEmpty((Collection)errorMsg)) {
                for (String error : errorMsg) {
                    this.addErrMessage(historyId, entity.getDataEntityIndex(), error);
                }
            }
        } else {
            ManualUpdate.manualUpdateAll((long)historyId);
        }
    }

    private void addErrMessage(long id, int dataIndex, String errMsg) {
        int rowIndex = 0;
        ErrorLevel errorLevel = ErrorLevel.Error;
        ValidationErrorInfo errInfo = new ValidationErrorInfo("", (Object)id, dataIndex, rowIndex, "beforeExecuteOperationTransaction", ResManager.loadKDString((String)"\u624b\u5de5\u66f4\u65b0", (String)"ProcessManualUpdateOp_0", (String)"mmc-phm-opplugin", (Object[])new Object[0]), errMsg, errorLevel);
        this.operationResult.addErrorInfo((OperateErrorInfo)errInfo);
    }
}

