/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.opplugin.workbench;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.opplugin.validator.workbench.ProcessOwnerValidator;

public class ProcessRerunOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("flowdefine_id");
        fieldKeys.add("status");
        fieldKeys.add("exceptiondesc");
        fieldKeys.add("node_status");
        fieldKeys.add("node_finishtime");
        fieldKeys.add("suspendduration");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new ProcessOwnerValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Date now = new Date();
        DynamicObject dataEntity = e.getDataEntities()[0];
        String exceptionDesc = dataEntity.getString("exceptiondesc");
        if (!StringUtils.isBlank((CharSequence)exceptionDesc)) {
            dataEntity.set("status", (Object)RunningState.ERROR.getValue());
        }
        DynamicObjectCollection entryentity = dataEntity.getDynamicObjectCollection("entryentity");
        for (DynamicObject entry : entryentity) {
            Date finishTime;
            String nodeStatus = entry.getString("node_status");
            if (!RunningState.RUNNING.getValue().equals(nodeStatus) || (finishTime = entry.getDate("node_finishtime")) == null) continue;
            BigDecimal suspendDuration = entry.getBigDecimal("suspendduration");
            suspendDuration = suspendDuration.add(this.calcRuntime(finishTime, now));
            entry.set("node_finishtime", null);
            entry.set("suspendduration", (Object)suspendDuration);
        }
    }

    private BigDecimal calcRuntime(Date startDate, Date endDate) {
        return new BigDecimal(String.valueOf(endDate.getTime())).subtract(new BigDecimal(String.valueOf(startDate.getTime()))).divide(new BigDecimal(String.valueOf(86400000)), 1, 4);
    }
}

