/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.QueueManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.zk.ZKFactory;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.api.ICalcRuntimeService;
import kd.mmc.phm.mservice.framework.IEnvProvider;
import kd.mmc.phm.mservice.framework.mq.consumer.CtrlConsumer;
import kd.mmc.phm.mservice.framework.mq.event.MQEvent;
import kd.mmc.phm.mservice.framework.mq.event.ManuStopEvent;
import kd.mmc.phm.mservice.framework.mq.event.RefreshEvent;
import kd.mmc.phm.mservice.framework.mq.event.SnapshotCancelEvent;
import kd.mmc.phm.mservice.framework.mq.event.SnapshotCreateEvent;
import kd.mmc.phm.mservice.framework.mq.event.SnapshotSaveEvent;
import kd.mmc.phm.mservice.framework.mq.event.StartEvent;
import kd.mmc.phm.mservice.framework.runner.CalcManager;
import kd.mmc.phm.mservice.framework.runner.ICalcRunner;
import kd.mmc.phm.mservice.integrate.IntegrateFactory;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudMetaConsts;
import kd.mmc.phm.mservice.integrate.kdcloud.parser.PHMJsonNodeParser;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.enums.BizModelCalcStatus;
import kd.mmc.phm.mservice.utils.Utils;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class CalcRuntimeService
implements ICalcRuntimeService {
    public void startCalc(DynamicObject model) {
        DynamicObject[] infos;
        String resId = String.valueOf(model.get("id"));
        String tag = System.getProperty("mq.debug.queue.tag");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((String)tag)) {
            filters.add(new QFilter("mqtag", "=", (Object)tag));
        }
        filters.add(new QFilter("calc_res_regist_entry.resmodelid", "=", (Object)resId));
        block0: for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"phm_calc_resregist", (String)"instid, instip, mqtag, calc_res_regist_entry.resmodelid", (QFilter[])filters.toArray(new QFilter[0]))) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("calc_res_regist_entry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entry.get(i);
                String resmodelid = dynamicObject.getString("resmodelid");
                if (!resmodelid.equals(resId)) continue;
                entry.remove((Object)dynamicObject);
                continue block0;
            }
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        this.startNew(model, null, null, null);
    }

    public void startCalcByChange(DynamicObject model, Map<String, Serializable> changeMap) {
        DynamicObject[] infos;
        String resId = String.valueOf(model.get("id"));
        String tag = System.getProperty("mq.debug.queue.tag");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((String)tag)) {
            filters.add(new QFilter("mqtag", "=", (Object)tag));
        }
        filters.add(new QFilter("calc_res_regist_entry.resmodelid", "=", (Object)resId));
        block0: for (DynamicObject info : infos = BusinessDataServiceHelper.load((String)"phm_calc_resregist", (String)"instid, instip, mqtag, calc_res_regist_entry.resmodelid", (QFilter[])filters.toArray(new QFilter[0]))) {
            DynamicObjectCollection entry = info.getDynamicObjectCollection("calc_res_regist_entry");
            for (int i = 0; i < entry.size(); ++i) {
                DynamicObject dynamicObject = (DynamicObject)entry.get(i);
                String resmodelid = dynamicObject.getString("resmodelid");
                if (!resmodelid.equals(resId)) continue;
                entry.remove((Object)dynamicObject);
                continue block0;
            }
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        HashMap change = (HashMap)changeMap;
        this.startNew(model, null, null, change);
    }

    public void stopCalc(String resId, Map<String, Serializable> params) {
        MessagePublisher publisher;
        DynamicObject serverInfo = this.getServerInfo(resId);
        if (serverInfo == null) {
            return;
        }
        try {
            publisher = this.createPublisher(serverInfo.getString("instid"), resId);
        }
        catch (Throwable e) {
            this.deleteResEntryRegistInfo(serverInfo, resId);
            throw new KDBizException(e, new ErrorCode("", ResManager.loadKDString((String)"\u4e8b\u4ef6\u6d3e\u53d1\u5931\u8d25\uff1a%s", (String)"CalcRuntimeService_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        ManuStopEvent evt = new ManuStopEvent();
        evt.setEnvId(resId);
        evt.setParams(params);
        this.publish(publisher, evt);
    }

    public HashMap<String, Serializable> queryLatestStatus(String resId) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        boolean ies = this.isExistSnapshot(resId);
        ret.put("ies", Boolean.valueOf(ies));
        if (ies) {
            ret.put("status", (Serializable)((Object)BizModelCalcStatus.FINISHED.getValue()));
            ret.put("progress", Integer.valueOf(100));
            return ret;
        }
        DynamicObject serverInfo = this.getServerInfo(resId);
        if (serverInfo == null) {
            ret.put("status", (Serializable)((Object)BizModelCalcStatus.UNREGIST.getValue()));
            ret.put("progress", Integer.valueOf(0));
            return ret;
        }
        DynamicObject logInfo = BusinessDataServiceHelper.loadSingle((String)"phm_bizmodel_calclog", (String)"status, progress,entryentity.entry_status", (QFilter[])new QFilter[]{new QFilter("calcid", "=", (Object)SysConsts.createCtrlMQId((String)serverInfo.getString("instid"), (String)resId))});
        if (logInfo == null) {
            ret.put("status", (Serializable)((Object)BizModelCalcStatus.UNSTART.getValue()));
            ret.put("progress", Integer.valueOf(0));
            return ret;
        }
        DynamicObjectCollection entryEntity = logInfo.getDynamicObjectCollection("entryentity");
        int cSize = 0;
        for (DynamicObject dynamicObject : entryEntity) {
            String entry_status = dynamicObject.getString("entry_status");
            if (!"C".equals(entry_status)) continue;
            ++cSize;
        }
        if (cSize > 0 && cSize == entryEntity.size()) {
            logInfo.set("status", (Object)"C");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{logInfo});
        }
        ret.put("status", (Serializable)((Object)logInfo.getString("status")));
        ret.put("progress", Integer.valueOf(logInfo.getInt("progress")));
        return ret;
    }

    public HashMap<String, Serializable> queryResRuntimeDatas(String resId, String key) {
        if (StringUtils.isEmpty((String)key)) {
            throw new KDBizException(new ErrorCode("EMPRT_SNAPSHOT_KEY", "empty snapshot key for model(%s)."), new Object[]{resId});
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc");
        String result = (String)cache.get(resId, key);
        if (StringUtils.isEmpty((String)result)) {
            throw new KDBizException(new ErrorCode("PHM_NO_MODEL_RESULT", "model(%s) is not finished."), new Object[]{resId});
        }
        HashMap all = (HashMap)JSON.parseObject((String)result, HashMap.class);
        return all;
    }

    public String start2CreateSnapshot(String resId, Map<String, Serializable> filterParams) {
        String userId = RequestContext.get().getUserId();
        String key = UUID.randomUUID().toString();
        DynamicObject serverInfo = this.getServerInfo(resId);
        if (serverInfo == null) {
            throw new KDBizException(new ErrorCode("PHM_NO_MODEL_INST", "model(%s) is not regist."), new Object[]{resId});
        }
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc");
        cache.put(resId, KDCloudMetaConsts.createSnapshotStatusKey(key), (Object)BizModelCalcStatus.CALCULATING.getValue());
        MessagePublisher publisher = this.createPublisher(serverInfo.getString("instid"), resId);
        SnapshotCreateEvent evt = new SnapshotCreateEvent();
        evt.setEnvId(resId);
        evt.getParams().put("userId", (Serializable)((Object)userId));
        evt.getParams().put("filterParams", (Serializable)((Object)(filterParams == null ? "" : JSON.toJSONString(filterParams))));
        evt.getParams().put("random", (Serializable)((Object)key));
        this.publish(publisher, evt);
        return key;
    }

    public HashMap<String, Serializable> querySnapshotStatus(String resId, String key) {
        HashMap<String, Serializable> ret = new HashMap<String, Serializable>();
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("mmc");
        ret.put("sscp", (Serializable)cache.get(resId, KDCloudMetaConsts.createSnapshotStatusKey(key)));
        ret.put("sscf", (Serializable)cache.get(resId, KDCloudMetaConsts.createSnapshotFailedKey(key)));
        return ret;
    }

    public void saveModelSnapshot(String resId, String userId, HashMap<String, Serializable> params) {
        DynamicObject serverInfo = this.getServerInfo(resId);
        ORM orm = ORM.create();
        DynamicObject model = orm.queryOne("phm_bizmodel", new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(resId))});
        if (serverInfo != null) {
            if (StringUtils.isEmpty((String)userId)) {
                this.startReCalc(serverInfo, model);
            } else {
                SnapshotSaveEvent evt = new SnapshotSaveEvent();
                evt.setEnvId(resId);
                evt.getParams().put("userId", (Serializable)((Object)userId));
                evt.getParams().put("filterParams", params);
                MessagePublisher publisher = this.createPublisher(serverInfo.getString("instid"), resId);
                publisher.publish((Object)evt);
            }
        } else {
            this.startNew(model, userId, params, null);
        }
    }

    public void cancelModelSnapshot(String resId, String userId) {
        DynamicObject serverInfo = this.getServerInfo(resId);
        if (serverInfo != null && !StringUtils.isEmpty((String)userId)) {
            SnapshotCancelEvent evt = new SnapshotCancelEvent();
            evt.setEnvId(resId);
            evt.getParams().put("userId", (Serializable)((Object)userId));
            MessagePublisher publisher = this.createPublisher(serverInfo.getString("instid"), resId);
            publisher.publish((Object)evt);
        } else {
            if (StringUtils.isEmpty((String)userId)) {
                userId = RequestContext.get().getUserId();
            }
            ORM orm = ORM.create();
            QFilter[] filters = new QFilter[]{new QFilter("resourceid", "=", (Object)resId), new QFilter("userid", "=", (Object)userId)};
            orm.delete("bizmodelsnapshot", filters);
        }
    }

    public HashMap<String, Serializable> getLatestSnapshotByUser(String resId) {
        ORM orm = ORM.create();
        String userId = RequestContext.get().getUserId();
        QFilter[] filters = new QFilter[]{new QFilter("resourceid", "=", (Object)resId), new QFilter("userid", "=", (Object)userId)};
        DynamicObject snapshot = orm.queryOne("bizmodelsnapshot", filters);
        if (snapshot != null) {
            HashMap all = (HashMap)JSON.parseObject((String)snapshot.getString("snapshot_tag"), HashMap.class);
            String filterStr = snapshot.getString("filtercontent_tag");
            all.put("filtercontent_tag", JSON.parseArray((String)filterStr));
            return all;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String testFeatureQueryDefine(Map<String, String> define) {
        ICalcRunner runner = null;
        try {
            ICalculator node = PHMJsonNodeParser.parseFromFeatureQueryDefineByMap(define, null);
            HashMap<String, ICalculator> roots = new HashMap<String, ICalculator>();
            roots.put(node.getId(), node);
            IEnvProvider env = IntegrateFactory.createEnv(UUID.randomUUID().toString());
            runner = env.createRunner();
            CalcEnv calcEnv = new CalcEnv(env, roots);
            env.createEnvAware().onStart(calcEnv);
            node.calc(calcEnv);
            env.createEnvAware().onFinish(calcEnv);
        }
        finally {
            if (runner != null) {
                runner.shutdown();
            }
        }
        return "";
    }

    private void startNew(DynamicObject model, String userId, HashMap<String, Serializable> params, HashMap<String, Serializable> change_map) {
        DynamicObject serverInfo = BusinessDataServiceHelper.loadSingle((String)"phm_calc_resregist", (String)"instid, calc_res_regist_entry.resmodelid, calc_res_regist_entry.resmodelname, calc_res_regist_entry.createtime", (QFilter[])new QFilter[]{new QFilter("instip", "=", (Object)Utils.getIP())});
        if (serverInfo == null) {
            DispatchServiceHelper.invokeBizService((String)"mmc", (String)"phm", (String)"Service", (String)"start", (Object[])new Object[0]);
            serverInfo = BusinessDataServiceHelper.loadSingle((String)"phm_calc_resregist", (String)"instid, calc_res_regist_entry.resmodelid, calc_res_regist_entry.resmodelname, calc_res_regist_entry.createtime", (QFilter[])new QFilter[]{new QFilter("instip", "=", (Object)Utils.getIP())});
        }
        String modelId = String.valueOf(model.get("id"));
        IEnvProvider env = IntegrateFactory.createEnv(modelId);
        String envId = env.getEnvId();
        env.createMQProvider().registCtrlQueue(envId, CtrlConsumer.class);
        CalcManager.registRT(env);
        this.addResEntryRegistInfo(serverInfo, modelId, String.valueOf(model.get("name")));
        MessagePublisher publisher = this.createPublisher(SysConsts.NODE_ID, env.getEnvId());
        StartEvent evt = this.createStartEvt(envId, model, null);
        evt.getParams().put("userId", (Serializable)((Object)userId));
        evt.getParams().put("filterParams", params);
        evt.getParams().put("change_map", change_map);
        this.publish(publisher, evt);
    }

    private void startReCalc(DynamicObject serverInfo, DynamicObject model) {
        String resId = String.valueOf(model.get("id"));
        DynamicObject logInfo = BusinessDataServiceHelper.loadSingle((String)"phm_bizmodel_calclog", (String)"status, progress", (QFilter[])new QFilter[]{new QFilter("calcid", "=", (Object)SysConsts.createCtrlMQId((String)serverInfo.getString("instid"), (String)resId))});
        if (logInfo != null) {
            logInfo.set("status", (Object)BizModelCalcStatus.STARTED.getValue());
            logInfo.set("progress", (Object)0);
            SaveServiceHelper.update((DynamicObject)logInfo);
            BaseDataServiceHelper.clearCache((DynamicObject)logInfo);
        }
        MessagePublisher publisher = this.createPublisher(serverInfo.getString("instid"), resId);
        RefreshEvent evt = new RefreshEvent();
        evt.setEnvId(resId);
        evt.getParams().put("model", (Serializable)model);
        this.publish(publisher, evt);
    }

    private StartEvent createStartEvt(String envId, DynamicObject model, String consumerQueueId) {
        StartEvent evt = new StartEvent();
        evt.setEnvId(envId);
        evt.getParams().put("model", (Serializable)model);
        evt.getParams().put("customConsumerQueueId", (Serializable)((Object)consumerQueueId));
        return evt;
    }

    private boolean isExistSnapshot(String resId) {
        ORM orm = ORM.create();
        String userId = RequestContext.get().getUserId();
        QFilter[] filters = new QFilter[]{new QFilter("resourceid", "=", (Object)resId), new QFilter("userid", "=", (Object)userId)};
        boolean ies = orm.exists("bizmodelsnapshot", filters);
        return ies;
    }

    private void addResEntryRegistInfo(DynamicObject serverInfo, String resModelId, String resModelName) {
        SysConsts.client = ZKFactory.getZKClient((String)System.getProperty("configUrl"));
        Stat stat = null;
        try {
            SysConsts.zk = SysConsts.client.getZookeeperClient().getZooKeeper();
            stat = SysConsts.zk.exists("/" + Instance.getClusterName() + "/" + serverInfo.getString("instid"), false);
            if (stat == null) {
                SysConsts.zk.create("/" + Instance.getClusterName() + "/" + SysConsts.NODE_ID, "".getBytes("UTF-8"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"ZooKeeper\u5f02\u5e38\uff1a%s", (String)"CalcRuntimeService_1", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        DynamicObjectCollection entrys = serverInfo.getDynamicObjectCollection("calc_res_regist_entry");
        DynamicObject entry = new DynamicObject(entrys.getDynamicObjectType());
        entry.set("resmodelid", (Object)resModelId);
        entry.set("resmodelname", (Object)resModelName);
        entry.set("createtime", (Object)System.currentTimeMillis());
        entrys.add((Object)entry);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{serverInfo});
    }

    private void deleteResEntryRegistInfo(DynamicObject serverInfo, String resModelId) {
        DynamicObjectCollection entrys = serverInfo.getDynamicObjectCollection("calc_res_regist_entry");
        ArrayList<DynamicObject> removes = new ArrayList<DynamicObject>();
        for (DynamicObject last : entrys) {
            if (!resModelId.equals(last.getString("resmodelid"))) continue;
            removes.add(last);
        }
        for (DynamicObject last : removes) {
            entrys.remove((Object)last);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{serverInfo});
    }

    private MessagePublisher createPublisher(String nodeId, String resId) {
        String queueName = SysConsts.createCtrlQueueName((String)nodeId, (String)resId);
        String queueRealName = QueueManager.getRealQueueName((String)"mmc", (String)queueName);
        QueueDef def = QueueManager.getQueueDefWithRealQueueName((String)"mmc", (String)queueRealName);
        if (def == null) {
            QueueDef queueDef = new QueueDef();
            queueDef.setAppid("phm");
            queueDef.setName(queueName);
            QueueManager.add((String)"mmc", (QueueDef)queueDef, (boolean)false);
        }
        MessagePublisher publisher = MQFactory.get().createSimplePublisher("mmc", queueName);
        return publisher;
    }

    private void publish(MessagePublisher publisher, MQEvent evt) {
        try {
            publisher.publish((Object)evt);
        }
        finally {
            publisher.close();
        }
    }

    private DynamicObject getServerInfo(String resId) {
        String tag = System.getProperty("mq.debug.queue.tag");
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        if (!StringUtils.isEmpty((String)tag)) {
            filters.add(new QFilter("mqtag", "=", (Object)tag));
        }
        filters.add(new QFilter("calc_res_regist_entry.resmodelid", "=", (Object)resId));
        DynamicObject[] infos = BusinessDataServiceHelper.load((String)"phm_calc_resregist", (String)"instid, instip, mqtag, calc_res_regist_entry.resmodelid", (QFilter[])filters.toArray(new QFilter[0]));
        if (infos == null || infos.length == 0) {
            return null;
        }
        String ip = Utils.getIP();
        DynamicObject serverInfo = null;
        for (int i = 0; i < infos.length && !ip.equals((serverInfo = infos[i]).getString("instip")); ++i) {
            if (StringUtils.isEmpty((String)tag)) continue;
            serverInfo = null;
        }
        return this.testConnection(serverInfo, resId);
    }

    private DynamicObject testConnection(DynamicObject serverInfo, String resId) {
        if (serverInfo == null) {
            return null;
        }
        try {
            ZooKeeper zk = SysConsts.zk;
            Stat stat = zk.exists("/" + Instance.getClusterName() + "/" + serverInfo.getString("instid"), false);
            if (stat == null) {
                this.deleteResEntryRegistInfo(serverInfo, resId);
                DynamicObject dynamicObject = null;
                return dynamicObject;
            }
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8fde\u63a5\u5931\u8d25\uff1a%s", (String)"CalcRuntimeService_2", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return serverInfo;
    }
}

