/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.ThreeTuple;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.util.DBUtils;
import kd.mmc.phm.common.util.DataTableCompareUtils;
import kd.mmc.phm.mservice.api.ITaskHandleService;

public class TaskHandleService
implements ITaskHandleService {
    private static final Log LOG = LogFactory.getLog(TaskHandleService.class);

    public void afterTask(Map<String, Object> params) {
        String event = (String)params.get("event");
        if (!"OnTaskSuccess".equals(event)) {
            return;
        }
        String triggerNumber = (String)params.get("trigger_number");
        List threeTuples = DataTableCompareUtils.getOrCreateBackupTable((List)Lists.newArrayList((Object[])new String[]{triggerNumber}));
        if (threeTuples.isEmpty()) {
            LOG.warn(ResManager.loadKDString((String)"\u83b7\u53d6\u5907\u4efd\u8868\u5931\u8d25, event: {}, triggerNumber: {}", (String)"TaskHandleService_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), (Object)event, (Object)triggerNumber);
            return;
        }
        ThreeTuple threeTuple = (ThreeTuple)threeTuples.get(0);
        String tableName = (String)threeTuple.item1;
        String backupTableName = (String)threeTuple.item2;
        this.onTaskSuccess(tableName, backupTableName);
    }

    private void onTaskSuccess(String tableName, String backupTableName) {
        LOG.info(ResManager.loadKDString((String)"\u5f00\u59cb\u6bd4\u8f83\u4e24\u4e2a\u8868\u6570\u636e, tableName: {}, backupTableName: {}", (String)"TaskHandleService_1", (String)"mmc-phm-mservice", (Object[])new Object[0]), (Object)tableName, (Object)backupTableName);
        String primaryKey = (String)DB.getPrimaryKeys((DBRoute)CommonConsts.ROUTE_PHM, (String)tableName).get(0);
        String countSql = "SELECT COUNT(%s) FROM %s";
        int oldDataCount = (Integer)DB.query((DBRoute)CommonConsts.ROUTE_PHM, (String)String.format(countSql, primaryKey, backupTableName), rs -> rs.next() ? rs.getInt(1) : 0);
        int newDataCount = (Integer)DB.query((DBRoute)CommonConsts.ROUTE_PHM, (String)String.format(countSql, primaryKey, tableName), rs -> rs.next() ? rs.getInt(1) : 0);
        int dataCount = Math.min(oldDataCount, newDataCount);
        List columnNames = DB.getColumnNames((DBRoute)CommonConsts.ROUTE_PHM, (String)tableName);
        String selectFields = String.join((CharSequence)",", columnNames);
        String sqlFormat = "SELECT TOP %d,%d %s FROM %s ORDER BY " + primaryKey + " ASC";
        int batchSize = 50000;
        int times = DBUtils.calculateTimes((int)dataCount, (int)batchSize);
        int topStartIndex = 0;
        HashMap primaryKey2Value = Maps.newHashMapWithExpectedSize((int)(times == 1 ? 16 : batchSize));
        HashMap<Object, Row> rowMap = new HashMap<Object, Row>(16);
        HashSet<String> modifyFields = new HashSet<String>();
        for (int i = 0; i < times; ++i) {
            try (DataSet oldDataSet = this.getOldDataSet(sqlFormat, batchSize, topStartIndex, selectFields, backupTableName);
                 DataSet newDataSet = this.getNewDataSet(sqlFormat, batchSize, topStartIndex, selectFields, tableName);){
                boolean equals;
                Object newValue;
                DataType dataType;
                Object oldValue;
                String columnName;
                int j;
                int columnNamesSize;
                RowMeta rowMeta = newDataSet.getRowMeta();
                if (oldDataSet.isEmpty() || newDataSet.isEmpty()) break;
                for (Row row : newDataSet) {
                    primaryKey2Value.put(row.get(primaryKey), rowMeta.toMap(row));
                }
                Iterator iterator = rowMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    Object primaryValue = entry.getValue();
                    Map valueMap = (Map)primaryKey2Value.get(primaryValue);
                    if (valueMap == null) continue;
                    Row row = (Row)entry.getValue();
                    columnNamesSize = columnNames.size();
                    for (j = 0; j < columnNamesSize; ++j) {
                        columnName = (String)columnNames.get(j);
                        if (modifyFields.contains(columnName)) continue;
                        oldValue = valueMap.get(columnName);
                        dataType = rowMeta.getDataType(j);
                        newValue = DataType.convertValue((DataType)dataType, (Object)row.get(j));
                        equals = dataType == DataType.BigDecimalType ? ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0 : Objects.equals(oldValue, newValue);
                        if (equals) continue;
                        modifyFields.add(columnName);
                    }
                    iterator.remove();
                }
                for (Row row : oldDataSet) {
                    Object primaryValue = row.get(primaryKey);
                    Map valueMap = (Map)primaryKey2Value.get(primaryValue);
                    if (valueMap == null) {
                        rowMap.put(primaryValue, row);
                        continue;
                    }
                    columnNamesSize = columnNames.size();
                    for (j = 0; j < columnNamesSize; ++j) {
                        columnName = (String)columnNames.get(j);
                        if (modifyFields.contains(columnName)) continue;
                        oldValue = valueMap.get(columnName);
                        dataType = rowMeta.getDataType(j);
                        newValue = DataType.convertValue((DataType)dataType, (Object)row.get(j));
                        equals = dataType == DataType.BigDecimalType ? ((BigDecimal)oldValue).compareTo((BigDecimal)newValue) == 0 : Objects.equals(oldValue, newValue);
                        if (equals) continue;
                        modifyFields.add(columnName);
                    }
                }
                topStartIndex += batchSize;
                continue;
            }
        }
        DataTableCompareUtils.saveDifferenceInfo((String)tableName, modifyFields);
    }

    private DataSet getOldDataSet(String sqlFormat, int batchSize, int topStartIndex, String selectFields, String backupTableName) {
        DataSet oldDataSet = DB.queryDataSet((String)"TaskHandleService.getOldData", (DBRoute)CommonConsts.ROUTE_PHM, (String)String.format(sqlFormat, batchSize, topStartIndex, selectFields, backupTableName));
        return oldDataSet;
    }

    private DataSet getNewDataSet(String sqlFormat, int batchSize, int topStartIndex, String selectFields, String tableName) {
        DataSet newDataSet = DB.queryDataSet((String)"TaskHandleService.getNewData", (DBRoute)CommonConsts.ROUTE_PHM, (String)String.format(sqlFormat, batchSize, topStartIndex, selectFields, tableName));
        return newDataSet;
    }
}

