/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.framework.mq;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.List;
import kd.bos.instance.Instance;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.support.QueueManager;
import kd.bos.mq.support.dynamic.DynamicQueueManager;
import kd.bos.mq.support.dynamic.DynamicQueueManagerFactory;
import kd.mmc.phm.mservice.framework.mq.event.PHMEvent;

public class MQServiceHelper {
    private MQServiceHelper() {
        throw new UnsupportedOperationException();
    }

    public static void registControlQueue(String controlQueueName, Class<? extends MessageConsumer> clazz) {
        if (Instance.isLightWeightDeploy()) {
            return;
        }
        ConsumerDef consumerDef = new ConsumerDef();
        consumerDef.setClassName(clazz.getName());
        QueueDef queueDef = new QueueDef();
        queueDef.setAppid("phm");
        queueDef.setName(controlQueueName);
        queueDef.setConsumers((List)Lists.newArrayList((Object[])new ConsumerDef[]{consumerDef}));
        QueueManager.add((String)"mmc", (QueueDef)queueDef, (boolean)true);
    }

    public static void destroyControlQueue(String controlQueueName) {
        DynamicQueueManager dynamicQueueManager = DynamicQueueManagerFactory.get((String)"mmc");
        dynamicQueueManager.deleteQueue(controlQueueName);
    }

    public static void publishCalcEvent(PHMEvent event) {
        MQServiceHelper.publishMessage("kd.mmc.phm.framework.mq.consumer.phm_queue", event);
    }

    public static void publishMessage(String queueName, Serializable message) {
        MQServiceHelper.publishMessage("mmc", queueName, message);
    }

    public static void publishControlEvent(PHMEvent event) {
        String controlQueueName = event.getControlQueueName();
        QueueDef queueDef = QueueManager.get((String)"mmc", (String)controlQueueName);
        if (queueDef == null) {
            queueDef = new QueueDef();
            queueDef.setAppid("mmc");
            queueDef.setName(controlQueueName);
            QueueManager.add((String)"mmc", (QueueDef)queueDef, (boolean)false);
        }
        MQServiceHelper.publishMessage(controlQueueName, event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void publishMessage(String region, String queueName, Serializable message) {
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher(region, queueName);){
            publisher.publish((Object)message);
        }
    }

    public static String getRealControlQueueName(String controlQueueName, String eventId) {
        return controlQueueName + "." + eventId;
    }
}

