/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.framework.mq.consumer;

import com.alibaba.fastjson.JSON;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.util.StringUtils;
import kd.mmc.phm.mservice.framework.IEnvProvider;
import kd.mmc.phm.mservice.framework.mq.event.MQEvent;
import kd.mmc.phm.mservice.framework.mq.event.ManuStopEvent;
import kd.mmc.phm.mservice.framework.mq.event.RefreshEvent;
import kd.mmc.phm.mservice.framework.mq.event.SnapshotCancelEvent;
import kd.mmc.phm.mservice.framework.mq.event.SnapshotCreateEvent;
import kd.mmc.phm.mservice.framework.mq.event.SnapshotSaveEvent;
import kd.mmc.phm.mservice.framework.mq.event.StartEvent;
import kd.mmc.phm.mservice.framework.mq.event.SubCalcFinishEvent;
import kd.mmc.phm.mservice.framework.runner.CalcManager;
import kd.mmc.phm.mservice.model.enums.BizModelCalcStatus;
import kd.mmc.phm.mservice.model.status.StatusSummary;

public class CtrlConsumer
implements MessageConsumer {
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        MQEvent event = (MQEvent)message;
        IEnvProvider env = CalcManager.getRT(event.getEnvId());
        Map<String, Serializable> params = event.getParams();
        if (event instanceof StartEvent) {
            StatusSummary status = env.createRunner().getStatus();
            if (status == null || status.getStatus() != BizModelCalcStatus.CALCULATING) {
                env.createRunner().start((StartEvent)event);
            }
        } else if (event instanceof SnapshotCreateEvent) {
            String key = params.get("random").toString();
            String json = params.get("filterParams").toString();
            HashMap filters = null;
            if (!StringUtils.isEmpty((String)json)) {
                filters = (HashMap)JSON.parseObject((String)json, HashMap.class);
            }
            env.createRunner().cacheLatestResult(key, filters);
        } else if (event instanceof SnapshotSaveEvent) {
            String userId = params.get("userId").toString();
            HashMap filters = (HashMap)params.get("filterParams");
            env.createRunner().saveLatestSnapshot(userId, filters);
        } else if (event instanceof SnapshotCancelEvent) {
            String userId = params.get("userId").toString();
            env.createRunner().deleteLastSnapshot(userId);
        } else if (event instanceof ManuStopEvent) {
            env.createRunner().shutdown();
            CalcManager.destroyRT(event.getEnvId());
        } else if (event instanceof RefreshEvent) {
            env.createRunner().reCalc((RefreshEvent)event);
        } else if (event instanceof SubCalcFinishEvent) {
            CalcManager.getRT(event.getEnvId()).createMQProvider().response((SubCalcFinishEvent)event);
        }
        acker.ack(messageId);
    }
}

