/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.framework.mq.consumer;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import javax.xml.crypto.Data;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.SqlBuilder;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.MainDataUpateParam;
import kd.mmc.phm.common.enums.DataTempClassifyEnum;
import kd.mmc.phm.common.enums.DataTempDataSourceEnum;
import kd.mmc.phm.common.enums.FieldType;
import kd.mmc.phm.common.enums.ResourceTypeEnum;
import kd.mmc.phm.common.enums.RunningState;
import kd.mmc.phm.common.spread.SpreadPraseUtil;
import kd.mmc.phm.common.spread.SpreadUtils;
import kd.mmc.phm.mservice.framework.mq.event.ProcessDataUpdateEvent;

public class ProcessDataTableUpateConsumer
implements MessageConsumer {
    private static final Log logger = LogFactory.getLog(ProcessDataTableUpateConsumer.class);
    private static final ExecutorService executorService = ThreadPools.newCachedExecutorService((String)"PHM_PROCESS_DATATABLE_UPDATE", (int)2, (int)4);
    private static final String AGLOKEY = "ProcessDataTableUpateConsumer";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Object body, String messageId, boolean resend, MessageAcker messageAcker) {
        ArrayList<CompletableFuture<Void>> futureList = null;
        ProcessDataUpdateEvent event = (ProcessDataUpdateEvent)body;
        Long nodeId = event.getNodeId();
        String status = event.getNodeStatus();
        try {
            DynamicObject[] resources = this.queryProcessNodeResource(nodeId);
            if (resources == null || resources.length == 0) {
                return;
            }
            futureList = new ArrayList<CompletableFuture<Void>>(resources.length);
            RequestContext rc = RequestContext.get();
            for (DynamicObject resource : resources) {
                CompletableFuture<Void> future = CompletableFuture.runAsync(() -> this.updateResourceData(resource, event, rc), executorService);
                futureList.add(future);
            }
        }
        catch (Exception e2) {
            logger.error("\u6d41\u7a0b\u6570\u636e\u8868\u6570\u636e\u66f4\u65b0\u5931\u8d25", (Throwable)e2);
        }
        finally {
            if (futureList == null || futureList.isEmpty()) {
                this.updateNodeStatus(event.getProcessHistoryId(), nodeId, status, event.getUpateParams());
            } else {
                CompletableFuture.allOf(futureList.toArray(new CompletableFuture[0])).whenComplete((r, e) -> this.updateNodeStatus(event.getProcessHistoryId(), nodeId, status, event.getUpateParams()));
            }
        }
        messageAcker.ack(messageId);
    }

    private void updateResourceData(DynamicObject resource, ProcessDataUpdateEvent event, RequestContext rc) {
        if (resource == null) {
            return;
        }
        DynamicObject resourceObj = resource.getDynamicObject("resource_number");
        if (resourceObj == null) {
            return;
        }
        logger.error("\u66f4\u65b0\u6570\u636e\u8d44\u6e90%s", resourceObj.get("number"));
        RequestContext.copyAndSet((RequestContext)rc);
        try (TXHandle tx = TX.requiresNew();){
            String resourceType = resource.getString("resource_type");
            if (!ResourceTypeEnum.DATETEMP.getValue().equals(resourceType)) {
                return;
            }
            List<MainDataUpateParam> upateParams = event.getUpateParams();
            long resourceId = resourceObj.getLong("id");
            Map<String, List<MainDataUpateParam>> mapParams = upateParams.stream().filter(item -> item.getResourceId() == resourceId).collect(Collectors.groupingBy(MainDataUpateParam::getDataTable));
            DynamicObject dateTemp = this.getDataTemp(resourceId);
            if (dateTemp == null) {
                return;
            }
            String tempclassify = dateTemp.getString("tempclassify");
            long tempConfId = dateTemp.getLong("tempconf");
            DynamicObject tempConf = BusinessDataServiceHelper.loadSingleFromCache((Object)tempConfId, (String)"phm_billtemp_set");
            DynamicObjectCollection fieldConf = tempConf.getDynamicObjectCollection("fieldentryentity");
            if (fieldConf == null || fieldConf.isEmpty()) {
                return;
            }
            try {
                Map<String, List<DynamicObject>> dataTableMap = fieldConf.stream().filter(item -> StringUtils.equals((CharSequence)DataTempDataSourceEnum.DATATABLE.getValue(), (CharSequence)item.getString("dataresource"))).collect(Collectors.groupingBy(item -> item.getDynamicObject("datatable").getString("number")));
                DynamicObject dataTempHistoryData = resource.getDynamicObject("resource_data");
                Object dataTempHistoryId = dataTempHistoryData == null ? null : dataTempHistoryData.get("id");
                DynamicObject dataTempHistory = this.getDataTempHistory(dataTempHistoryId, resource.getString("resource_datatype"));
                if (StringUtils.equals((CharSequence)tempclassify, (CharSequence)DataTempClassifyEnum.SINGLE.getValue()) || StringUtils.equals((CharSequence)tempclassify, (CharSequence)DataTempClassifyEnum.MULTI.getValue())) {
                    this.updateData(dateTemp, dataTempHistory, dataTableMap, mapParams);
                }
                this.updateSourceUpdate(resource);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    private void updateSourceUpdate(DynamicObject resource) {
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_resources"), resource.get("id"));
        dynamicObject.set("resource_modifytime", (Object)new Date());
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private void updateData(DynamicObject dataTemp, DynamicObject dataTempHistory, Map<String, List<DynamicObject>> dataTableMap, Map<String, List<MainDataUpateParam>> mapParams) {
        if (dataTemp == null || dataTempHistory == null || dataTableMap == null || mapParams == null) {
            return;
        }
        int realRow = dataTemp.getInt("realrow");
        String spreadString = dataTempHistory.getString("spreadjson_tag");
        Map spreadObject = SpreadPraseUtil.getSpreadObject((String)spreadString);
        Map dataTableObject = SpreadPraseUtil.getSpreadDataTableObject((Map)spreadObject);
        for (Map.Entry<String, List<DynamicObject>> mapEntry : dataTableMap.entrySet()) {
            List<DynamicObject> columnConfs = mapEntry.getValue();
            this.updateSpreadByDataTable(mapEntry.getKey(), realRow, dataTableObject, columnConfs);
        }
        String spreadJson = SerializationUtils.toJsonString((Object)spreadObject);
        spreadString = SpreadUtils.convertCompressJson((String)spreadJson);
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_filldata_history"), dataTempHistory.get("id"));
        dynamicObject.set("spreadjson_tag", (Object)spreadString);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private void updateSpreadByDataTable(String tableName, Integer realRow, Map<String, Object> dataTableObject, List<DynamicObject> columnConfs) {
        StringJoiner selectFieldJoiner = new StringJoiner(",");
        StringJoiner whereJoiner = new StringJoiner(" and ");
        Map<String, List<DynamicObject>> logicTypes = columnConfs.stream().collect(Collectors.groupingBy(item -> item.getString("fieldlogic")));
        List<DynamicObject> indexItems = logicTypes.get("1");
        List<DynamicObject> indexValues = logicTypes.get("2");
        if (indexItems == null || indexItems.isEmpty() || indexValues == null || indexValues.isEmpty()) {
            return;
        }
        int startRow = realRow;
        for (DynamicObject indexItem : indexItems) {
            String fieldNumber = indexItem.getString("fieldnumber");
            int startrow = indexItem.getInt("startrow");
            if (startrow > startRow) {
                startRow = startrow;
            }
            whereJoiner.add(fieldNumber + " = ? ");
        }
        indexValues.forEach(item -> {
            String fieldNumber = item.getString("fieldnumber");
            selectFieldJoiner.add(fieldNumber);
        });
        String selectField = selectFieldJoiner.toString();
        String where = whereJoiner.toString();
        int cycle = 20;
        int num = 0;
        SqlBuilder unionSql = new SqlBuilder();
        if (dataTableObject == null) {
            return;
        }
        Iterator<Map.Entry<String, Object>> iterator = dataTableObject.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Object> row = iterator.next();
            int index = Integer.parseInt(row.getKey());
            if (index < startRow) continue;
            ++num;
            Map rowData = (Map)row.getValue();
            Object[] params = new Object[indexItems.size()];
            for (int j = 0; j < indexItems.size(); ++j) {
                DynamicObject field = indexItems.get(j);
                int col = field.getInt("cellcol");
                String fieldType = field.getString("fieldtype");
                Object cellValue = SpreadPraseUtil.getCellValue((Map)((Map)rowData.get(col + "")));
                params[j] = (cellValue = this.coverDataToFieldType(fieldType, cellValue)) == null ? "null" : cellValue;
            }
            SqlBuilder sql = new SqlBuilder();
            sql.append("select ", new Object[0]).append("'" + index + "',", new Object[0]).append(selectField, new Object[0]).append(" from ", new Object[0]).append(tableName, new Object[0]).append(" where ", new Object[0]).append(where, params);
            unionSql.appendSqlBuilder(sql);
            if (iterator.hasNext() && num < cycle) {
                unionSql.append(" union all ", new Object[0]);
            }
            if (num != cycle && iterator.hasNext()) continue;
            this.setSpreadValue(dataTableObject, unionSql, indexValues);
            num = 0;
            unionSql = new SqlBuilder();
        }
    }

    public Object coverDataToFieldType(String fieldType, Object value) {
        if (value == null) {
            return null;
        }
        try {
            if (FieldType.BIGINT.getValue().equals(fieldType) || FieldType.DECIMAL.getValue().equals(fieldType)) {
                if (value instanceof BigDecimal) {
                    return value;
                }
                return new BigDecimal(String.valueOf(value));
            }
            if (FieldType.NVARCHAR.getValue().equals(fieldType)) {
                if (value instanceof String) {
                    return value;
                }
                return String.valueOf(value);
            }
            if (FieldType.DATETIME.getValue().equals(fieldType)) {
                if (value instanceof Data) {
                    return value;
                }
                return null;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private void setSpreadValue(Map<String, Object> dataTableObject, SqlBuilder sql, List<DynamicObject> indexValues) {
        try (DataSet ds = DB.queryDataSet((String)AGLOKEY, (DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sql);){
            while (ds.hasNext()) {
                Row row = ds.next();
                int columnSize = indexValues.size() + 1;
                String rowIndex = row.getString(0);
                Map dataRow = (Map)dataTableObject.get(rowIndex);
                if (dataRow == null) continue;
                for (int i = 1; i < columnSize; ++i) {
                    DynamicObject indexVal = indexValues.get(i - 1);
                    int colIndx = indexVal.getInt("cellcol");
                    Object columnValue = row.get(i);
                    Map cell = (Map)dataRow.get(colIndx + "");
                    if (cell == null) continue;
                    cell.put("value", columnValue);
                }
            }
        }
    }

    private DynamicObject getDataTempHistory(Object pk, String enetityName) {
        StringJoiner selectField = new StringJoiner(",");
        selectField.add("id").add("spreadjson_tag");
        QFilter filter = new QFilter("id", "=", pk);
        return QueryServiceHelper.queryOne((String)enetityName, (String)selectField.toString(), (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject getDataTemp(Object pk) {
        StringJoiner selectField = new StringJoiner(",");
        selectField.add("tempclassify").add("tempconf").add("realrow").add("realcol");
        QFilter filter = new QFilter("id", "=", pk);
        return QueryServiceHelper.queryOne((String)"phm_billtemp", (String)selectField.toString(), (QFilter[])new QFilter[]{filter});
    }

    private DynamicObject[] queryProcessNodeResource(Long nodeId) {
        String selectFields = "id,resource_type, resource_number, resource_datatype, resource_data, resource_role, resource_processhistory";
        return BusinessDataServiceHelper.load((String)"phm_process_resources", (String)selectFields, (QFilter[])new QFilter("entry_node", "=", (Object)nodeId).toArray());
    }

    private void updateNodeStatus(Long processHistoryId, Long nodeId, String status, List<MainDataUpateParam> upateParams) {
        int updateingNodes = this.countUpatingNodes(processHistoryId);
        if (updateingNodes == 1) {
            this.updateProcessDiff(upateParams);
        }
        DynamicObject dynamicObject = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_process_node"), (Object)nodeId);
        dynamicObject.set("node_status", (Object)status);
        SaveServiceHelper.update((DynamicObject)dynamicObject);
    }

    private void updateProcessDiff(List<MainDataUpateParam> upateParams) {
        if (upateParams == null || upateParams.isEmpty()) {
            return;
        }
        List list = upateParams.stream().map(MainDataUpateParam::getId).collect(Collectors.toList());
        SqlBuilder sqlBuilder = new SqlBuilder();
        sqlBuilder.append("UPDATE t_phm_process_updatediff  SET flatest = ? , fmodifydate = ? where ", new Object[]{"1", new Date()});
        sqlBuilder.appendIn(" fid", list);
        DB.execute((DBRoute)CommonConsts.ROUTE_PHM, (SqlBuilder)sqlBuilder);
    }

    private int countUpatingNodes(Long processHistoryId) {
        ORM orm = ORM.create();
        QFilter qFilter = new QFilter("historyid", "=", (Object)processHistoryId);
        qFilter.and(new QFilter("node_status", "=", (Object)RunningState.AUTO.getValue()));
        return orm.count("ProcessDataUpdateValidator", "phm_process_node", qFilter.toArray());
    }
}

