/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.framework.mq.manager;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.mmc.phm.common.consts.CommonConsts;
import kd.mmc.phm.common.domian.process.MainDataUpateParam;
import kd.mmc.phm.common.errorcode.PHMErrorCode;
import kd.mmc.phm.common.serviece.workbench.ProcessCalcLogService;
import kd.mmc.phm.mservice.framework.mq.IEventManager;
import kd.mmc.phm.mservice.framework.mq.MQServiceHelper;
import kd.mmc.phm.mservice.framework.mq.consumer.ProcessControlConsumer;
import kd.mmc.phm.mservice.framework.mq.event.PHMEvent;
import kd.mmc.phm.mservice.framework.mq.event.ProcessAutoUpdateEvent;
import kd.mmc.phm.mservice.framework.runner.CalcManager;
import kd.mmc.phm.mservice.model.process.ProcessEventNode;
import kd.mmc.phm.mservice.process.ProcessResourceDataTableUpdate;

public class ProcessAutoUpdateEventManager
implements IEventManager {
    private static final Log log = LogFactory.getLog(ProcessAutoUpdateEventManager.class);
    private final String eventId;
    private final long historyId;
    private final Map<ProcessEventNode, CountDownLatch> node2Lock = new ConcurrentHashMap<ProcessEventNode, CountDownLatch>();
    private final Map<ProcessEventNode, CompletableFuture> allExecutionChain = new ConcurrentHashMap<ProcessEventNode, CompletableFuture>();
    private final Map<ProcessEventNode, CompletableFuture> parallelExecutionChain = new ConcurrentHashMap<ProcessEventNode, CompletableFuture>();
    private List<MainDataUpateParam> upateParams;

    public ProcessAutoUpdateEventManager(String eventId, long historyId) {
        this.eventId = eventId;
        this.historyId = historyId;
        MQServiceHelper.registControlQueue(MQServiceHelper.getRealControlQueueName("kd.mmc.phm.process.control_queue", eventId), ProcessControlConsumer.class);
    }

    @Override
    public void wait4Response(PHMEvent event) {
        ProcessAutoUpdateEvent processAutoUpdateEvent = (ProcessAutoUpdateEvent)event;
        ProcessEventNode currentNode = processAutoUpdateEvent.getCurrentNode();
        CountDownLatch lock = this.getLock(currentNode);
        try {
            if (!lock.await(30L, TimeUnit.MINUTES)) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u8282\u70b9[%s]\u66f4\u65b0\u5931\u8d25: \u66f4\u65b0\u8d85\u65f6", (String)"ProcessAutoUpdateEventManager_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), currentNode.getName()));
            }
            log.info("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u7b49\u5f85\u7ed3\u675f, \u6267\u884c\u4e0b\u4e00\u4e2a\u8282\u70b9, eventId: {}", (Object)currentNode, (Object)this.eventId);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, PHMErrorCode.bizException, new Object[]{String.format(ResManager.loadKDString((String)"\u8282\u70b9[%s]\u66f4\u65b0\u5931\u8d25: \u66f4\u65b0\u8d85\u65f6", (String)"ProcessAutoUpdateEventManager_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), currentNode.getName())});
        }
    }

    @Override
    public void onMessage(PHMEvent event) {
        ProcessAutoUpdateEvent processAutoUpdateEvent = (ProcessAutoUpdateEvent)event;
        ProcessEventNode currentNode = processAutoUpdateEvent.getCurrentNode();
        if (processAutoUpdateEvent.isFail()) {
            CompletableFuture completableFuture = this.allExecutionChain.get(currentNode);
            completableFuture.completeExceptionally((Throwable)new KDBizException(processAutoUpdateEvent.getExceptionMessage()));
        } else {
            this.allExecutionChain.remove(currentNode);
        }
        CountDownLatch countDownLatch = this.getLock(currentNode);
        countDownLatch.countDown();
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    public void addParallelExecutionChain(ProcessEventNode processEventNode, CompletableFuture completableFuture) {
        this.parallelExecutionChain.put(processEventNode, completableFuture);
    }

    public void putAllExecutionChain(Map<ProcessEventNode, CompletableFuture> completableFutureMap) {
        this.allExecutionChain.putAll(completableFutureMap);
    }

    public void complete(ExecutorService executorService, RequestContext rc) {
        for (Map.Entry<ProcessEventNode, CompletableFuture> entry : this.parallelExecutionChain.entrySet()) {
            entry.getValue().whenCompleteAsync((result, throwableResult) -> {
                if (throwableResult == null) {
                    log.info("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u6267\u884c\u94fe\u6267\u884c\u6210\u529f, eventId: {}", entry.getKey(), (Object)this.eventId);
                    return;
                }
                Throwable throwable = (Throwable)throwableResult;
                log.error("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u6267\u884c\u94fe\u53d1\u751f\u5f02\u5e38, eventId: {}", new Object[]{entry.getKey(), this.eventId, throwable});
            }, (Executor)executorService);
        }
        CompletableFuture.allOf(this.parallelExecutionChain.values().toArray(new CompletableFuture[0])).whenCompleteAsync((result, throwable) -> {
            log.info("\u81ea\u52a8\u66f4\u65b0\u7ed3\u675f, \u5f00\u59cb\u6e05\u9664\u8d44\u6e90\u3002eventId: {}", (Object)this.eventId);
            try {
                RequestContext.copyAndSet((RequestContext)rc);
                CalcManager.destoryEventManager(this.eventId);
                MQServiceHelper.destroyControlQueue(MQServiceHelper.getRealControlQueueName("kd.mmc.phm.process.control_queue", this.eventId));
            }
            catch (Throwable exception) {
                log.error("\u81ea\u52a8\u66f4\u65b0\u6e05\u9664\u8d44\u6e90\u5931\u8d25: " + exception.getMessage(), exception);
            }
            ProcessCalcLogService.changeProcessManualUpdateStatus((Long)this.historyId, (int)0);
            log.info("\u81ea\u52a8\u66f4\u65b0\u7ed3\u675f, \u6e05\u9664\u8d44\u6e90\u5b8c\u6210\u3002eventId: {}", (Object)this.eventId);
            if (throwable == null) {
                log.info("\u81ea\u52a8\u66f4\u65b0\u6240\u6709\u6267\u884c\u94fe\u6267\u884c\u6210\u529f, eventId: {}", (Object)this.eventId);
                ProcessResourceDataTableUpdate.updateProcessDiff(this.upateParams);
                return;
            }
            String updateSql = "UPDATE T_PHM_PROCESS_NODE SET FSTATUS = ? WHERE FENTRYID = ?";
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            for (Map.Entry<ProcessEventNode, CompletableFuture> entry : this.allExecutionChain.entrySet()) {
                ProcessEventNode processEventNode = entry.getKey();
                if (this.node2Lock.containsKey(processEventNode)) continue;
                Object[] value = new Object[]{processEventNode.getStatus(), processEventNode.getEntryId()};
                values.add(value);
            }
            DB.executeBatch((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, values);
        }, (Executor)executorService);
    }

    public void completeSync(ExecutorService executorService, RequestContext rc) {
        for (Map.Entry<ProcessEventNode, CompletableFuture> entry : this.parallelExecutionChain.entrySet()) {
            entry.getValue().whenCompleteAsync((result, throwableResult) -> {
                if (throwableResult == null) {
                    log.info("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u6267\u884c\u94fe\u6267\u884c\u6210\u529f, eventId: {}", entry.getKey(), (Object)this.eventId);
                    return;
                }
                Throwable throwable = (Throwable)throwableResult;
                log.error("\u81ea\u52a8\u66f4\u65b0\u8282\u70b9[{}]\u6267\u884c\u94fe\u53d1\u751f\u5f02\u5e38, eventId: {}", new Object[]{entry.getKey(), this.eventId, throwable});
            }, (Executor)executorService);
        }
        try {
            CompletableFuture.allOf(this.parallelExecutionChain.values().toArray(new CompletableFuture[0])).join();
            log.info("\u81ea\u52a8\u66f4\u65b0\u6240\u6709\u6267\u884c\u94fe\u6267\u884c\u6210\u529f, eventId: {}", (Object)this.eventId);
            ProcessResourceDataTableUpdate.updateProcessDiff(this.upateParams);
        }
        catch (Exception e) {
            String updateSql = "UPDATE T_PHM_PROCESS_NODE SET FSTATUS = ? WHERE FENTRYID = ?";
            ArrayList<Object[]> values = new ArrayList<Object[]>();
            for (Map.Entry<ProcessEventNode, CompletableFuture> entry : this.allExecutionChain.entrySet()) {
                ProcessEventNode processEventNode = entry.getKey();
                if (this.node2Lock.containsKey(processEventNode)) continue;
                Object[] value = new Object[]{processEventNode.getStatus(), processEventNode.getEntryId()};
                values.add(value);
            }
            if (!values.isEmpty()) {
                DB.executeBatch((DBRoute)CommonConsts.ROUTE_PHM, (String)updateSql, values);
            }
            throw new KDBizException(new ErrorCode("", e.getMessage()), new Object[]{e});
        }
        finally {
            log.info("\u81ea\u52a8\u66f4\u65b0\u7ed3\u675f, \u5f00\u59cb\u6e05\u9664\u8d44\u6e90\u3002eventId: {}", (Object)this.eventId);
            try {
                RequestContext.copyAndSet((RequestContext)rc);
                CalcManager.destoryEventManager(this.eventId);
                MQServiceHelper.destroyControlQueue(MQServiceHelper.getRealControlQueueName("kd.mmc.phm.process.control_queue", this.eventId));
            }
            catch (Throwable exception) {
                log.error("\u81ea\u52a8\u66f4\u65b0\u6e05\u9664\u8d44\u6e90\u5931\u8d25: " + exception.getMessage(), exception);
            }
            ProcessCalcLogService.changeProcessManualUpdateStatus((Long)this.historyId, (int)0);
            log.info("\u81ea\u52a8\u66f4\u65b0\u7ed3\u675f, \u6e05\u9664\u8d44\u6e90\u5b8c\u6210\u3002eventId: {}", (Object)this.eventId);
        }
    }

    private CountDownLatch getLock(ProcessEventNode node) {
        return this.node2Lock.computeIfAbsent(node, k -> new CountDownLatch(1));
    }

    public List<MainDataUpateParam> getUpateParams() {
        return this.upateParams;
    }

    public void setUpateParams(List<MainDataUpateParam> upateParams) {
        this.upateParams = upateParams;
    }
}

