/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.framework.mq.rabbit;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.StringReader;
import java.util.Objects;
import java.util.Properties;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.encrypt.Encrypters;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class RabbitMQEnvProvider {
    private static final Log logger = LogFactory.getLog(RabbitMQEnvProvider.class);
    private static RabbitMQEnvProvider INST;
    private String host;
    private String user;
    private String passwd;
    private String vhost;
    private Integer port = 15672;

    public static synchronized RabbitMQEnvProvider getInst() {
        if (INST != null) {
            return INST;
        }
        String serverKey = ChannelFactory.getRegionServerKey((String)"mmc");
        String serverInfo = System.getProperty(serverKey);
        INST = new RabbitMQEnvProvider();
        Properties prop = new Properties();
        StringReader reader = new StringReader(serverInfo);
        try {
            prop.load(reader);
            RabbitMQEnvProvider.INST.host = Objects.requireNonNull(prop.getProperty("host"), "host can't be empty.");
            String str = prop.getProperty("port");
            if (str != null && str.trim().length() > 0) {
                RabbitMQEnvProvider.INST.port = Integer.parseInt(str.trim()) + 10000;
            }
            RabbitMQEnvProvider.INST.user = Objects.requireNonNull(prop.getProperty("user"), "user can't be empty.");
            str = Objects.requireNonNull(prop.getProperty("password"), "password can't be empty.");
            RabbitMQEnvProvider.INST.passwd = Encrypters.decode((String)str);
            RabbitMQEnvProvider.INST.vhost = Objects.requireNonNull(prop.getProperty("vhost"), "vhost can't be empty.");
            str = prop.getProperty("rpc.timeout", "60000");
            str = prop.getProperty("connection.timeout", "3000");
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"MQ\u5f02\u5e38\uff1a%s", (String)"RabbitMQEnvProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return INST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnRelatedQueues() {
        String calcQueueName;
        String prefix = calcQueueName = QueueManager.getRealQueueName((String)"mmc", (String)"kd.mmc.phm.phm_ctrl_queue");
        String queueTag = System.getProperty("mq.debug.queue.tag");
        boolean isEmptyQt = StringUtils.isEmpty((String)queueTag);
        if (!isEmptyQt) {
            prefix = prefix.substring(0, prefix.length() - queueTag.length() - 1);
        }
        CloseableHttpClient client = this.buildClient();
        try {
            int count = -1;
            do {
                String str = this.getQueues(client, prefix, queueTag, 1);
                JSONObject page = JSON.parseObject((String)str);
                JSONArray queues = page.getJSONArray("items");
                if (count < 0) {
                    count = page.getInteger("page_count");
                }
                for (int i = 0; i < queues.size(); ++i) {
                    JSONObject queue = queues.getJSONObject(i);
                    String name = queue.getString("name");
                    Integer cCount = queue.getInteger("consumers");
                    if (calcQueueName.equals(name) || name == null || !name.startsWith(prefix) || cCount == null || cCount != 0) continue;
                    try {
                        ChannelFactory.getChannel((String)"mmc").queueDelete(name, false, false);
                        continue;
                    }
                    catch (IOException e) {
                        throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"MQ\u5f02\u5e38\uff1a%s", (String)"RabbitMQEnvProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
                    }
                }
            } while (--count > 0);
        }
        finally {
            if (null != client) {
                try {
                    client.close();
                }
                catch (IOException e) {
                    logger.error("MQ\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    private CloseableHttpClient buildClient() {
        CloseableHttpClient httpClient = null;
        try {
            BasicCredentialsProvider bp = new BasicCredentialsProvider();
            bp.setCredentials(new AuthScope(this.host, this.port.intValue()), (Credentials)new UsernamePasswordCredentials(this.user, this.passwd));
            httpClient = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)bp).build();
        }
        catch (Exception e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"MQ\u5f02\u5e38\uff1a%s", (String)"RabbitMQEnvProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return httpClient;
    }

    private String getQueues(CloseableHttpClient httpClient, String regexFilter, String queueTag, int page) {
        String url = "http://" + this.host + ":" + this.port + "/api/queues/" + this.vhost;
        url = url + "?use_regex=true&pagination=true&page_size=100&name=" + regexFilter + ".*" + (StringUtils.isEmpty((String)queueTag) ? "" : "." + queueTag) + "&page=" + page;
        CloseableHttpResponse response = null;
        String result = "";
        try {
            HttpGet httpGet = new HttpGet(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(35000).setConnectionRequestTimeout(35000).setSocketTimeout(60000).build();
            httpGet.setConfig(requestConfig);
            response = httpClient.execute((HttpUriRequest)httpGet);
            HttpEntity entity = response.getEntity();
            result = EntityUtils.toString((HttpEntity)entity);
        }
        catch (ClientProtocolException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"MQ\u5f02\u5e38\uff1a%s", (String)"RabbitMQEnvProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        catch (IOException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"MQ\u5f02\u5e38\uff1a%s", (String)"RabbitMQEnvProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        finally {
            if (null != response) {
                try {
                    response.close();
                }
                catch (IOException e) {
                    logger.error("MQ\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        return result;
    }

    private void waitSec() {
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"MQ\u5f02\u5e38\uff1a%s", (String)"RabbitMQEnvProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }
}

