/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.framework.service;

import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dc.api.model.Account;
import kd.bos.dc.api.model.DBInstance;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.framework.lifecycle.Service;
import kd.bos.framework.lifecycle.appstart.AppStarter;
import kd.bos.instance.Instance;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.utils.RequestContextUtils;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.bos.zk.ZKFactory;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudMetaConsts;
import kd.mmc.phm.mservice.utils.Utils;
import org.apache.log4j.Logger;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.ZooDefs;

@KSObject
public class PHMNodeAppServiceStarter
implements Service,
AppStarter {
    private static Logger logger = Logger.getLogger(PHMNodeAppServiceStarter.class);
    private boolean isStarted;
    private static Object instance_lock = new Object();

    public String getName() {
        return "mmc-phm-calc-service";
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    @KSMethod
    public void start() {
        ThreadPools.executeOnce((String)"mmc-phm-regist-service-worker", (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = instance_lock;
                synchronized (object) {
                    try {
                        String PHMIsOpenZkTest = System.getProperty("PHMIsOpenZkTest");
                        if ("open".equals(PHMIsOpenZkTest)) {
                            SysConsts.client = ZKFactory.getZKClient((String)System.getProperty("configUrl"));
                            SysConsts.zk = SysConsts.client.getZookeeperClient().getZooKeeper();
                            SysConsts.zk.create("/" + Instance.getClusterName() + "/" + SysConsts.NODE_ID, "".getBytes("UTF-8"), (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                        }
                    }
                    catch (Exception e) {
                        logger.error((Object)String.format("\u8fde\u63a5\u5931\u8d25\uff1a%s", e.getMessage()), (Throwable)e);
                    }
                }
                PHMNodeAppServiceStarter.this.cycleDataCenter(account -> PHMNodeAppServiceStarter.this.regist(account));
            }
        });
        this.isStarted = true;
    }

    public void stop() {
        ThreadPools.executeOnce((String)"mmc-unregist-service-worker", (Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = instance_lock;
                synchronized (object) {
                    if (SysConsts.client != null) {
                        SysConsts.client.close();
                    }
                }
                PHMNodeAppServiceStarter.this.cycleDataCenter(account -> PHMNodeAppServiceStarter.this.unRegist(account));
            }
        });
        this.isStarted = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void regist(Account account) {
        String instInfo = "DataCenter [accountId=" + account.getAccountId() + ", accountName=" + account.getAccountName() + ", accountNumber=" + account.getAccountNumber() + ", isDefault=" + account.isDefault() + ", version=" + account.getVersion() + ", eid=" + account.getEid() + ", yzjUrl=" + account.getYzjUrl() + ", ssoPlugin=" + account.getSsoPlugin() + ", yzjWeb=" + account.getYzjWeb() + ", yzjOrgNo=" + account.getYzjOrgNo() + ", userSourceType=" + account.getUserSourceTypeOutput() + ", keyFile=" + account.getKeyFile() + ", tenantId=" + account.getTenantId() + "]";
        List dbList = account.getDBInstanceList();
        StringBuilder info = new StringBuilder();
        for (DBInstance inst : dbList) {
            info.append("DBInst: ").append(inst.getDBInsatnce()).append(", ");
            info.append("IP: ").append(inst.getDbip()).append(", ");
            info.append("Psw: ").append(inst.getDbpassword()).append(", ");
            info.append("Port: ").append(inst.getDbport()).append(", ");
            info.append("DBType: ").append(inst.getDbtype()).append(", ");
            info.append("DBUser: ").append(inst.getDbuser()).append(", ");
            info.append("LoadFactor: ").append(inst.getLoadFactor()).append(", ");
            info.append("isReadOnly: ").append(inst.getReadOnly()).append(", ");
            info.append("RouteKey: ").append(inst.getRouteKey());
            info.append("\r\n");
        }
        String ip = Utils.getIP();
        Object object = instance_lock;
        synchronized (object) {
            DeleteServiceHelper.delete((String)"phm_calc_resregist", (QFilter[])new QFilter[]{new QFilter("instip", "=", (Object)ip)});
            DynamicObject serverInfo = BusinessDataServiceHelper.newDynamicObject((String)"phm_calc_resregist");
            serverInfo.set("instid", (Object)SysConsts.NODE_ID);
            serverInfo.set("instip", (Object)ip);
            serverInfo.set("instinfo", (Object)instInfo);
            serverInfo.set("lastacctime", (Object)System.currentTimeMillis());
            String tag = System.getProperty("mq.debug.queue.tag");
            serverInfo.set("mqtag", (Object)tag);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{serverInfo});
        }
    }

    private void unRegist(Account account) {
        String ip = Utils.getIP();
        DeleteServiceHelper.delete((String)"phm_calc_resregist", (QFilter[])new QFilter[]{new QFilter("instip", "=", (Object)ip)});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cycleDataCenter(IDBWorker woker) {
        List accounts = AccountUtils.getAllAccountsOfCurrentEnv();
        for (Account account : accounts) {
            String tenantId = account.getTenantId();
            String accountId = account.getAccountId();
            RequestContextUtils.createRequestContext((String)tenantId, (String)accountId, (String)null);
            try (TXHandle h = TX.requiresNew((String)this.getClass().getName());){
                woker.work(account);
            }
            h = TX.requiresNew((String)this.getClass().getName());
            try {
                this.clearUnRelatedLogs();
            }
            catch (Throwable e) {
                logger.error((Object)String.format("---clear phm calc node regist model failed, Account(tId: %s, aId: %s, name: %s)---", tenantId, accountId, account.getAccountName()), e);
            }
            finally {
                if (h == null) continue;
                h.close();
            }
        }
    }

    private void clearUnRelatedLogs() {
        DynamicObject[] models = BusinessDataServiceHelper.load((String)"phm_calc_resregist", (String)"instid, resmodelid", (QFilter[])new QFilter[0]);
        ArrayList<String> ids = new ArrayList<String>();
        for (DynamicObject model : models) {
            DynamicObjectCollection entrys = model.getDynamicObjectCollection("calc_res_regist_entry");
            for (DynamicObject entry : entrys) {
                ids.add(KDCloudMetaConsts.createResCalcId(model.getString("instid"), entry.getString("resmodelid")));
            }
        }
        DeleteServiceHelper.delete((String)"phm_bizmodel_calclog", (QFilter[])new QFilter[]{new QFilter("calcid", "not in", ids)});
    }

    private static interface IDBWorker {
        public void work(Account var1);
    }
}

