/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Objects;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.ORM;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.IEnvStatusAware;
import kd.mmc.phm.mservice.model.INodeStatusAware;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.enums.BizModelCalcStatus;

class KDCloudLogRecorder
implements INodeStatusAware,
IEnvStatusAware,
Runnable {
    private volatile boolean isIgnored = false;
    private volatile boolean isUpdating = false;
    private DynamicObject calcLog;
    private DynamicObjectCollection entrys;
    private HashMap<String, DynamicObject> entryMap = new HashMap();
    private ORM orm = ORM.create();
    private boolean isShutdown = false;

    KDCloudLogRecorder() {
    }

    @Override
    public void onStart(CalcEnv env) {
        if (this.calcLog != null) {
            this.orm.delete(this.calcLog);
        }
        this.calcLog = this.orm.newDynamicObject("phm_bizmodel_calclog");
        String resId = env.getProvider().getEnvId();
        this.calcLog.set("bizmodel", (Object)resId);
        this.calcLog.set("calcid", (Object)SysConsts.createCtrlMQId((String)SysConsts.NODE_ID, (String)resId));
        this.calcLog.set("status", (Object)BizModelCalcStatus.CALCULATING.getValue());
        this.calcLog.set("start_time", (Object)System.currentTimeMillis());
        this.entrys = this.calcLog.getDynamicObjectCollection("entryentity");
        this.entrys.clear();
        this.entryMap.clear();
        this.orm.save(new DynamicObject[]{this.calcLog});
        BaseDataServiceHelper.clearCache((DynamicObject)this.calcLog);
        this.isShutdown = false;
        env.runTask(String.format("phm - model(%s) - calc log syncher", resId), this);
    }

    @Override
    public void onFinish(CalcEnv env) {
        this.calcLog.set("end_time", (Object)System.currentTimeMillis());
        this.calcLog.set("status", (Object)BizModelCalcStatus.FINISHED.getValue());
        double time = (double)(System.currentTimeMillis() - this.calcLog.getDate("start_time").getTime()) / 1000.0 / 60.0;
        this.calcLog.set("count_time", (Object)time);
        this.calcLog.set("progress", (Object)100);
        this.isShutdown = true;
        this.sync2DB();
    }

    @Override
    public void onFail(CalcEnv env) {
        this.calcLog.set("end_time", (Object)System.currentTimeMillis());
        this.calcLog.set("status", (Object)BizModelCalcStatus.CRUSHED.getValue());
        double time = (double)(System.currentTimeMillis() - this.calcLog.getDate("start_time").getTime()) / 1000.0 / 60.0;
        this.calcLog.set("count_time", (Object)time);
        this.calcLog.set("progress", (Object)100);
        this.isShutdown = true;
        this.sync2DB();
    }

    @Override
    public void initFail(String resId, Throwable error) {
        if (this.calcLog != null) {
            this.orm.delete(this.calcLog);
        }
        this.calcLog = this.orm.newDynamicObject("phm_bizmodel_calclog");
        this.calcLog.set("bizmodel", (Object)resId);
        this.calcLog.set("calcid", (Object)SysConsts.createCtrlMQId((String)SysConsts.NODE_ID, (String)resId));
        this.calcLog.set("status", (Object)BizModelCalcStatus.CALCULATING.getValue());
        this.calcLog.set("start_time", (Object)System.currentTimeMillis());
        this.calcLog.set("initdetail", (Object)this.getShortMessage(error));
        this.calcLog.set("initdetail_tag", (Object)this.getMessage(error));
        this.entrys = this.calcLog.getDynamicObjectCollection("entryentity");
        this.entrys.clear();
        this.calcLog.set("end_time", (Object)System.currentTimeMillis());
        this.calcLog.set("status", (Object)BizModelCalcStatus.CRUSHED.getValue());
        double time = (double)(System.currentTimeMillis() - this.calcLog.getDate("start_time").getTime()) / 1000.0 / 60.0;
        this.calcLog.set("count_time", (Object)time);
        try (TXHandle txHandle = TX.requiresNew();){
            if ("0".equals(this.calcLog.getString("id"))) {
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{this.calcLog});
            } else {
                SaveServiceHelper.update((DynamicObject)this.calcLog);
            }
            txHandle.close();
        }
        BaseDataServiceHelper.clearCache((DynamicObject)this.calcLog);
    }

    @Override
    public void updateProgress(int percent) {
        if (percent == 100) {
            return;
        }
        this.calcLog.set("progress", (Object)percent);
        this.sync2DB();
    }

    @Override
    public void onPrepare(ICalculator node) {
        DynamicObject entry = this.orm.newDynamicObject(this.entrys.getDynamicObjectType());
        entry.set("entry_status", (Object)BizModelCalcStatus.STARTED.getValue());
        entry.set("nodename", (Object)node.getId());
        entry.set("entry_starttime", (Object)System.currentTimeMillis());
        this.entrys.add((Object)entry);
        this.entryMap.put(node.getId(), entry);
        this.sync2DB();
    }

    @Override
    public void onStart(ICalculator node) {
        DynamicObject entry = this.entryMap.get(node.getId());
        if (Objects.nonNull(entry)) {
            entry.set("entry_status", (Object)BizModelCalcStatus.CALCULATING.getValue());
            this.sync2DB();
        }
    }

    @Override
    public void onFinish(ICalculator node) {
        DynamicObject entry = this.entryMap.get(node.getId());
        if (Objects.nonNull(entry)) {
            entry.set("entry_status", (Object)BizModelCalcStatus.FINISHED.getValue());
            double time = (double)(System.currentTimeMillis() - entry.getDate("entry_starttime").getTime()) / 1000.0 / 60.0;
            entry.set("entry_counttime", (Object)time);
            entry.set("entry_endtime", (Object)System.currentTimeMillis());
            this.sync2DB();
        }
    }

    @Override
    public void onFail(ICalculator node, Throwable e) {
        DynamicObject entry = this.entryMap.get(node.getId());
        entry.set("entry_status", (Object)BizModelCalcStatus.CRUSHED.getValue());
        double time = (double)(System.currentTimeMillis() - entry.getDate("entry_starttime").getTime()) / 1000.0 / 60.0;
        entry.set("entry_counttime", (Object)time);
        entry.set("entry_endtime", (Object)System.currentTimeMillis());
        entry.set("detail", (Object)this.getShortMessage(e));
        entry.set("detail_tag", (Object)this.getMessage(e));
        this.sync2DB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        while (!this.isShutdown) {
            Class<KDCloudLogRecorder> clazz = KDCloudLogRecorder.class;
            // MONITORENTER : kd.mmc.phm.mservice.integrate.kdcloud.KDCloudLogRecorder.class
            try {
                KDCloudLogRecorder.class.wait();
                Thread.sleep(300L);
            }
            catch (Throwable e) {
                e.printStackTrace();
                // MONITOREXIT : clazz
                return;
            }
            do {
                this.update();
            } while (this.isIgnored);
            // MONITOREXIT : clazz
        }
    }

    private void update() {
        this.isUpdating = true;
        this.isIgnored = false;
        try {
            this.orm.update(this.calcLog);
            BaseDataServiceHelper.clearCache((DynamicObject)this.calcLog);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        this.isUpdating = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void sync2DB() {
        if (this.isUpdating) {
            this.isIgnored = true;
            return;
        }
        Class<KDCloudLogRecorder> clazz = KDCloudLogRecorder.class;
        synchronized (KDCloudLogRecorder.class) {
            KDCloudLogRecorder.class.notify();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    private String getMessage(Throwable e) {
        if (e == null) {
            return "unknown error.";
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        return sw.toString();
    }

    private String getShortMessage(Throwable e) {
        if (e == null) {
            return "unknown error.";
        }
        String message = e.getLocalizedMessage();
        if (message == null) {
            message = "exception: " + e.getClass().getName();
        }
        if (message.length() > 200) {
            message = message.substring(0, 200);
        }
        return message;
    }
}

