/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mutex.MutexFactory;
import kd.mmc.phm.mservice.framework.mq.consumer.MutexConsumer;
import kd.mmc.phm.mservice.framework.mq.event.MutexEvent;
import kd.mmc.phm.mservice.framework.mutex.IMutexProvider;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudEnvProvider;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudQMDelegate;

class KDCloudMQMutexProvider
implements IMutexProvider {
    private static HashMap<String, Object> keys = new HashMap();
    private KDCloudEnvProvider env;

    public KDCloudMQMutexProvider(KDCloudEnvProvider env) {
        this.env = env;
    }

    @Override
    public boolean tryLock(boolean isStrict, String mutexKey, boolean isWait) {
        if (!MutexFactory.createDataMutex().require(mutexKey, "mmc.phm", "phm_plan", "edit", isStrict)) {
            if (isWait) {
                ArrayList<ConsumerDef> consumers = new ArrayList<ConsumerDef>();
                ConsumerDef consumer = new ConsumerDef();
                consumer.setClassName(MutexConsumer.class.getName());
                consumers.add(consumer);
                QueueDef queueDef = new QueueDef();
                queueDef.setAppid("phm");
                queueDef.setName(this.getQueueName(mutexKey));
                queueDef.setConsumers(consumers);
                KDCloudQMDelegate.add("mmc", queueDef, true);
                return this.waitLock(isStrict, mutexKey);
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void releaseLock(String mutexKey) {
        MutexFactory.createDataMutex().release(mutexKey, "phm_plan", "edit");
        if (!keys.containsKey(mutexKey)) {
            MutexEvent evt = new MutexEvent();
            evt.setEnvId(this.env.getEnvId());
            evt.getParams().put("key", (Serializable)((Object)mutexKey));
            String queueName = this.getQueueName(mutexKey);
            if (KDCloudQMDelegate.get("mmc", queueName) == null) {
                QueueDef queueDef = new QueueDef();
                queueDef.setAppid("phm");
                queueDef.setName(queueName);
                KDCloudQMDelegate.add("mmc", queueDef, false);
            }
            try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("mmc", queueName);){
                publisher.publish((Object)evt);
            }
        } else {
            this.notify(mutexKey);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void notify(String mutexKey) {
        Object lock;
        Object object = lock = keys.get(mutexKey);
        synchronized (object) {
            lock.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitLock(boolean isStrict, String mutexKey) {
        Object lock = new Object();
        keys.put(mutexKey, lock);
        while (!MutexFactory.createDataMutex().require(mutexKey, "mmc.phm", "phm_plan", "edit", isStrict)) {
            Object object = lock;
            synchronized (object) {
                try {
                    lock.wait(1000L);
                }
                catch (InterruptedException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u4e2d\u65ad\u5f02\u5e38\uff1a%s", (String)"KDCloudMQMutexProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
                }
            }
        }
        keys.remove(mutexKey);
        try {
            ChannelFactory.getChannel((String)"mmc").queueDelete(this.getQueueName(mutexKey), false, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u79fb\u9664\u961f\u5217\u5931\u8d25\uff1a%s", (String)"KDCloudMQMutexProvider_1", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
        return true;
    }

    private String getQueueName(String mutexKey) {
        return "kd.mmc.phm.phm_ctrl_queue." + mutexKey;
    }
}

