/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.instance.Instance;
import kd.bos.mq.MQFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.MessagePublisher;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.support.QueueManager;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.framework.mq.IMQProvider;
import kd.mmc.phm.mservice.framework.mq.event.MQEvent;
import kd.mmc.phm.mservice.framework.mq.event.SubCalcFinishEvent;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudQMDelegate;

class KDCloudMQProvider
implements IMQProvider {
    private HashMap<String, HashSet<String>> remoteEvents = new HashMap();

    KDCloudMQProvider() {
    }

    @Override
    public void registCtrlQueue(String ctxId, Class<? extends MessageConsumer> clazz) {
        if (Instance.isLightWeightDeploy()) {
            return;
        }
        ArrayList<ConsumerDef> consumers = new ArrayList<ConsumerDef>();
        ConsumerDef consumer = new ConsumerDef();
        consumer.setClassName(clazz.getName());
        consumers.add(consumer);
        QueueDef queueDef = new QueueDef();
        queueDef.setAppid("phm");
        queueDef.setName(SysConsts.createCtrlQueueName((String)SysConsts.NODE_ID, (String)ctxId));
        queueDef.setConsumers(consumers);
        QueueManager.add((String)"mmc", (QueueDef)queueDef, (boolean)true);
    }

    @Override
    public void destroyCtrlQueue(String ctxId) {
        QueueDef queueDef = new QueueDef();
        queueDef.setAppid("phm");
        queueDef.setName(SysConsts.createCtrlQueueName((String)SysConsts.NODE_ID, (String)ctxId));
        try {
            ChannelFactory.getChannel((String)"mmc").queueDelete(queueDef.getName(), false, false);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u79fb\u9664\u961f\u5217\u5931\u8d25\uff1a%s", (String)"KDCloudMQProvider_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishCalcEvent(String nodeId, MQEvent event) {
        this.waitFor(nodeId, event);
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("mmc", event.getTargetQueueId());){
            publisher.publish((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publishCtrlEvent(MQEvent event) {
        String queueName = this.buildCtrlQueueName(event);
        if (KDCloudQMDelegate.get("mmc", queueName) == null) {
            QueueDef queueDef = new QueueDef();
            queueDef.setAppid("phm");
            queueDef.setName(queueName);
            KDCloudQMDelegate.add("mmc", queueDef, false);
        }
        try (MessagePublisher publisher = MQFactory.get().createSimplePublisher("mmc", queueName);){
            publisher.publish((Object)event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void wait4Response(String nodeId) {
        HashSet<String> nodeRemoteEvents;
        Cloneable cloneable = this.remoteEvents;
        synchronized (cloneable) {
            nodeRemoteEvents = this.remoteEvents.get(nodeId);
            if (nodeRemoteEvents == null || nodeRemoteEvents.isEmpty()) {
                return;
            }
        }
        cloneable = nodeRemoteEvents;
        synchronized (cloneable) {
            try {
                while (nodeRemoteEvents != null && !nodeRemoteEvents.isEmpty()) {
                    nodeRemoteEvents.wait();
                }
            }
            catch (InterruptedException e) {
                throw new KDBizException((Throwable)e, SysConsts.Errors.WAIT_FAILED, new Object[]{e.getMessage()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void response(SubCalcFinishEvent event) {
        HashSet<String> nodeRemoteEvents;
        String calculatorId = event.getCalculatorId();
        Cloneable cloneable = this.remoteEvents;
        synchronized (cloneable) {
            if (!this.remoteEvents.containsKey(calculatorId)) {
                return;
            }
            HashSet<String> hashSet = nodeRemoteEvents = this.remoteEvents.get(calculatorId);
            synchronized (hashSet) {
                nodeRemoteEvents.remove(event.getEventId());
                if (!nodeRemoteEvents.isEmpty()) {
                    return;
                }
            }
        }
        cloneable = nodeRemoteEvents;
        synchronized (cloneable) {
            nodeRemoteEvents.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void waitFor(String nodeId, MQEvent ... events) {
        HashSet<String> nodeRemoteEvents;
        Cloneable cloneable = this.remoteEvents;
        synchronized (cloneable) {
            nodeRemoteEvents = this.remoteEvents.get(nodeId);
            if (nodeRemoteEvents == null) {
                nodeRemoteEvents = new HashSet();
                this.remoteEvents.put(nodeId, nodeRemoteEvents);
            }
        }
        cloneable = nodeRemoteEvents;
        synchronized (cloneable) {
            for (MQEvent event : events) {
                nodeRemoteEvents.add(event.getEventId());
            }
        }
    }

    @Override
    public boolean isExist(String queueDefName) {
        if (Instance.isLightWeightDeploy()) {
            return false;
        }
        QueueDef qd = KDCloudQMDelegate.get("mmc", queueDefName);
        return qd != null;
    }

    private String buildCtrlQueueName(MQEvent event) {
        return "kd.mmc.phm.phm_ctrl_queue." + event.getDispatchNodeId() + "." + event.getEnvId();
    }
}

