/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.mmc.phm.common.bizmodel.ComponentType;
import kd.mmc.phm.common.bizmodel.ValueTypeEnums;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.mservice.integrate.kdcloud.parser.PHMJsonNodeParser;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.IDynamicColumnAware;
import kd.mmc.phm.mservice.model.enums.CompareOperator;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.filter.IFilterNode;
import kd.mmc.phm.mservice.model.filter.impl.AbstractFilterNode;
import kd.mmc.phm.mservice.model.filter.impl.DateFilterNode;
import kd.mmc.phm.mservice.model.filter.impl.DateTimeFilterNode;
import kd.mmc.phm.mservice.model.filter.impl.DecimalFilterNode;
import kd.mmc.phm.mservice.model.filter.impl.TextFilterNode;

public class KDCloudModelBuilder {
    private static void buildDetailRoots(HashMap<String, ICalculator> roots, DynamicObject bizModel) {
        Object bizModelId = bizModel.getPkValue();
        ArrayList<String[]> expressions = new ArrayList<String[]>();
        int index0 = 0;
        int index1 = 1;
        try (DataSet dataSet = DesignerUtils.queryComponent((Object)bizModelId, (ComponentType)ComponentType.DETAIL);){
            block9: for (Row row : dataSet) {
                Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                String fieldSetData = (String)properties.get("field_set_data_tag");
                if (StringUtils.isBlank((CharSequence)fieldSetData)) continue;
                String componentId = row.getString("component");
                DynamicObject fieldSetDyObj = (DynamicObject)DynamicObjectSerializeUtil.deserialize((String)fieldSetData, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"))[0];
                DynamicObjectCollection fieldEntryentity = fieldSetDyObj.getDynamicObjectCollection("field_entryentity");
                String storevalueTag = "";
                for (Object dynamicObject : fieldEntryentity) {
                    String source = dynamicObject.getString("field_source");
                    String name = dynamicObject.getString("field_name");
                    String configuration = dynamicObject.getString("field_configuration_tag");
                    if (StringUtils.equals((CharSequence)"query", (CharSequence)source)) {
                        if (!StringUtils.isBlank((CharSequence)storevalueTag)) continue;
                        storevalueTag = configuration;
                        continue;
                    }
                    expressions.add(new String[]{name, configuration});
                }
                if (StringUtils.isNotBlank((CharSequence)storevalueTag)) {
                    ICalculator d = PHMJsonNodeParser.parseFromDetailQueryDefine(componentId, storevalueTag);
                    roots.put(componentId, d);
                    if (!expressions.isEmpty() && d instanceof IDynamicColumnAware) {
                        Object dynamicObject;
                        dynamicObject = expressions.iterator();
                        while (dynamicObject.hasNext()) {
                            String[] expression = (String[])dynamicObject.next();
                            ((IDynamicColumnAware)((Object)d)).addCalcColumn(expression[index0], expression[index1]);
                        }
                    }
                }
                DynamicObjectCollection drillingEntryentity = fieldSetDyObj.getDynamicObjectCollection("drilling_entryentity");
                String commponentDrillid = "drilling-" + componentId;
                String drillingStorevalueTag = "";
                for (DynamicObject drillingObj : drillingEntryentity) {
                    String source = drillingObj.getString("drilling_source");
                    if (!StringUtils.equals((CharSequence)"query", (CharSequence)source) || !StringUtils.isBlank((CharSequence)drillingStorevalueTag)) continue;
                    drillingStorevalueTag = drillingObj.getString("drilling_configuration_tag");
                    ICalculator iCalculator = PHMJsonNodeParser.parseFromDetailQueryDefine(commponentDrillid, drillingStorevalueTag);
                    roots.put(commponentDrillid, iCalculator);
                    continue block9;
                }
            }
        }
    }

    private static void oldBuildDetailRoots(HashMap<String, ICalculator> roots, DynamicObject bizmodel) {
        QFilter[] dFilters = new QFilter[]{new QFilter("bizmodelid", "=", bizmodel.getPkValue())};
        DynamicObject[] bizmodel_detail = BusinessDataServiceHelper.load((String)"phm_bizmodel_detail", (String)"field_set_data_tag,componentid", (QFilter[])dFilters);
        ArrayList<String[]> expressions = new ArrayList<String[]>();
        int index0 = 0;
        int index1 = 1;
        block0: for (DynamicObject detailDyObj : bizmodel_detail) {
            String field_set_data = detailDyObj.getString("field_set_data_tag");
            if (StringUtils.isBlank((CharSequence)field_set_data)) continue;
            Object[] phm_field_sets = DynamicObjectSerializeUtil.deserialize((String)field_set_data, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
            DynamicObject fieldSetDyObj = (DynamicObject)phm_field_sets[0];
            DynamicObjectCollection dynamicObjectCollection = fieldSetDyObj.getDynamicObjectCollection("field_entryentity");
            String componentid = detailDyObj.getString("componentid");
            String storevalueTag = "";
            expressions.clear();
            for (Object dynamicObject : dynamicObjectCollection) {
                String source = dynamicObject.getString("field_source");
                String name = dynamicObject.getString("field_name");
                String configuration = dynamicObject.getString("field_configuration_tag");
                if (StringUtils.equals((CharSequence)"query", (CharSequence)source)) {
                    if (!StringUtils.isBlank((CharSequence)storevalueTag)) continue;
                    storevalueTag = configuration;
                    continue;
                }
                expressions.add(new String[]{name, configuration});
            }
            if (StringUtils.isNotBlank((CharSequence)storevalueTag)) {
                ICalculator d = PHMJsonNodeParser.parseFromDetailQueryDefine(componentid, storevalueTag);
                roots.put(componentid, d);
                if (!expressions.isEmpty() && d instanceof IDynamicColumnAware) {
                    Object dynamicObject;
                    dynamicObject = expressions.iterator();
                    while (dynamicObject.hasNext()) {
                        String[] expression = (String[])dynamicObject.next();
                        ((IDynamicColumnAware)((Object)d)).addCalcColumn(expression[index0], expression[index1]);
                    }
                }
            }
            String commponentDrillid = "drilling-" + componentid;
            DynamicObjectCollection drillingEntryentity = fieldSetDyObj.getDynamicObjectCollection("drilling_entryentity");
            String drillingStorevalueTag = "";
            for (DynamicObject drillingObj : drillingEntryentity) {
                String source = drillingObj.getString("drilling_source");
                if (!StringUtils.equals((CharSequence)"query", (CharSequence)source) || !StringUtils.isBlank((CharSequence)drillingStorevalueTag)) continue;
                drillingStorevalueTag = drillingObj.getString("drilling_configuration_tag");
                ICalculator iCalculator = PHMJsonNodeParser.parseFromDetailQueryDefine(commponentDrillid, drillingStorevalueTag);
                roots.put(commponentDrillid, iCalculator);
                continue block0;
            }
        }
    }

    public static HashMap<String, ICalculator> buildNodes(DynamicObject bizModel, String type, Map<String, Serializable> changeMap) {
        HashMap<String, ICalculator> roots = new HashMap<String, ICalculator>(16);
        if ("phm_bizmodel".equals(type)) {
            if (DesignerUtils.exists((Object)bizModel.getPkValue())) {
                if (Objects.isNull(changeMap)) {
                    KDCloudModelBuilder.buildEigenRoots(roots, bizModel);
                } else {
                    KDCloudModelBuilder.buildEigenRoots(roots, bizModel, changeMap);
                }
                KDCloudModelBuilder.buildDetailRoots(roots, bizModel);
            } else {
                KDCloudModelBuilder.oldBuildEigenRoots(roots, bizModel);
                KDCloudModelBuilder.oldBuildDetailRoots(roots, bizModel);
            }
        } else if ("phm_eigenvalue".equals(type)) {
            KDCloudModelBuilder.buildEigenValueRoots(roots, bizModel);
        }
        return roots;
    }

    private static void buildEigenValueRoots(HashMap<String, ICalculator> roots, DynamicObject eigenvalue) {
        DynamicObjectCollection collection = eigenvalue.getDynamicObjectCollection("entryentity");
        for (DynamicObject dynamicObject : collection) {
            String valueType = dynamicObject.getString("valuetype");
            if (!ValueTypeEnums.QUERY.getValue().equals(valueType)) continue;
            HashMap properties = Maps.newHashMapWithExpectedSize((int)4);
            String componentId = dynamicObject.getPkValue().toString();
            properties.put("componentid", componentId);
            properties.put("valuetype", valueType);
            properties.put("storevalue_tag", dynamicObject.getString("storevalue_tag"));
            properties.put("value_tag", dynamicObject.getString("value_tag"));
            ICalculator calc = PHMJsonNodeParser.parseFromFeatureQueryDefineByMap(properties, null);
            roots.put(componentId, calc);
        }
    }

    private static void buildEigenRoots(HashMap<String, ICalculator> roots, DynamicObject bizModel) {
        Object bizModelId = bizModel.getPkValue();
        try (DataSet dataSet = DesignerUtils.queryComponent((Object)bizModelId, (ComponentType)ComponentType.EIGENVALUE);){
            for (Row row : dataSet) {
                String componentId = row.getString("component");
                Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                ICalculator calc = PHMJsonNodeParser.parseFromFeatureQueryDefine(componentId, properties, null);
                roots.put(componentId, calc);
            }
        }
    }

    private static void buildEigenRoots(HashMap<String, ICalculator> roots, DynamicObject bizModel, Map<String, Serializable> changeParam) {
        Object bizModelId = bizModel.getPkValue();
        try (DataSet dataSet = DesignerUtils.queryComponent((Object)bizModelId, (ComponentType)ComponentType.EIGENVALUE);){
            for (Row row : dataSet) {
                String componentId = row.getString("component");
                Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                ICalculator calc = PHMJsonNodeParser.parseFromFeatureQueryDefine(componentId, properties, changeParam);
                roots.put(componentId, calc);
            }
        }
    }

    private static void oldBuildEigenRoots(HashMap<String, ICalculator> roots, DynamicObject bizmodel) {
        DynamicObject[] storeeigenvalues;
        String selects = "id,storevalue,valuetype,storevalue_tag,value,value_tag,componentid";
        QFilter[] filters = new QFilter[]{new QFilter("bizmodelid", "=", bizmodel.getPkValue())};
        for (DynamicObject storeeigenvalue : storeeigenvalues = BusinessDataServiceHelper.load((String)"phm_bizmodel_eigen", (String)selects, (QFilter[])filters)) {
            String componentid = storeeigenvalue.getString("componentid");
            ICalculator calc = PHMJsonNodeParser.parseFromFeatureQueryDefine(storeeigenvalue);
            roots.put(componentid, calc);
        }
    }

    public static HashMap<String, IFilterNode> buildFilters(DynamicObject model, String type) {
        HashMap<String, IFilterNode> queryFilters = new HashMap<String, IFilterNode>();
        Object pkValue = model.getPkValue();
        if (DesignerUtils.exists((Object)pkValue)) {
            KDCloudModelBuilder.buildQueryFilters(queryFilters, pkValue);
            KDCloudModelBuilder.buildDetailFilter(queryFilters, pkValue);
        } else {
            KDCloudModelBuilder.oldBuildQueryFilters(queryFilters, pkValue);
            KDCloudModelBuilder.oldBuildDetailFilter(queryFilters, pkValue);
        }
        return queryFilters;
    }

    private static void buildDetailFilter(HashMap<String, IFilterNode> queryFilters, Object bizModelId) {
        try (DataSet dataSet = DesignerUtils.queryComponent((Object)bizModelId, (ComponentType)ComponentType.DETAIL);){
            for (Row row : dataSet) {
                String componentId = row.getString("component");
                Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                String dataJson = (String)properties.get("field_set_data_tag");
                if (StringUtils.isBlank((CharSequence)dataJson)) continue;
                KDCloudModelBuilder.addDetailFilter(queryFilters, componentId, dataJson);
            }
        }
    }

    private static void oldBuildDetailFilter(HashMap<String, IFilterNode> queryFilters, Object bizModelId) {
        DynamicObject[] detailDyObjs;
        QFilter[] dFilters = new QFilter[]{new QFilter("bizmodelid", "=", bizModelId)};
        for (DynamicObject detailDyObj : detailDyObjs = BusinessDataServiceHelper.load((String)"phm_bizmodel_detail", (String)"field_set_data_tag,componentid", (QFilter[])dFilters)) {
            String componentId = detailDyObj.getString("componentid");
            String dataJson = detailDyObj.getString("field_set_data_tag");
            if (StringUtils.isBlank((CharSequence)dataJson)) continue;
            KDCloudModelBuilder.addDetailFilter(queryFilters, componentId, dataJson);
        }
    }

    private static void addDetailFilter(HashMap<String, IFilterNode> queryFilters, String componentId, String dataJson) {
        Object[] fieldSets = DynamicObjectSerializeUtil.deserialize((String)dataJson, (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_field_set"));
        DynamicObject fieldSetData = (DynamicObject)fieldSets[0];
        DynamicObjectCollection drillingEntryentity = fieldSetData.getDynamicObjectCollection("drilling_entryentity");
        HashMap<String, String> filterMap = new HashMap<String, String>(16);
        for (DynamicObject drillingObj : drillingEntryentity) {
            String relationField = drillingObj.getString("drilling_relation");
            if (!StringUtils.isNotBlank((CharSequence)relationField)) continue;
            String filterFiled = drillingObj.getString("drilling_alias");
            filterMap.put(filterFiled.replaceAll("\\s*", ""), relationField.toLowerCase());
        }
        for (Map.Entry entry : filterMap.entrySet()) {
            String drillingId = "drilling-" + componentId;
            String drillingIdFilterId = drillingId + "\u0000" + ((String)entry.getValue()).toUpperCase();
            TextFilterNode node = new TextFilterNode(drillingIdFilterId);
            CompareSetting compareSetting = new CompareSetting(CompareOperator.EQUAL, (String)entry.getKey(), drillingId);
            CompareSetting[] compareSettings = new CompareSetting[]{compareSetting};
            node.setApplySettings(compareSettings);
            queryFilters.put(drillingIdFilterId, node);
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void buildQueryFilters(HashMap<String, IFilterNode> queryFilters, Object bizModelId) {
        try (DataSet dataSet = DesignerUtils.queryComponent((Object)bizModelId, (ComponentType)ComponentType.QUERY);){
            ArrayList<CompareSetting> compareSettings = new ArrayList<CompareSetting>();
            for (Row row : dataSet) {
                AbstractFilterNode filterNode;
                Map compareDataMap;
                String componentId = row.getString("component");
                Map properties = (Map)SerializationUtils.fromJsonString((String)row.getString("data_tag"), HashMap.class);
                String compareData = (String)properties.get("comparison_data_tag");
                if (StringUtils.isBlank((CharSequence)compareData) || (compareDataMap = (Map)SerializationUtils.fromJsonString((String)compareData, HashMap.class)).isEmpty()) continue;
                String valueType = (String)properties.get("value_type");
                switch (valueType) {
                    case "number": {
                        filterNode = new DecimalFilterNode(componentId);
                        break;
                    }
                    case "date": {
                        filterNode = new DateFilterNode(componentId);
                        break;
                    }
                    case "datetime": {
                        filterNode = new DateTimeFilterNode(componentId);
                        break;
                    }
                    default: {
                        filterNode = new TextFilterNode(componentId);
                    }
                }
                compareSettings.clear();
                for (Map.Entry entry : compareDataMap.entrySet()) {
                    CompareSetting compareSetting;
                    String key = (String)entry.getKey();
                    Object[] comparisonSets = DynamicObjectSerializeUtil.deserialize((String)((String)entry.getValue()), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_comparison_set"));
                    DynamicObject comparisonSet = (DynamicObject)comparisonSets[0];
                    DynamicObjectCollection entryentity = comparisonSet.getDynamicObjectCollection("entryentity");
                    String filterField = "";
                    String type = "";
                    String targeNodeId = "";
                    if (StringUtils.contains((CharSequence)key, (CharSequence)"detail")) {
                        targeNodeId = key;
                        for (DynamicObject entryData : entryentity) {
                            type = entryData.getString("type");
                            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                            filterField = entryData.getString("name");
                            break;
                        }
                    } else if (StringUtils.contains((CharSequence)key, (CharSequence)"param")) {
                        for (DynamicObject entryData : entryentity) {
                            type = entryData.getString("type");
                            if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                            filterField = entryData.getString("alias");
                            if (StringUtils.isEmpty((CharSequence)filterField)) {
                                filterField = entryData.getString("name");
                            }
                            filterField = filterField.toUpperCase();
                            targeNodeId = entryData.getString("nodeid");
                            break;
                        }
                    }
                    switch (type) {
                        case "equals": {
                            compareSetting = new CompareSetting(CompareOperator.EQUAL, filterField, targeNodeId);
                            break;
                        }
                        case "large_than": {
                            compareSetting = new CompareSetting(CompareOperator.GREATER, filterField, targeNodeId);
                            break;
                        }
                        case "less_than": {
                            compareSetting = new CompareSetting(CompareOperator.LESS, filterField, targeNodeId);
                            break;
                        }
                        case "large_equals": {
                            compareSetting = new CompareSetting(CompareOperator.FLOOR, filterField, targeNodeId);
                            break;
                        }
                        case "less_equals": {
                            compareSetting = new CompareSetting(CompareOperator.CEILING, filterField, targeNodeId);
                            break;
                        }
                        case "like": {
                            compareSetting = new CompareSetting(CompareOperator.LIKE, filterField, targeNodeId);
                            break;
                        }
                        default: {
                            compareSetting = new CompareSetting(CompareOperator.EQUAL, filterField, targeNodeId);
                        }
                    }
                    compareSettings.add(compareSetting);
                }
                filterNode.setApplySettings(compareSettings.toArray(new CompareSetting[0]));
                queryFilters.put(componentId, filterNode);
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    private static void oldBuildQueryFilters(HashMap<String, IFilterNode> queryFilters, Object bizModelId) {
        QFilter[] filters = new QFilter[]{new QFilter("bizmodelid", "=", bizModelId)};
        String selectFields = "id, componentid, value_type, comparison_type, comparison_data_tag";
        DynamicObjectCollection queryDyObjs = QueryServiceHelper.query((String)"phm_bizmodel_query", (String)selectFields, (QFilter[])filters);
        ArrayList<CompareSetting> compareSettings = new ArrayList<CompareSetting>();
        for (DynamicObject queryDyObj : queryDyObjs) {
            AbstractFilterNode filterNode;
            Map compareDataMap;
            String componentId = queryDyObj.getString("componentid");
            String compareData = queryDyObj.getString("comparison_data_tag");
            if (StringUtils.isBlank((CharSequence)compareData) || (compareDataMap = (Map)SerializationUtils.fromJsonString((String)compareData, HashMap.class)).isEmpty()) continue;
            String valueType = queryDyObj.getString("value_type");
            switch (valueType) {
                case "number": {
                    filterNode = new DecimalFilterNode(componentId);
                    break;
                }
                case "date": {
                    filterNode = new DateFilterNode(componentId);
                    break;
                }
                case "datetime": {
                    filterNode = new DateTimeFilterNode(componentId);
                    break;
                }
                default: {
                    filterNode = new TextFilterNode(componentId);
                }
            }
            compareSettings.clear();
            for (Map.Entry entry : compareDataMap.entrySet()) {
                CompareSetting compareSetting;
                Object entryData2;
                String type;
                String key = (String)entry.getKey();
                Object[] comparisonSets = DynamicObjectSerializeUtil.deserialize((String)((String)entry.getValue()), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"phm_comparison_set"));
                DynamicObject comparisonSet = (DynamicObject)comparisonSets[0];
                DynamicObjectCollection entryentity = comparisonSet.getDynamicObjectCollection("entryentity");
                if (StringUtils.contains((CharSequence)key, (CharSequence)"detail")) {
                    CompareSetting compareSetting2;
                    String filterFiled = "";
                    type = "";
                    for (Object entryData2 : entryentity) {
                        type = entryData2.getString("type");
                        if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                        filterFiled = entryData2.getString("name");
                        break;
                    }
                    switch (type) {
                        case "large_than": {
                            compareSetting2 = new CompareSetting(CompareOperator.GREATER, filterFiled, key);
                            break;
                        }
                        case "less_than": {
                            compareSetting2 = new CompareSetting(CompareOperator.LESS, filterFiled, key);
                            break;
                        }
                        case "large_equals": {
                            compareSetting2 = new CompareSetting(CompareOperator.FLOOR, filterFiled, key);
                            break;
                        }
                        case "less_equals": {
                            compareSetting2 = new CompareSetting(CompareOperator.CEILING, filterFiled, key);
                            break;
                        }
                        case "like": {
                            compareSetting2 = new CompareSetting(CompareOperator.LIKE, filterFiled, key);
                            break;
                        }
                        default: {
                            compareSetting2 = new CompareSetting(CompareOperator.EQUAL, filterFiled, key);
                        }
                    }
                    compareSettings.add(compareSetting2);
                    continue;
                }
                if (!StringUtils.contains((CharSequence)key, (CharSequence)"param")) continue;
                String filterField = "";
                type = "";
                String targeNodeId = "";
                entryData2 = entryentity.iterator();
                while (entryData2.hasNext()) {
                    DynamicObject entryData3 = (DynamicObject)entryData2.next();
                    type = entryData3.getString("type");
                    if (!StringUtils.isNotBlank((CharSequence)type)) continue;
                    filterField = entryData3.getString("alias");
                    if (StringUtils.isEmpty((CharSequence)filterField)) {
                        filterField = entryData3.getString("name");
                    }
                    filterField = filterField.toUpperCase();
                    targeNodeId = entryData3.getString("nodeid");
                    break;
                }
                switch (type) {
                    case "equals": {
                        compareSetting = new CompareSetting(CompareOperator.EQUAL, filterField, targeNodeId);
                        break;
                    }
                    case "large_than": {
                        compareSetting = new CompareSetting(CompareOperator.GREATER, filterField, targeNodeId);
                        break;
                    }
                    case "less_than": {
                        compareSetting = new CompareSetting(CompareOperator.LESS, filterField, targeNodeId);
                        break;
                    }
                    case "large_equals": {
                        compareSetting = new CompareSetting(CompareOperator.FLOOR, filterField, targeNodeId);
                        break;
                    }
                    case "less_equals": {
                        compareSetting = new CompareSetting(CompareOperator.CEILING, filterField, targeNodeId);
                        break;
                    }
                    case "like": {
                        compareSetting = new CompareSetting(CompareOperator.LIKE, filterField, targeNodeId);
                        break;
                    }
                    default: {
                        compareSetting = new CompareSetting(CompareOperator.EQUAL, filterField, targeNodeId);
                    }
                }
                compareSettings.add(compareSetting);
            }
            filterNode.setApplySettings(compareSettings.toArray(new CompareSetting[0]));
            queryFilters.put(componentId, filterNode);
        }
    }
}

