/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud;

import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.instance.Instance;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mq.MessageConsumer;
import kd.bos.mq.config.ConsumerDef;
import kd.bos.mq.config.QueueDef;
import kd.bos.mq.rabbit.ChannelFactory;
import kd.bos.mq.rabbit.RabbitConsumer;
import kd.bos.mq.support.QueueManager;
import kd.bos.util.ConfigurationUtil;

public class KDCloudQMDelegate {
    private static final int DEFAULT_CONSUMER_CONCURRENCY = 1;
    private static final Log logger = LogFactory.getLog(QueueManager.class);
    private static ConcurrentHashMap<String, QueueDef> queueDefs = new ConcurrentHashMap();
    private static String queueTag = System.getProperty("mq.debug.queue.tag");
    private static Map<String, Object> consumers;

    private static String getRealQueueName(String region, String queueDefName) {
        return region + "." + (queueTag == null ? queueDefName : queueDefName + "." + queueTag);
    }

    public static void add(String region, QueueDef queueDef, boolean initConsumer) {
        String queueName = KDCloudQMDelegate.getRealQueueName(region, queueDef.getName());
        queueDefs.put(queueName, queueDef);
        boolean disable = "false".equals(System.getProperty("mq.consumer.register"));
        if (!disable && initConsumer) {
            KDCloudQMDelegate.initQueueConsumers(region, queueName, queueDef);
        }
    }

    public static QueueDef get(String region, String queueDefName) {
        return queueDefs.get(KDCloudQMDelegate.getRealQueueName(region, queueDefName));
    }

    private static void initQueueConsumers(String region, String queueName, QueueDef queueDef) {
        List consumers = queueDef.getConsumers();
        if (consumers == null || consumers.isEmpty()) {
            logger.error("mq.usage config consumers is empty for " + region + "/" + queueDef.getName());
            return;
        }
        ConsumerDef consumer = (ConsumerDef)consumers.get(0);
        KDCloudQMDelegate.initConsumer(region, queueName, queueDef, consumer);
        for (int i = 1; i < consumers.size(); ++i) {
            logger.warn("mq.usage consumer " + ((ConsumerDef)consumers.get(i)).getClassName() + " ignored. only one cunsumer allowed.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initConsumer(String region, String queueName, QueueDef queueDef, ConsumerDef consumerDef) {
        String key;
        String clazz = consumerDef.getClassName();
        int concurrency = consumerDef.getConcurrency();
        if (concurrency == -1) {
            concurrency = ConfigurationUtil.getInteger((String)"mq.consumer.concurrency", (Integer)1);
        }
        if (consumers.containsKey(key = region + queueName)) {
            return;
        }
        Class<QueueManager> clazz2 = QueueManager.class;
        synchronized (QueueManager.class) {
            if (consumers.containsKey(key)) {
                // ** MonitorExit[var7_7] (shouldn't be in output)
                return;
            }
            try {
                MessageConsumer mc = (MessageConsumer)Class.forName(clazz).newInstance();
                if (Instance.isLightWeightDeploy()) {
                    Constructor<?> constructor = Class.forName("kd.bos.fake.mq.RabbitConsumerFake").getConstructor(String.class, String.class, Boolean.TYPE, Integer.TYPE, MessageConsumer.class, Integer.TYPE);
                    Object consumer = constructor.newInstance(region, queueName, consumerDef.isAutoAck(), concurrency, mc, queueDef.getMaxQueueLength());
                    consumers.put(key, consumer);
                } else {
                    Channel channel = ChannelFactory.getChannel((String)region);
                    RabbitConsumer consumer = new RabbitConsumer(region, queueName, consumerDef.isAutoAck(), concurrency, mc, queueDef.getMaxQueueLength(), channel);
                    consumers.put(key, consumer);
                    consumer.start();
                }
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new KDException((Throwable)e, BosErrorCode.mqException, new Object[]{"Can't init consumer by class " + clazz});
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroy(String region, QueueDef queueDef) {
        if (Instance.isLightWeightDeploy()) {
            return;
        }
        String key = region + queueDef.getName();
        if (!consumers.containsKey(key)) {
            return;
        }
        Class<QueueManager> clazz = QueueManager.class;
        synchronized (QueueManager.class) {
            if (!consumers.containsKey(key)) {
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
            consumers.remove(key);
            try {
                ChannelFactory.getChannel((String)region).queueDelete(queueDef.getName());
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u79fb\u9664\u961f\u5217\u5f02\u5e38\uff1a%s", (String)"KDCloudQMDelegate_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
            }
            key = KDCloudQMDelegate.getRealQueueName(region, queueDef.getName());
            if (!queueDefs.contains(key)) {
                return;
            }
            clazz = QueueManager.class;
            synchronized (QueueManager.class) {
                if (!queueDefs.contains(key)) {
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return;
                }
                queueDefs.remove(key);
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return;
            }
        }
    }

    static {
        if (!Instance.isLightWeightDeploy()) {
            Timer timer = new Timer("MQConsumerChannelMonitor - MMC");
            timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        consumers.forEach((k, v) -> {
                            RabbitConsumer consumer = (RabbitConsumer)v;
                            Channel channel = consumer.getChannel();
                            if (Instance.isPausedServiceByMonitor()) {
                                try {
                                    channel.close();
                                }
                                catch (Exception e) {
                                    logger.error("consumer mqchannel error ", (Throwable)e);
                                    throw new KDBizException((Throwable)e, new ErrorCode("", "consumer mqchannel error \uff1a%s"), new Object[]{e.getMessage()});
                                }
                            } else if (!channel.isOpen()) {
                                logger.warn("mqchannel is closed,queue is " + k + ",");
                                consumer.setChannel(ChannelFactory.getChannel((String)consumer.getRegion()));
                                consumer.start();
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error("consumer mqchannel error ", (Throwable)e);
                        throw new KDBizException((Throwable)e, new ErrorCode("", "consumer mqchannel error \uff1a%s"), new Object[]{e.getMessage()});
                    }
                }
            }, 300000L, 60000L);
        }
        consumers = new ConcurrentHashMap<String, Object>();
    }
}

