/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializeConfig;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.impl.RequestContextRunnable;
import kd.bos.util.StringUtils;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.framework.IEnvProvider;
import kd.mmc.phm.mservice.framework.mq.event.RefreshEvent;
import kd.mmc.phm.mservice.framework.mq.event.StartEvent;
import kd.mmc.phm.mservice.framework.runner.ICalcRunner;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudMetaConsts;
import kd.mmc.phm.mservice.integrate.kdcloud.KDCloudModelBuilder;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.DBAccess;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.BizModelCalcStatus;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.filter.IFilterNode;
import kd.mmc.phm.mservice.model.status.StatusSummary;
import kd.mmc.phm.mservice.utils.Utils;

public class KDCloudRunner
implements ICalcRunner {
    private static int T_COUNT = 0;
    private StatusSummary status;
    private long latestFinishTime = -1L;
    private volatile boolean isShutdown = false;
    private CalcEnv calcEnv;
    private IEnvProvider env;
    private HashMap<String, ICalculator> roots;
    private HashMap<String, IFilterNode> filters;
    private ThreadGroup tg;

    public KDCloudRunner(IEnvProvider env) {
        this.env = env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(StartEvent evt) {
        KDCloudRunner kDCloudRunner = this;
        synchronized (kDCloudRunner) {
            this.isShutdown = false;
            DynamicObject model = (DynamicObject)evt.getParams().get("model");
            Map<String, Serializable> params = evt.getParams();
            Serializable p = params.get("userId");
            String userId = p == null ? null : p.toString();
            Serializable change_map = params.get("change_map");
            HashMap changeMap = null;
            if (Objects.nonNull(change_map)) {
                changeMap = (HashMap)change_map;
            }
            HashMap filters = (HashMap)params.get("filterParams");
            this.calcImpl(model, userId, filters, changeMap);
        }
    }

    private void initEnv(DynamicObject model, Map<String, Serializable> changeMap) {
        String type = model.getDataEntityType().getName();
        this.roots = KDCloudModelBuilder.buildNodes(model, type, changeMap);
        this.filters = KDCloudModelBuilder.buildFilters(model, type);
    }

    @Override
    public void reCalc(RefreshEvent evt) {
        DynamicObject model = ORM.create().queryOne("phm_bizmodel", new QFilter[]{new QFilter("id", "=", (Object)this.env.getEnvId())});
        this.calcImpl(model, null, null, null);
    }

    private void calcImpl(DynamicObject model, final String userId, final HashMap<String, Serializable> params, Map<String, Serializable> changeMap) {
        if (this.status != null && this.status.getStatus() == BizModelCalcStatus.CALCULATING) {
            return;
        }
        StatusSummary status = new StatusSummary();
        status.setStatus(BizModelCalcStatus.CALCULATING);
        this.refreshStatus(status);
        try {
            this.initEnv(model, changeMap);
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.env.createEnvAware().initFail(this.env.getEnvId(), e);
            this.deleteResEntryRegistInfo();
            return;
        }
        if (StringUtils.isEmpty((String)userId)) {
            this.deleteLastSnapshot(RequestContext.get().getUserId());
        } else {
            this.deleteLastSnapshot(userId);
        }
        this.calcEnv = new CalcEnv(this.env, this.roots);
        this.runTask(String.format("calc - controller - %s", T_COUNT++), new Runnable(){

            @Override
            public void run() {
                KDCloudRunner.this.tg = new ThreadGroup(String.format("env(%s) - mmc", KDCloudRunner.this.env.getEnvId()));
                KDCloudRunner.this.calcEnv.calc(new CalculationCallback(userId, params));
            }
        }, new CalculationCrushHandler(this.calcEnv));
    }

    @Override
    public void refreshStatus(StatusSummary status) {
        this.status = status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StatusSummary getStatus() {
        KDCloudRunner kDCloudRunner = this;
        synchronized (kDCloudRunner) {
            return this.status;
        }
    }

    @Override
    public void cacheLatestResult(final String key, HashMap<String, Serializable> filters) {
        if (this.roots == null || this.roots.isEmpty()) {
            this.env.createCacheProvider().putData(key, "empty root nodes.");
            this.env.createCacheProvider().putData(KDCloudMetaConsts.createSnapshotStatusKey(key), BizModelCalcStatus.CRUSHED.getValue());
            return;
        }
        final IFilterNode[] currentFilters = this.buildFilterNodes(filters);
        this.runTask(String.format("mmc-phm-data-cache-%s", key), new Runnable(){

            @Override
            public void run() {
                KDCloudRunner.this.calcEnv.cacheLatestResult(new LatestResultCacheCallback(key), currentFilters);
            }
        }, new SnapshotCalculationCrushHandler(key));
    }

    @Override
    public void saveLatestSnapshot(final String userId, HashMap<String, Serializable> filters) {
        if (this.roots == null || this.roots.isEmpty()) {
            return;
        }
        this.deleteLastSnapshot(userId);
        final IFilterNode[] currentFilters = this.buildFilterNodes(filters);
        this.runTask(String.format("mmc-phm-data-snapshot-%s", userId), new Runnable(){

            @Override
            public void run() {
                KDCloudRunner.this.calcEnv.cacheLatestResult(new SnapshotSaveCallback(userId, currentFilters), currentFilters);
            }
        });
    }

    @Override
    public void deleteLastSnapshot(String userId) {
        if (this.env == null) {
            return;
        }
        ORM orm = ORM.create();
        QFilter[] filters = new QFilter[]{new QFilter("resourceid", "=", (Object)this.env.getEnvId()), new QFilter("userid", "=", (Object)userId)};
        orm.delete("bizmodelsnapshot", filters);
    }

    @Override
    public long getLatestFinishTime() {
        return this.latestFinishTime;
    }

    private synchronized void runTask(String name, Runnable runnable, Thread.UncaughtExceptionHandler handler) {
        if (this.isShutdown) {
            throw new KDBizException(SysConsts.Errors.CALC_STOPPED, new Object[0]);
        }
        RequestContext rc = RequestContextCreator.createForThreadPool();
        runnable = new RequestContextRunnable(runnable, rc);
        runnable = ThreadLifeCycleManager.wrapRunnable((Runnable)runnable);
        Thread t = new Thread(this.tg, runnable, name);
        if (handler != null) {
            t.setUncaughtExceptionHandler(handler);
        }
        t.start();
    }

    @Override
    public synchronized void runTask(String name, Runnable runnable) {
        this.runTask(name, runnable, Thread.currentThread().getUncaughtExceptionHandler());
    }

    @Override
    public synchronized void shutdown() {
        this.deleteResEntryRegistInfo();
        this.isShutdown = true;
        if (this.tg != null) {
            try {
                this.tg.stop();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.tg = null;
    }

    private IFilterNode[] buildFilterNodes(HashMap<String, Serializable> filters) {
        IFilterNode[] currentFilters = this.filters == null ? null : new IFilterNode[this.filters.size()];
        int idx = 0;
        if (filters == null) {
            currentFilters = null;
        } else {
            if (currentFilters == null) {
                return currentFilters;
            }
            for (Map.Entry<String, IFilterNode> entry : this.filters.entrySet()) {
                String key = entry.getKey();
                IFilterNode filterNode = entry.getValue();
                currentFilters[idx] = (IFilterNode)filterNode.clone();
                if (currentFilters[idx] != null) {
                    currentFilters[idx].setValue(filters.get(key));
                }
                ++idx;
            }
        }
        return currentFilters;
    }

    private void deleteResEntryRegistInfo() {
        DynamicObject serverInfo = BusinessDataServiceHelper.loadSingle((String)"phm_calc_resregist", (String)"instid, calc_res_regist_entry.resmodelid, calc_res_regist_entry.resmodelname, calc_res_regist_entry.createtime", (QFilter[])new QFilter[]{new QFilter("instip", "=", (Object)Utils.getIP())});
        String resId = this.env.getEnvId();
        DynamicObjectCollection entrys = serverInfo.getDynamicObjectCollection("calc_res_regist_entry");
        ArrayList<DynamicObject> removes = new ArrayList<DynamicObject>();
        for (DynamicObject last : entrys) {
            if (!resId.equals(last.getString("resmodelid"))) continue;
            removes.add(last);
        }
        for (DynamicObject last : removes) {
            entrys.remove((Object)last);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{serverInfo});
        String calcId = serverInfo.getString("instid") + "." + resId;
        DeleteServiceHelper.delete((String)"phm_bizmodel_calclog", (QFilter[])new QFilter[]{new QFilter("calcid", "=", (Object)calcId)});
    }

    private class SnapshotCalculationCrushHandler
    implements Thread.UncaughtExceptionHandler {
        private String key;

        public SnapshotCalculationCrushHandler(String key) {
            this.key = key;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            StringWriter message = new StringWriter();
            try {
                PrintWriter writer = new PrintWriter(message);
                e.printStackTrace(writer);
                writer.close();
                KDCloudRunner.this.env.createCacheProvider().putData(KDCloudMetaConsts.createSnapshotFailedKey(this.key), message.toString());
            }
            catch (Throwable ew) {
                KDCloudRunner.this.env.createCacheProvider().putData(KDCloudMetaConsts.createSnapshotFailedKey(this.key), "failed to save exception message.");
            }
            KDCloudRunner.this.env.createCacheProvider().putData(KDCloudMetaConsts.createSnapshotStatusKey(this.key), BizModelCalcStatus.CRUSHED.getValue());
        }
    }

    private class CalculationCrushHandler
    implements Thread.UncaughtExceptionHandler {
        private CalcEnv env;

        public CalculationCrushHandler(CalcEnv env) {
            this.env = env;
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
            this.env.getProvider().createEnvAware().onFail(this.env);
        }
    }

    private class SnapshotSaveCallback
    extends LatestResultCacheCallback {
        private IFilterNode[] currentFilters;
        private ArrayList<DBAccess> leafs;

        @Override
        protected void resolve() {
            ORM orm = ORM.create();
            DynamicObject snapshot = orm.newDynamicObject("bizmodelsnapshot");
            DynamicObjectCollection entrys = snapshot.getDynamicObjectCollection("dataentry");
            String[] filter = this.getFilterContent();
            int zero = 0;
            int one = 1;
            snapshot.set("filtercontent", (Object)filter[zero]);
            snapshot.set("filtercontent_tag", (Object)filter[one]);
            String[] model = this.getModelContent();
            snapshot.set("modelcontent", (Object)model[zero]);
            snapshot.set("modelcontent_tag", (Object)model[one]);
            snapshot.set("resourceid", (Object)KDCloudRunner.this.env.getEnvId());
            snapshot.set("version", (Object)"");
            snapshot.set("savetime", (Object)System.currentTimeMillis());
            snapshot.set("userid", (Object)RequestContext.get().getUserId());
            snapshot.set("snapshot", (Object)"snapshot content.");
            snapshot.set("snapshot_tag", (Object)JSON.toJSONString((Object)this.latestResult, (SerializeConfig)this.config, (SerializerFeature[])new SerializerFeature[0]));
            for (DBAccess leaf : this.leafs) {
                DynamicObject entry = orm.newDynamicObject(entrys.getDynamicObjectType());
                entry.set("nodeid", (Object)leaf.getId());
                entry.set("sql", (Object)leaf.getSQL());
                DBRows rows = (DBRows)leaf.getLatestResult(KDCloudRunner.this.calcEnv);
                entry.set("datas", (Object)JSON.toJSONString((Object)rows.getSortedColLabels()));
                entry.set("datas_tag", (Object)JSON.toJSONString((Object)rows, (SerializeConfig)this.config, (SerializerFeature[])new SerializerFeature[0]));
                entrys.add((Object)entry);
            }
            orm.insert(snapshot);
        }

        public SnapshotSaveCallback(String userId, IFilterNode[] currentFilters) {
            super(userId);
            this.leafs = new ArrayList();
            this.currentFilters = currentFilters;
        }

        private String[] getFilterContent() {
            if (this.currentFilters == null || this.currentFilters.length == 0) {
                return new String[]{"empty filters.", null};
            }
            ArrayList filters = new ArrayList();
            for (IFilterNode fn : this.currentFilters) {
                HashMap<String, Object> filter = new HashMap<String, Object>();
                filters.add(filter);
                filter.put("cn", fn.getClass().getName());
                filter.put("id", fn.getId());
                filter.put("v", fn.getValue());
                filter.put("vt", (Object)fn.getVType());
                CompareSetting[] settings = fn.getApplySettings();
                if (settings == null || settings.length == 0) continue;
                ArrayList avatars = new ArrayList();
                for (CompareSetting cs : settings) {
                    HashMap<String, Object> avatar = new HashMap<String, Object>();
                    avatar.put("tc", cs.getCol());
                    avatar.put("op", (Object)cs.getOp());
                    avatar.put("tn", cs.getTargetNodeId());
                    avatar.put("v", cs.getValue());
                    avatars.add(avatar);
                }
                filter.put("cs", avatars);
            }
            return new String[]{"filter count: " + filters.size(), JSON.toJSONString(filters)};
        }

        private String[] getModelContent() {
            if (KDCloudRunner.this.roots.isEmpty()) {
                return new String[]{"empty nodes.", "empty nodes"};
            }
            ArrayList<HashMap<String, Object>> nodes = new ArrayList<HashMap<String, Object>>();
            for (ICalculator root : KDCloudRunner.this.roots.values()) {
                HashMap<String, Object> avatar = new HashMap<String, Object>();
                this.recursiveVisitNodes(root, avatar);
                nodes.add(avatar);
            }
            return new String[]{"root count: " + nodes.size(), JSON.toJSONString(nodes)};
        }

        private void recursiveVisitNodes(ICalculator root, HashMap<String, Object> avatar) {
            if (root instanceof DBAccess) {
                this.leafs.add((DBAccess)root);
            }
            avatar.put("cn", root.getClass().getName());
            avatar.put("id", root.getId());
            avatar.put("vt", (Object)root.getVType());
            ICalculator[] params = root.getParams();
            if (params != null && params.length > 0) {
                ArrayList<HashMap<String, Object>> nodes = new ArrayList<HashMap<String, Object>>();
                for (ICalculator param : params) {
                    HashMap<String, Object> childAvatar = new HashMap<String, Object>();
                    this.recursiveVisitNodes(param, childAvatar);
                    nodes.add(childAvatar);
                }
                avatar.put("ps", nodes);
            }
        }
    }

    private class LatestResultCacheCallback
    implements CalcEnv.IRootNodeFinishCallback {
        private HashMap<String, String> tags = new HashMap();
        protected SerializeConfig config = new SerializeConfig();
        protected String key;
        protected HashMap<String, Serializable> latestResult = new HashMap();

        public LatestResultCacheCallback(String key) {
            for (String nodeId : KDCloudRunner.this.roots.keySet()) {
                this.tags.put(((ICalculator)KDCloudRunner.this.roots.get(nodeId)).getId(), nodeId);
            }
            this.key = key;
            this.config.put(DBRows.class, DBRows.createJSONSerializer());
            this.config.put(Matrix.class, Matrix.createJSONSerializer());
        }

        @Override
        public void finish(ICalculator root) {
            this.recursiveFetchResults(root);
            if (this.tags.isEmpty()) {
                this.resolve();
            }
        }

        private void recursiveFetchResults(ICalculator root) {
            if (!this.tags.containsKey(root.getId())) {
                return;
            }
            Object result = root.getLatestResult(KDCloudRunner.this.calcEnv);
            if (result instanceof Double) {
                Double d = (Double)result;
                if (Double.isInfinite(d)) {
                    result = "Divide By Zero";
                } else if (Double.isNaN(d)) {
                    result = "NaN";
                }
            }
            this.latestResult.put(this.tags.get(root.getId()), (Serializable)result);
            this.tags.remove(root.getId());
            ICalculator[] params = root.getParams();
            if (params != null) {
                for (ICalculator param : params) {
                    this.recursiveFetchResults(param);
                }
            }
        }

        protected void resolve() {
            KDCloudRunner.this.env.createCacheProvider().putData(this.key, JSON.toJSONString(this.latestResult, (SerializeConfig)this.config, (SerializerFeature[])new SerializerFeature[0]));
            KDCloudRunner.this.env.createCacheProvider().putData(KDCloudMetaConsts.createSnapshotStatusKey(this.key), BizModelCalcStatus.FINISHED.getValue());
        }
    }

    private class CalculationCallback
    implements CalcEnv.IRootNodeFinishCallback {
        private HashSet<String> tags = new HashSet();
        private String userId;
        private HashMap<String, Serializable> params;

        public CalculationCallback(String userId, HashMap<String, Serializable> params) {
            for (ICalculator cal : KDCloudRunner.this.roots.values()) {
                this.tags.add(cal.getId());
            }
            this.userId = userId;
            this.params = params;
        }

        @Override
        public void finish(ICalculator root) {
            KDCloudRunner.this.latestFinishTime = System.currentTimeMillis();
            this.tags.remove(root.getId());
            if (this.tags.isEmpty()) {
                StatusSummary status = new StatusSummary();
                status.setStatus(BizModelCalcStatus.FINISHED);
                KDCloudRunner.this.refreshStatus(status);
                if (!StringUtils.isEmpty((String)this.userId)) {
                    KDCloudRunner.this.saveLatestSnapshot(this.userId, this.params);
                }
            }
        }
    }
}

