/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.integrate.kdcloud.parser;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DBRoute;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.phm.common.util.CalculationTreeNode;
import kd.mmc.phm.common.util.CalculationTreeUtils;
import kd.mmc.phm.common.util.CalculationUtils;
import kd.mmc.phm.common.util.DesignerUtils;
import kd.mmc.phm.mservice.model.KV;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractGroupRowsResolver;
import kd.mmc.phm.mservice.model.calculator.impl.Average;
import kd.mmc.phm.mservice.model.calculator.impl.Const;
import kd.mmc.phm.mservice.model.calculator.impl.Count;
import kd.mmc.phm.mservice.model.calculator.impl.DBAccess;
import kd.mmc.phm.mservice.model.calculator.impl.IGroupRowsResolver;
import kd.mmc.phm.mservice.model.calculator.impl.Max;
import kd.mmc.phm.mservice.model.calculator.impl.Min;
import kd.mmc.phm.mservice.model.calculator.impl.Sum;
import kd.mmc.phm.mservice.model.calculator.impl.group.Group;
import kd.mmc.phm.mservice.model.calculator.impl.join.AbstractJoinCalculator;
import kd.mmc.phm.mservice.model.calculator.impl.join.InnerJoin;
import kd.mmc.phm.mservice.model.calculator.impl.join.LeftJoin;
import kd.mmc.phm.mservice.model.calculator.impl.join.RightJoin;
import kd.mmc.phm.mservice.model.calculator.impl.select.RowSelect;
import kd.mmc.phm.mservice.model.calculator.impl.sort.Sort;
import kd.mmc.phm.mservice.model.enums.CompareOperator;
import kd.mmc.phm.mservice.model.enums.VType;
import kd.mmc.phm.mservice.model.filter.CompareSetting;

public class PHMJsonNodeParser {
    public static ICalculator parseFromDetailQueryDefine(String componentId, String storevalueTag) {
        Map queryDefineMap = (Map)JSONObject.parse((String)storevalueTag);
        Iterator iterator = queryDefineMap.entrySet().iterator();
        if (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            Map value = (Map)entry.getValue();
            boolean isDefSql = (Boolean)value.get("isdefsql");
            if (isDefSql) {
                String sql = (String)value.get("sql_tag");
                return new DBAccess(componentId, new DBRoute(PHMJsonNodeParser.getDbKey(value)), sql);
            }
            return PHMJsonNodeParser.parseFeatureNode(componentId, value);
        }
        throw new KDBizException(new ErrorCode("MODEL_PARSE_FAILED", "failed to parse feature model."), new Object[0]);
    }

    public static ICalculator parseFromFeatureQueryDefineByMap(Map<String, String> define, Map<String, Serializable> changeParam) {
        if (changeParam == null) {
            changeParam = new HashMap<String, Serializable>(8);
        }
        String componentid = define.get("componentid");
        String valueType = define.get("valuetype");
        String storevalue_tag = define.get("storevalue_tag");
        String value_tag = define.get("value_tag");
        if (StringUtils.equals((CharSequence)"cal", (CharSequence)valueType)) {
            Map id_valueMap = (Map)JSONObject.parse((String)value_tag);
            CalculationTreeNode treeNode = CalculationTreeUtils.getTreeNodeByXml((String)storevalue_tag);
            String nodeId = treeNode.getId();
            String shortcomponentId = componentid;
            if (StringUtils.isNotEmpty((CharSequence)componentid) && componentid.length() > 11) {
                shortcomponentId = componentid.substring(0, 11);
            }
            ICalculator calculator = PHMJsonNodeParser.getCalculator(shortcomponentId, nodeId, treeNode, id_valueMap, changeParam);
            return calculator;
        }
        if (StringUtils.equals((CharSequence)"txt", (CharSequence)valueType) || StringUtils.equals((CharSequence)"f7", (CharSequence)valueType) || StringUtils.equals((CharSequence)"eigen", (CharSequence)valueType)) {
            if (changeParam.containsKey(componentid)) {
                value_tag = changeParam.get(componentid).toString();
            }
            Const calculator = new Const(componentid, (Serializable)((Object)value_tag));
            return calculator;
        }
        if (StringUtils.equals((CharSequence)"query", (CharSequence)valueType)) {
            Map id_valueMap = (Map)JSONObject.parse((String)storevalue_tag);
            Map.Entry entry = id_valueMap.entrySet().iterator().next();
            String dbAccessId = (String)entry.getKey();
            Map nodeMap = (Map)entry.getValue();
            boolean isdefsql = (Boolean)nodeMap.get("isdefsql");
            if (changeParam.containsKey(componentid)) {
                String changeValue = changeParam.get(componentid).toString();
                Const calculator = new Const(componentid, (Serializable)((Object)changeValue));
                return calculator;
            }
            if (isdefsql) {
                String sql = (String)nodeMap.get("sql_tag");
                DBAccess d = new DBAccess(dbAccessId, new DBRoute(PHMJsonNodeParser.getDbKey(nodeMap)), sql);
                return d;
            }
            return PHMJsonNodeParser.parseFeatureNode(dbAccessId, nodeMap);
        }
        throw new KDBizException(new ErrorCode("MODEL_PARSE_FAILED", "failed to parse feature model."), new Object[0]);
    }

    public static ICalculator parseFromFeatureQueryDefine(DynamicObject define) {
        String componentid = define.getString("componentid");
        String valueType = define.getString("valuetype");
        String storevalue_tag = define.getString("storevalue_tag");
        String value_tag = define.getString("value_tag");
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("componentid", componentid);
        map.put("valuetype", valueType);
        map.put("storevalue_tag", storevalue_tag);
        map.put("value_tag", value_tag);
        return PHMJsonNodeParser.parseFromFeatureQueryDefineByMap(map, null);
    }

    public static ICalculator parseFromFeatureQueryDefine(String componentId, Map<String, Object> properties, Map<String, Serializable> changeParam) {
        if (changeParam == null) {
            changeParam = new HashMap<String, Serializable>(8);
        }
        String valueType = (String)properties.get("valuetype");
        String storevalue_tag = (String)properties.get("storevalue_tag");
        String value_tag = (String)properties.get("value_tag");
        HashMap map = DesignerUtils.newHashMapWithExpectedSize((int)4);
        map.put("componentid", componentId);
        map.put("valuetype", valueType);
        map.put("storevalue_tag", storevalue_tag);
        map.put("value_tag", value_tag);
        return PHMJsonNodeParser.parseFromFeatureQueryDefineByMap(map, changeParam);
    }

    private static ICalculator getCalculator(String shortcomponentId, String nodeId, CalculationTreeNode treeNode, Map<String, Map<String, Object>> id_valueMap, Map<String, Serializable> changeMap) {
        String ref;
        Map<String, Object> nodeMap = id_valueMap.get(nodeId);
        String nodeType = (String)nodeMap.get("type");
        if (nodeType.equals("A")) {
            String implementClass;
            String ref2;
            String belong = nodeMap.get("belong") == null ? "" : nodeMap.get("belong").toString();
            String modelId = nodeMap.get("model") == null ? "" : nodeMap.get("model").toString();
            String string = ref2 = nodeMap.get("eigenid") == null ? "" : nodeMap.get("eigenid").toString();
            if (changeMap.containsKey(ref2)) {
                String changeValue = changeMap.get(ref2).toString();
                Const c = CalculationUtils.isNumeric((String)changeValue) ? new Const(nodeId, new BigDecimal(changeValue)) : new Const(nodeId, (Serializable)((Object)changeValue));
                return c;
            }
            QFilter[] qfilter = new QFilter[]{StringUtils.isNotEmpty((CharSequence)modelId) ? new QFilter("id", "=", (Object)Long.valueOf(modelId)) : new QFilter("number", "=", (Object)belong)};
            DynamicObject calculation = BusinessDataServiceHelper.loadSingle((String)"phm_calculationmodel", (String)"id,implementclass", (QFilter[])qfilter);
            if (calculation == null) {
                throw new KDBizException(new ErrorCode("BizException", ResManager.loadKDString((String)"\u8ba1\u7b97\u6a21\u578b\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff1atreeNode:", (String)"PHMJsonNodeParser_0", (String)"mmc-phm-mservice", (Object[])new Object[0]) + JSONObject.toJSON((Object)treeNode)), new Object[0]);
            }
            String string2 = implementClass = calculation.get("implementclass") == null ? "" : calculation.get("implementclass").toString();
            if (StringUtils.isEmpty((CharSequence)implementClass)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u7b97\u6a21\u578b\u5b9e\u73b0\u7c7b\u4e0d\u80fd\u4e3a\u7a7a\uff1atreeNode:", (String)"PHMJsonNodeParser_0", (String)"mmc-phm-mservice", (Object[])new Object[0]) + JSONObject.toJSON((Object)treeNode));
            }
            Class<?> clazz = null;
            try {
                clazz = Class.forName(implementClass.trim());
            }
            catch (ClassNotFoundException e) {
                throw new KDBizException(new ErrorCode("ClassNotFoundException", "ClassNotFoundException" + implementClass + JSONObject.toJSON((Object)treeNode)), new Object[]{e});
            }
            Class[] parameterTypes = new Class[]{String.class};
            Constructor<?> constructor = null;
            try {
                constructor = clazz.getConstructor(parameterTypes);
            }
            catch (NoSuchMethodException e) {
                throw new KDBizException(new ErrorCode("NoSuchMethodException", "NoSuchMethodException" + implementClass + JSONObject.toJSON((Object)treeNode)), new Object[]{e});
            }
            Object[] parameters = new Object[]{shortcomponentId + nodeId};
            Object o = null;
            try {
                o = constructor.newInstance(parameters);
            }
            catch (IllegalAccessException e) {
                throw new KDBizException(new ErrorCode("IllegalAccessException", "IllegalAccessException " + implementClass + JSONObject.toJSON((Object)treeNode)), new Object[]{e});
            }
            catch (InstantiationException e) {
                throw new KDBizException(new ErrorCode("InstantiationException", "InstantiationException" + implementClass + JSONObject.toJSON((Object)treeNode)), new Object[]{e});
            }
            catch (InvocationTargetException e) {
                throw new KDBizException(new ErrorCode("InvocationTargetException", "InvocationTargetException" + implementClass + JSONObject.toJSON((Object)treeNode)), new Object[]{e});
            }
            if (o instanceof AbstractCalculator) {
                AbstractCalculator calculator = (AbstractCalculator)o;
                List childs = treeNode.getChilds();
                ArrayList<ICalculator> params = new ArrayList<ICalculator>(childs.size());
                for (CalculationTreeNode child : childs) {
                    String childId = child.getId();
                    ICalculator childCalculator = PHMJsonNodeParser.getCalculator(shortcomponentId, childId, child, id_valueMap, changeMap);
                    params.add(childCalculator);
                }
                if (!params.isEmpty()) {
                    calculator.setParams(params.toArray(new ICalculator[0]));
                }
                return calculator;
            }
            throw new KDBizException(o.getClass() + ResManager.loadKDString((String)"\u4e0d\u662f AbstractCalculator \u7c7b\u578b", (String)"PHMJsonNodeParser_1", (String)"mmc-phm-mservice", (Object[])new Object[0]));
        }
        String setway = (String)nodeMap.get("setway");
        if ("eigen".equals(setway)) {
            String ref3;
            String eigen = (String)nodeMap.get("eigen");
            boolean isint = Boolean.parseBoolean(nodeMap.get("isint").toString());
            boolean isflot = Boolean.parseBoolean(nodeMap.get("isflot").toString());
            String string = ref3 = nodeMap.get("eigenid") == null ? "" : nodeMap.get("eigenid").toString();
            if (changeMap.containsKey(ref3)) {
                String changeValue = changeMap.get(ref3).toString();
                Const c = CalculationUtils.isNumeric((String)changeValue) ? new Const(nodeId, new BigDecimal(changeValue)) : new Const(nodeId, (Serializable)((Object)changeValue));
                return c;
            }
            Const c = (isint || isflot) && CalculationUtils.isNumeric((String)eigen) ? new Const(nodeId, new BigDecimal(eigen)) : new Const(nodeId, (Serializable)((Object)eigen));
            return c;
        }
        boolean isdefsql = nodeMap.get("isdefsql") == null ? false : Boolean.parseBoolean(nodeMap.get("isdefsql").toString());
        String string = ref = nodeMap.get("ref") == null ? "" : nodeMap.get("ref").toString();
        if (changeMap.containsKey(ref)) {
            String changeValue = changeMap.get(ref).toString();
            Const c = CalculationUtils.isNumeric((String)changeValue) ? new Const(nodeId, new BigDecimal(changeValue)) : new Const(nodeId, (Serializable)((Object)changeValue));
            return c;
        }
        if (isdefsql) {
            String sql = (String)nodeMap.get("sql_tag");
            DBAccess d = new DBAccess(nodeId, new DBRoute(PHMJsonNodeParser.getDbKey(nodeMap)), sql);
            return d;
        }
        return PHMJsonNodeParser.parseFeatureNode(nodeId, nodeMap);
    }

    private static ICalculator parseFeatureNode(String dbAccessId, Map<String, Object> nodeMap) {
        ICalculator ret;
        int i;
        JSONArray sqlFilters = (JSONArray)nodeMap.get("termentry");
        JSONArray outputCols = JSONArray.parseArray((String)((String)nodeMap.get("params_tag")));
        JSONArray paramCols = JSONArray.parseArray((String)((String)nodeMap.get("outputinfo_tag")));
        String json = (String)nodeMap.get("groupinfo_tag");
        Map groupCols = StringUtils.isEmpty((CharSequence)json) ? new HashMap() : (Map)JSON.parseObject((String)json, Map.class);
        json = (String)nodeMap.get("orderinfo_tag");
        Map sortCols = StringUtils.isEmpty((CharSequence)json) ? new HashMap() : (Map)JSON.parseObject((String)json, Map.class);
        json = (String)nodeMap.get("descinfo_tag");
        Set descCols = StringUtils.isEmpty((CharSequence)json) ? new HashSet() : (Set)JSON.parseObject((String)json, Set.class);
        json = (String)nodeMap.get("functioninfo_tag");
        Map agregateCols = StringUtils.isEmpty((CharSequence)json) ? new HashMap() : (Map)JSON.parseObject((String)json, Map.class);
        HashSet<String> cols = new HashSet<String>();
        if (Objects.isNull(outputCols)) {
            throw new KDBizException(new ErrorCode("NullPointerException", ResManager.loadKDString((String)"NullPointerException \u8f93\u51fa\u5217\u4e3a\u7a7a\uff0cdbAccessId\uff1a", (String)"PHMJsonNodeParser_2", (String)"mmc-phm-mservice", (Object[])new Object[0]) + dbAccessId + ",nodeMap:" + JSONObject.toJSON(nodeMap)), new Object[0]);
        }
        for (i = 0; i < outputCols.size(); ++i) {
            cols.add(outputCols.getString(i));
        }
        if (Objects.isNull(paramCols)) {
            throw new KDBizException(new ErrorCode("NullPointerException", ResManager.loadKDString((String)"NullPointerException \u53c2\u6570\u5217\u4e3a\u7a7a\uff0cdbAccessId\uff1a", (String)"PHMJsonNodeParser_3", (String)"mmc-phm-mservice", (Object[])new Object[0]) + dbAccessId + ",nodeMap:" + JSONObject.toJSON(nodeMap)), new Object[0]);
        }
        for (i = 0; i < paramCols.size(); ++i) {
            cols.add(paramCols.getString(i));
        }
        if (Objects.nonNull(groupCols)) {
            for (Object field : groupCols.keySet()) {
                cols.add(String.valueOf(field));
            }
        }
        if (Objects.nonNull(sortCols)) {
            for (Object field : sortCols.keySet()) {
                cols.add(String.valueOf(field));
            }
        }
        Map aliasMap = (Map)JSON.parseObject((String)((String)nodeMap.get("nameinfo_tag")), Map.class);
        ArrayList<CompareSetting> settings = new ArrayList<CompareSetting>();
        StringBuilder maskStr = new StringBuilder();
        for (int i2 = 0; i2 < sqlFilters.size(); ++i2) {
            JSONObject condition = sqlFilters.getJSONObject(i2);
            String field = condition.getString("field");
            Integer leftCount = condition.getInteger("leftterm");
            Integer rightCount = condition.getInteger("rightterm");
            if (leftCount != null) {
                for (int j = 0; j < leftCount; ++j) {
                    maskStr.append(" (");
                }
            }
            CompareSetting cs = new CompareSetting(CompareOperator.parseStr(condition.getString("term")), ((String)aliasMap.get(field)).toUpperCase(), null);
            if (!"field".equalsIgnoreCase(condition.getString("valuetype"))) {
                cs.setVt(VType.TABLEFIELD);
            }
            cs.setValue((Serializable)((Object)condition.getString("value").toUpperCase()));
            settings.add(cs);
            cols.add(field);
            maskStr.append(" @row").append(i2);
            if (rightCount != null) {
                for (int j = rightCount.intValue(); j < 0; ++j) {
                    maskStr.append(')');
                }
            }
            if (i2 >= sqlFilters.size() - 1) continue;
            maskStr.append(' ').append(condition.getString("linkterm"));
        }
        TreeNode tableTreeRoot = (TreeNode)SerializationUtils.fromJsonString((String)((String)nodeMap.get("linkinfo_tag")), TreeNode.class);
        TreeNode node = (TreeNode)tableTreeRoot.getChildren().get(0);
        DBAccess mainTbl = PHMJsonNodeParser.buildNode(node, aliasMap, cols);
        mainTbl.setId(dbAccessId);
        ICalculator factor = PHMJsonNodeParser.buildTableRelations(cols, aliasMap, mainTbl, node);
        if (sqlFilters.size() == 0) {
            ret = factor;
        } else {
            ret = new RowSelect(UUID.randomUUID().toString(), maskStr.toString(), settings.toArray(new CompareSetting[0]));
            ret.setParams(factor);
        }
        ret = PHMJsonNodeParser.groupWrapper(ret, agregateCols, groupCols, aliasMap);
        ret = PHMJsonNodeParser.sortWrapper(ret, sortCols, descCols, aliasMap);
        return ret;
    }

    private static ICalculator groupWrapper(ICalculator rsCalc, Map<?, ?> agregateCols, Map<?, ?> groupCols, Map<String, String> aliasMap) {
        if (groupCols.isEmpty() && agregateCols.isEmpty()) {
            return rsCalc;
        }
        ArrayList<String> cols = new ArrayList<String>();
        for (Object field : groupCols.keySet()) {
            cols.add(aliasMap.get(field));
        }
        HashMap<String, IGroupRowsResolver> agregates = new HashMap<String, IGroupRowsResolver>();
        for (Map.Entry entry : agregateCols.entrySet()) {
            AbstractGroupRowsResolver resolver;
            Object field = entry.getKey();
            Object value = entry.getValue();
            String func = String.valueOf(value).toUpperCase();
            if ("AVG".equalsIgnoreCase(func)) {
                resolver = new Average("AVG");
            } else if ("SUM".equalsIgnoreCase(func)) {
                resolver = new Sum("SUM");
            } else if ("MIN".equalsIgnoreCase(func)) {
                resolver = new Min("MIN");
            } else if ("MAX".equalsIgnoreCase(func)) {
                resolver = new Max("MAX");
            } else if ("COUNT".equalsIgnoreCase(func)) {
                resolver = new Count("COUNT");
            } else {
                throw new KDBizException(new ErrorCode("UNKNOWN_AGREGATE_FUNCTION", func), new Object[0]);
            }
            agregates.put(aliasMap.get(field).toUpperCase(), resolver);
        }
        Group group = new Group(UUID.randomUUID().toString(), agregates, cols.toArray(new String[0]));
        group.setParams(rsCalc);
        return group;
    }

    private static ICalculator sortWrapper(ICalculator rsCalc, Map<?, ?> sortCols, Set<?> descCols, Map<String, String> aliasMap) {
        if (sortCols.isEmpty()) {
            return rsCalc;
        }
        ArrayList<KV<String, Boolean>> cols = new ArrayList<KV<String, Boolean>>();
        ArrayList sortedFields = new ArrayList();
        for (Map.Entry<?, ?> entry : sortCols.entrySet()) {
            Object field = entry.getKey();
            Object value = entry.getValue();
            KV kv = new KV(Integer.parseInt(String.valueOf(value)), field);
            sortedFields.add(kv);
        }
        sortedFields.sort(new Comparator<KV<Integer, Object>>(){

            @Override
            public int compare(KV<Integer, Object> o1, KV<Integer, Object> o2) {
                return ((Integer)o1.key).compareTo((Integer)o2.key);
            }
        });
        for (int i = 0; i < sortedFields.size(); ++i) {
            KV<String, Boolean> pair = new KV<String, Boolean>(aliasMap.get(((KV)sortedFields.get((int)i)).value), !descCols.contains(((KV)sortedFields.get((int)i)).value));
            cols.add(pair);
        }
        Sort sort = new Sort(UUID.randomUUID().toString(), cols);
        sort.setParams(rsCalc);
        return sort;
    }

    private static DBAccess buildNode(TreeNode node, Map<String, String> aliasMap, HashSet<String> cols) {
        Map detail = (Map)JSON.parseObject((String)node.getLongNumber(), Map.class);
        String tableName = (String)detail.get("tablename");
        String tableAlias = (String)detail.get("othername");
        if (tableName.contains("@")) {
            tableName = tableName.split("@")[0];
        }
        String dbKey = detail.get("dbkey") == null ? "phm" : (String)detail.get("dbkey");
        String[] fields = PHMJsonNodeParser.buildFields(aliasMap, cols, tableAlias);
        DBAccess table = new DBAccess(UUID.randomUUID().toString(), new DBRoute(dbKey), tableName, tableAlias, fields);
        return table;
    }

    private static String[] buildFields(Map<String, String> aliasMap, HashSet<String> cols, String tableAlias) {
        ArrayList<String> ret = new ArrayList<String>();
        Iterator<String> iter = cols.iterator();
        StringBuilder buffer = new StringBuilder();
        while (iter.hasNext()) {
            String colName = iter.next();
            String[] parts = colName.split("\\.");
            if (!parts[0].equals(tableAlias)) continue;
            buffer.append(colName).append(" AS ").append(aliasMap.get(colName));
            ret.add(buffer.toString());
            buffer.setLength(0);
        }
        return ret.toArray(new String[0]);
    }

    private static ICalculator buildTableRelations(HashSet<String> cols, Map<String, String> aliasMap, DBAccess parent, TreeNode root) {
        if (root.getChildren() == null || root.getChildren().isEmpty()) {
            return parent;
        }
        AbstractCalculator ret = parent;
        ArrayList<CompareSetting> settings = new ArrayList<CompareSetting>();
        for (TreeNode node : root.getChildren()) {
            AbstractJoinCalculator join;
            Map detail = (Map)JSON.parseObject((String)node.getLongNumber(), Map.class);
            DBAccess subTbl = PHMJsonNodeParser.buildNode(node, aliasMap, cols);
            settings.clear();
            JSONArray conditions = JSONArray.parseArray((String)((String)detail.get("tableentry")));
            for (int i = 0; i < conditions.size(); ++i) {
                JSONObject condition = conditions.getJSONObject(i);
                String srcField = condition.getString("linkfield");
                String targetField = condition.getString("mainfield");
                CompareSetting setting = new CompareSetting(CompareOperator.EQUAL, aliasMap.get(srcField).toUpperCase(), null);
                setting.setValue((Serializable)((Object)aliasMap.get(targetField).toUpperCase()));
                setting.setVt(VType.TABLEFIELD);
                settings.add(setting);
                parent.appendCol(srcField + " AS " + aliasMap.get(srcField));
                subTbl.appendCol(targetField + " AS " + aliasMap.get(targetField));
            }
            ICalculator sub = PHMJsonNodeParser.buildTableRelations(cols, aliasMap, subTbl, node);
            String lt = ((String)detail.get("linktype")).toUpperCase();
            if (lt.equalsIgnoreCase("LEFT")) {
                join = new LeftJoin(UUID.randomUUID().toString(), "", settings.toArray(new CompareSetting[0]));
            } else if (lt.equalsIgnoreCase("RIGHT")) {
                join = new RightJoin(UUID.randomUUID().toString(), "", settings.toArray(new CompareSetting[0]));
            } else if (lt.equalsIgnoreCase("INNER")) {
                join = new InnerJoin(UUID.randomUUID().toString(), "", settings.toArray(new CompareSetting[0]));
            } else {
                throw new KDBizException(new ErrorCode("UNKNOWN_TABLE_JOIN_TYPE", lt), new Object[0]);
            }
            if (ret == parent) {
                join.setParams(parent, sub);
            } else {
                join.setParams(ret, sub);
            }
            ret = join;
        }
        return ret;
    }

    private static String getDbKey(Map<String, Object> value) {
        String dbKey = "phm";
        TreeNode tableTreeRoot = (TreeNode)SerializationUtils.fromJsonString((String)((String)value.get("linkinfo_tag")), TreeNode.class);
        TreeNode mainTableNode = (TreeNode)tableTreeRoot.getChildren().get(0);
        Map detail = (Map)JSON.parseObject((String)mainTableNode.getLongNumber(), Map.class);
        dbKey = detail.get("dbkey") == null ? "phm" : (String)detail.get("dbkey");
        return dbKey;
    }
}

