/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import kd.mmc.phm.mservice.framework.IEnvProvider;
import kd.mmc.phm.mservice.model.INodeStatusAware;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.enums.BizModelCalcStatus;
import kd.mmc.phm.mservice.model.filter.IFilterNode;
import kd.mmc.phm.mservice.model.status.StatusSummary;
import org.apache.log4j.Logger;

public class CalcEnv {
    private static Logger logger = Logger.getLogger(CalcEnv.class);
    private static ThreadLocal<IFilterNode[]> filterCache = new ThreadLocal();
    private IEnvProvider env;
    private HashMap<String, ICalculator> roots = new HashMap();
    private String runningId = UUID.randomUUID().toString();
    private int percent = 0;
    private int step = 0;
    private HashSet<String> unFinishedRoots;

    public CalcEnv(IEnvProvider env, HashMap<String, ICalculator> roots) {
        this.env = env;
        this.roots = roots;
    }

    public IEnvProvider getProvider() {
        return this.env;
    }

    public HashMap<String, ICalculator> getRoots() {
        return this.roots;
    }

    public void refreshRunningId() {
        this.runningId = UUID.randomUUID().toString();
    }

    public String getRunningId() {
        return this.runningId;
    }

    public INodeStatusAware getNodeAware() {
        return this.env.createNodeAware();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calc(final IRootNodeFinishCallback cb) {
        this.env.createEnvAware().onStart(this);
        if (this.getRoots().isEmpty()) {
            this.env.createEnvAware().onFinish(this);
            return;
        }
        this.step = 100 / this.getRoots().size();
        this.unFinishedRoots = new HashSet();
        for (final ICalculator root : this.getRoots().values()) {
            HashSet<String> hashSet = this.unFinishedRoots;
            synchronized (hashSet) {
                this.unFinishedRoots.add(root.getId());
            }
            this.runTask(String.format("%s node(%s) - mmc - calc", root.getClass().getSimpleName(), root.getId()), new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        root.calc(CalcEnv.this);
                        logger.info((Object)String.format("---root %s(%s), Calculation completed", root.getClass().getSimpleName(), root.getId()));
                    }
                    finally {
                        HashSet hashSet = CalcEnv.this.unFinishedRoots;
                        synchronized (hashSet) {
                            CalcEnv.this.percent = CalcEnv.this.percent + CalcEnv.this.step;
                            CalcEnv.this.env.createEnvAware().updateProgress(CalcEnv.this.percent);
                            CalcEnv.this.unFinishedRoots.remove(root.getId());
                        }
                        if (cb != null) {
                            cb.finish(root);
                        }
                        if (!CalcEnv.this.isRunning()) {
                            HashMap<String, Throwable> errors = new HashMap<String, Throwable>();
                            for (ICalculator root2 : CalcEnv.this.getRoots().values()) {
                                errors.putAll(CalcEnv.this.statErrors(root2));
                            }
                            StatusSummary status = new StatusSummary();
                            if (errors.isEmpty()) {
                                CalcEnv.this.env.createEnvAware().onFinish(CalcEnv.this);
                                status.setStatus(BizModelCalcStatus.FINISHED);
                            } else {
                                CalcEnv.this.env.createEnvAware().onFail(CalcEnv.this);
                                status.setStatus(BizModelCalcStatus.CRUSHED);
                                status.setErrors(errors);
                            }
                            CalcEnv.this.env.createRunner().refreshStatus(status);
                        }
                    }
                }
            });
        }
    }

    public void cacheLatestResult(final IRootNodeFinishCallback cb, final IFilterNode[] filters) {
        for (final ICalculator root : this.getRoots().values()) {
            this.runTask(String.format("%s node(%s) - mmc - cache result", root.getClass().getSimpleName(), root.getId()), new Runnable(){

                @Override
                public void run() {
                    filterCache.set(filters);
                    try {
                        root.filter(CalcEnv.this);
                        if (cb != null) {
                            logger.info((Object)String.format("---root %s(%s), Start caching results", root.getClass().getSimpleName(), root.getId()));
                            cb.finish(root);
                        }
                    }
                    finally {
                        filterCache.set(null);
                    }
                }
            });
        }
    }

    public void runTask(String name, final Runnable runnable) {
        final IFilterNode[] filters = filterCache.get();
        this.env.createRunner().runTask(name, new Runnable(){

            @Override
            public void run() {
                filterCache.set(filters);
                runnable.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRunning() {
        HashSet<String> hashSet = this.unFinishedRoots;
        synchronized (hashSet) {
            return !this.unFinishedRoots.isEmpty();
        }
    }

    private HashMap<String, Throwable> statErrors(ICalculator factor) {
        ICalculator[] params;
        HashMap<String, Throwable> errors = new HashMap<String, Throwable>();
        if (factor.isRunning()) {
            return errors;
        }
        Throwable e = factor.getFailCause();
        if (e != null) {
            errors.put(factor.getId(), e);
        }
        if ((params = factor.getParams()) == null) {
            return errors;
        }
        for (ICalculator p : params) {
            errors.putAll(this.statErrors(p));
        }
        return errors;
    }

    public IFilterNode[] getFilters(ICalculator node) {
        IFilterNode[] filters = filterCache.get();
        return filters;
    }

    public static interface IRootNodeFinishCallback {
        public void finish(ICalculator var1);
    }
}

