/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.INodeStatusAware;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.IFilterable;
import kd.mmc.phm.mservice.model.calculator.impl.Const;
import kd.mmc.phm.mservice.model.calculator.impl.group.Group;
import kd.mmc.phm.mservice.model.enums.VType;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.filter.IFilterNode;
import org.apache.log4j.Logger;

public abstract class AbstractCalculator
implements ICalculator {
    protected static Logger logger = Logger.getLogger((String)"phm");
    protected Serializable result;
    protected String eventId;
    protected VType vt;
    protected Throwable e;
    protected String id;
    protected ICalculator[] params;
    protected List<ICalculator> waitingParents = new ArrayList<ICalculator>();
    protected volatile boolean isRunning = false;
    private String runningId;

    protected AbstractCalculator(String id) {
        this.id = id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Serializable getLatestResult(CalcEnv env) {
        if (!(this instanceof IFilterable)) {
            return this.result;
        }
        IFilterNode[] filters = env.getFilters(this);
        if (filters == null || filters.length == 0) {
            return this.result;
        }
        IFilterable node = (IFilterable)((Object)this);
        IFilterable.VALUES.set(this.result);
        for (IFilterNode filter : filters) {
            CompareSetting[] settings;
            if (Objects.isNull(filter.getValue())) continue;
            for (CompareSetting setting : settings = filter.getApplySettings()) {
                if (!setting.getTargetNodeId().equals(this.getId())) continue;
                node.applyFilter(filter, setting);
            }
        }
        try {
            Serializable serializable = IFilterable.VALUES.get();
            return serializable;
        }
        finally {
            IFilterable.VALUES.set(null);
        }
    }

    @Override
    public final synchronized void calc(CalcEnv env) {
        if (env.getRunningId().equals(this.getRunningId())) {
            this.notifyWaitings();
            return;
        }
        INodeStatusAware notifier = env.getNodeAware();
        long start = -1L;
        try {
            this.isRunning = true;
            this.setRunningId(env.getRunningId());
            notifier.onPrepare(this);
            if (this.params != null) {
                this.checkParams(env);
            }
            start = System.nanoTime();
            logger.info((Object)String.format("---calc %s(%s) begin---", this.getClass().getSimpleName(), this.id));
            if (this instanceof Group) {
                if (this.params == null || this.params.length == 0) {
                    this.params = new ICalculator[1];
                    this.params[0] = new Const(this.id + "_1", (Serializable)((Object)"0"));
                }
                if (this.params.length > 1) {
                    ICalculator calculator_1 = this.params[0];
                    ICalculator[] newParams = new ICalculator[]{Objects.nonNull(calculator_1) ? calculator_1 : new Const(this.id + "_1", (Serializable)((Object)"0"))};
                    this.params = newParams;
                }
            } else {
                ICalculator[] newParams;
                if (this.params == null || this.params.length == 0) {
                    this.params = new ICalculator[2];
                    this.params[0] = new Const(this.id + "_1", (Serializable)((Object)"0"));
                    this.params[1] = new Const(this.id + "_2", (Serializable)((Object)"0"));
                }
                if (this.params.length == 1) {
                    ICalculator calculator_1 = this.params[0];
                    newParams = new ICalculator[]{Objects.nonNull(calculator_1) ? calculator_1 : new Const(this.id + "_1", (Serializable)((Object)"0")), new Const(this.id + "_2", (Serializable)((Object)"0"))};
                    this.params = newParams;
                }
                if (this.params.length != 2) {
                    newParams = new ICalculator[2];
                    for (int i = 0; i < this.params.length; ++i) {
                        newParams[i] = Objects.nonNull(this.params[i]) ? this.params[i] : new Const(this.id + "_" + (i + 1), (Serializable)((Object)"0"));
                    }
                    this.params = newParams;
                }
            }
            this.validateParams(this.params);
            notifier.onStart(this);
            this.calc(env, this.params);
            notifier.onFinish(this);
        }
        catch (Throwable e) {
            try {
                this.e = e;
                this.vt = VType.ERROR;
                this.result = "ERROR";
                notifier.onFail(this, e);
                logger.error((Object)String.format("---failed to execute node(%s)---", this.getClass().getSimpleName()), e);
                throw new KDBizException(e, new ErrorCode("", "---failed to execute node(%s)---"), new Object[]{this.getClass().getSimpleName()});
            }
            catch (Throwable throwable) {
                start = System.nanoTime() - start;
                logger.info((Object)String.format("---calc %s(%s) finished, ts: %s(ns), vt: %s", new Object[]{this.getClass().getSimpleName(), this.id, start, this.vt}));
                this.notifyWaitings();
                throw throwable;
            }
        }
        start = System.nanoTime() - start;
        logger.info((Object)String.format("---calc %s(%s) finished, ts: %s(ns), vt: %s", new Object[]{this.getClass().getSimpleName(), this.id, start, this.vt}));
        this.notifyWaitings();
    }

    @Override
    public void filter(CalcEnv env) {
        if (this.params != null) {
            for (ICalculator param : this.params) {
                param.filter(env);
            }
        }
        if (!(this instanceof IFilterable)) {
            this.calc(env, this.params);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyWaitings() {
        this.isRunning = false;
        if (this.waitingParents.isEmpty()) {
            return;
        }
        List<ICalculator> list = this.waitingParents;
        synchronized (list) {
            this.waitingParents.forEach(parent -> {
                ICalculator iCalculator = parent;
                synchronized (iCalculator) {
                    parent.notify();
                }
            });
            this.waitingParents.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkParams(CalcEnv env) {
        if (this.params.length == 0) {
            return;
        }
        for (int i = 0; i < this.params.length; ++i) {
            this.resolveParam(this.params[i], env);
        }
        AbstractCalculator abstractCalculator = this;
        synchronized (abstractCalculator) {
            while (true) {
                boolean isPrepared = true;
                for (int i = 0; i < this.params.length; ++i) {
                    if (this.params[i] == null) continue;
                    if (this.params[i].isRunning()) {
                        isPrepared = false;
                    }
                    if (!isPrepared) break;
                }
                if (isPrepared) break;
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new KDBizException((Throwable)e, new ErrorCode("", "%s node(%s) has been interupted."), new Object[]{this.getClass().getSimpleName(), this.getId()});
                }
            }
        }
    }

    protected void resolveParam(final ICalculator param, final CalcEnv env) {
        if (param == null) {
            return;
        }
        param.addWaitingParents(this);
        if (env.getRunningId().equals(param.getRunningId())) {
            return;
        }
        String taskName = String.format("%s node(%s) - mmc", param.getClass().getSimpleName(), param.getId());
        param.setRunning();
        env.runTask(taskName, new Runnable(){

            @Override
            public void run() {
                param.calc(env);
            }
        });
    }

    @Override
    public void setRunning() {
        this.isRunning = true;
    }

    @Override
    public boolean isRunning() {
        return this.isRunning;
    }

    @Override
    public VType getVType() {
        return this.vt;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setRunningId(String runningId) {
        this.runningId = runningId;
    }

    @Override
    public String getRunningId() {
        return this.runningId;
    }

    @Override
    public void setParams(ICalculator ... params) {
        this.params = params;
    }

    @Override
    public ICalculator[] getParams() {
        return this.params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addWaitingParents(ICalculator parent) {
        List<ICalculator> list = this.waitingParents;
        synchronized (list) {
            this.waitingParents.add(parent);
        }
    }

    @Override
    public Throwable getFailCause() {
        return this.e;
    }

    protected abstract void calc(CalcEnv var1, ICalculator ... var2);

    protected abstract void validateParams(ICalculator ... var1);
}

