/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import java.io.Serializable;
import java.util.HashMap;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.calculator.impl.IGroupRowsResolver;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.enums.VType;

public abstract class AbstractGroupRowsResolver
extends AbstractCalculator
implements IGroupRowsResolver {
    protected String[] cols;

    protected AbstractGroupRowsResolver(String id) {
        super(id);
        this.vt = VType.DBROWS;
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        if (this.cols == null) {
            Serializable[] datas = new Serializable[params.length];
            int len = params.length;
            for (int i = 0; i < len; ++i) {
                datas[i] = params[i].getLatestResult(env);
                if (datas[i] instanceof Number) continue;
                datas[i] = Integer.valueOf(0);
            }
            this.result = this.resolve(datas);
        } else {
            ICalculator db = params[0];
            HashMap<String, IGroupRowsResolver> resolvers = new HashMap<String, IGroupRowsResolver>();
            for (String col : this.cols) {
                resolvers.put(col, this);
            }
            this.result = ((DBRows)db.getLatestResult(env)).executeGroupFunction(resolvers);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length == 0) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs at least 1 param.", this.getClass().getSimpleName())});
        }
    }
}

