/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import com.google.common.collect.Maps;
import java.io.Serializable;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.IDynamicColumnAware;
import kd.mmc.phm.mservice.model.calculator.IFilterable;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.VType;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.filter.IFilterNode;
import kd.mmc.phm.mservice.model.fomula.Expr;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.model.fomula.ParseException;

public class DBAccess
extends AbstractCalculator
implements IFilterable,
IDynamicColumnAware {
    private String dbSQL;
    private String demoDataName;
    private DBRoute dbRoute;
    private ArrayList<Object[]> expressions = new ArrayList();
    private String tableName;
    private String tableAlias;
    private final Set<String> cols = new HashSet<String>(16);
    private final Set<String> notOutputFields = new HashSet<String>(16);
    private final Map<String, String> alias2Name = new HashMap<String, String>(16);

    public DBAccess(String id, DBRoute dbRoute, String dbSQL) {
        super(id);
        this.dbRoute = dbRoute;
        this.dbSQL = dbSQL;
        this.vt = VType.DBROWS;
    }

    public DBAccess(String id, String demoDataName) {
        super(id);
        this.demoDataName = demoDataName;
        this.vt = VType.DBROWS;
    }

    public DBAccess(String id, DBRoute dbRoute, String tableName, String tableAlias, String[] fields) {
        super(id);
        this.dbRoute = dbRoute;
        this.vt = VType.DBROWS;
        this.tableName = tableName;
        this.tableAlias = tableAlias;
        for (String field : fields) {
            this.cols.add(field.toUpperCase());
        }
    }

    public void appendCol(String col) {
        String[] split;
        if (this.cols.add(col = col.toUpperCase()) && (split = col.split(" AS ")).length == 2) {
            this.notOutputFields.add(split[1]);
        }
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        if (StringUtils.isNotEmpty((String)this.demoDataName)) {
            this.result = DBRows.buildDemoDBRows(this.demoDataName);
        } else {
            if (StringUtils.isEmpty((String)this.dbSQL)) {
                StringBuilder sql = new StringBuilder("SELECT ");
                for (String col : this.cols) {
                    String[] split = col.split(" AS ");
                    if (split.length == 2) {
                        this.alias2Name.put(split[1].toUpperCase(), split[0].split("\\.")[1].toUpperCase());
                    }
                    sql.append(col).append(", ");
                }
                sql.delete(sql.length() - 2, sql.length() - 1);
                sql.append(" FROM ");
                sql.append(this.tableName).append(" AS ").append(this.tableAlias).append("\r\n");
                this.dbSQL = sql.toString();
            }
            this.result = (Serializable)DB.query((DBRoute)this.dbRoute, (String)this.dbSQL, rs -> {
                int i;
                ResultSetMetaData rsmd = rs.getMetaData();
                String[] colLabels = new String[rsmd.getColumnCount() + this.expressions.size()];
                HashMap<String, VType> colTypes = new HashMap<String, VType>(16);
                HashMap<String, Integer> labelIndex = new HashMap<String, Integer>();
                for (i = 1; i <= rsmd.getColumnCount(); ++i) {
                    String columnName;
                    colLabels[i - 1] = columnName = rsmd.getColumnName(i).toUpperCase();
                    labelIndex.put(columnName, i - 1);
                    VType vType = VType.fromValue(rsmd.getColumnType(i));
                    if (vType == VType.DECIMAL) {
                        vType = rsmd.getScale(i) == 0 ? VType.BIGINT : vType;
                    }
                    colTypes.put(columnName, vType);
                }
                int colCount = rsmd.getColumnCount();
                for (i = 0; i < this.expressions.size(); ++i) {
                    Object[] expression = this.expressions.get(i);
                    String columnName = null;
                    if (expression != null && expression.length > 0) {
                        columnName = expression[0].toString();
                    }
                    colLabels[colCount + i] = columnName;
                    labelIndex.put(columnName, colCount + i);
                    colTypes.put(columnName, VType.STRING);
                }
                Matrix m = new Matrix();
                int rowIdx = 0;
                while (rs.next()) {
                    for (int i2 = 0; i2 < rsmd.getColumnCount(); ++i2) {
                        m.setCell(rowIdx, i2, (Serializable)rs.getObject(i2 + 1));
                    }
                    ExprContext ctx = new ExprContext();
                    LinkedHashMap newColLabelMap = Maps.newLinkedHashMapWithExpectedSize((int)labelIndex.size());
                    for (Map.Entry entry : labelIndex.entrySet()) {
                        String fieldName = this.alias2Name.get(entry.getKey());
                        if (fieldName == null) {
                            fieldName = (String)entry.getKey();
                        }
                        newColLabelMap.put(fieldName, entry.getValue());
                    }
                    ctx.addPreDefinedParam("colLabels", newColLabelMap);
                    ctx.addPreDefinedParam("colTypes", colTypes);
                    ctx.addPreDefinedParam("values", m.getRow(rowIdx));
                    int colCount2 = rsmd.getColumnCount();
                    for (int i3 = 0; i3 < this.expressions.size(); ++i3) {
                        Object[] expression = this.expressions.get(i3);
                        Expr expr = null;
                        if (expression != null && expression.length > 1) {
                            expr = (Expr)expression[1];
                        }
                        if (expr == null) continue;
                        m.setCell(rowIdx, colCount2 + i3, (Serializable)expr.execute(ctx));
                    }
                    ++rowIdx;
                }
                DBRows rows = new DBRows(m, colLabels);
                rows.setColTypes(colTypes);
                rows.setNotOutputFields(Collections.unmodifiableSet(this.notOutputFields));
                rows.setAlias2Name(Collections.unmodifiableMap(this.alias2Name));
                return rows;
            });
        }
    }

    @Override
    public void applyFilter(IFilterNode filter, CompareSetting setting) {
        DBRows all = (DBRows)VALUES.get();
        VALUES.set(all.filter(filter.getValue(), setting));
    }

    @Override
    protected void validateParams(ICalculator ... params) {
    }

    public String getSQL() {
        return this.dbSQL == null ? this.demoDataName : this.dbSQL;
    }

    @Override
    public void addCalcColumn(String colId, String expression) {
        Expr expr;
        try {
            expr = new Expr(expression);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Object expr2 = null;
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6784\u9020\u8282\u70b9\u5931\u8d25\uff1a%s , %s", (String)"DBAccess_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{colId, expression});
        }
        this.expressions.add(new Object[]{colId, expr});
    }
}

