/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.common.util.CalculationUtils;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.VType;

public class Division
extends AbstractCalculator {
    public Division(String id) {
        super(id);
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        this.vt = params[0].getVType();
        this.result = params[0].getLatestResult(env);
        for (int i = 1; i < params.length; ++i) {
            Serializable right = params[i].getLatestResult(env);
            if (Objects.isNull(right)) {
                String msg = String.format(ResManager.loadKDString((String)"\u9664\u6cd5\u9519\u8bef\u53c2\u6570\u4fe1\u606f\uff1a%s", (String)"Division_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), JSONObject.toJSON((Object)params).toString());
                throw new KDBizException(new ErrorCode("NullPointerException", msg), new Object[0]);
            }
            VType rightVT = params[i].getVType();
            if (rightVT == VType.DECIMAL) {
                this.matrixDivide((Number)right);
                continue;
            }
            if (rightVT != VType.DBROWS) continue;
            this.matrixDivide((DBRows)right);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length == 0) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 1 param.", this.getClass().getSimpleName())});
        }
    }

    private void matrixDivide(Number num) {
        if (this.vt == VType.DBROWS) {
            Matrix m = ((DBRows)this.result).getDatas();
            if (m.isEmpty()) {
                return;
            }
            Matrix r = new Matrix();
            int[] shape = m.getShape();
            int index0 = 0;
            int index1 = 1;
            for (int i = 0; i < shape[index0]; ++i) {
                for (int j = 0; j < shape[index1]; ++j) {
                    String mCell;
                    String string = mCell = Objects.isNull(m.getCell(i, j)) ? "" : m.getCell(i, j).toString();
                    if (CalculationUtils.isNumeric((String)mCell)) {
                        BigDecimal mBigDecimal = BigDecimal.valueOf(Double.parseDouble(mCell));
                        BigDecimal mfBigDecimal = new BigDecimal(num.toString());
                        r.setCell(i, j, mBigDecimal.divide(mfBigDecimal));
                        continue;
                    }
                    r.setCell(i, j, Integer.valueOf(0));
                }
            }
            this.result = new DBRows(r, ((DBRows)this.result).getSortedColLabels()).setColTypes(((DBRows)this.result).getColTypes());
        } else if (this.vt == VType.DECIMAL) {
            this.result = Double.valueOf(((Number)this.result).doubleValue() / num.doubleValue());
        }
    }

    private void matrixDivide(DBRows rows) {
        Objects.requireNonNull(rows);
        Matrix m = rows.getDatas();
        if (m.isEmpty()) {
            return;
        }
        Matrix r = new Matrix();
        int index0 = 0;
        int index1 = 1;
        if (this.vt == VType.DBROWS) {
            int[] shape0 = m.getShape();
            Matrix mf = ((DBRows)this.result).getDatas();
            int[] shape1 = mf.getShape();
            int rc = Math.min(shape0[index0], shape1[index0]);
            int cc = Math.min(shape0[index1], shape1[index1]);
            String[] newLabels = new String[cc];
            System.arraycopy(((DBRows)this.result).getSortedColLabels(), 0, newLabels, 0, cc);
            for (int i = 0; i < rc; ++i) {
                for (int j = 0; j < cc; ++j) {
                    String mfCell;
                    String mCell = Objects.isNull(m.getCell(i, j)) ? "" : m.getCell(i, j).toString();
                    String string = mfCell = Objects.isNull(mf.getCell(i, j)) ? "" : mf.getCell(i, j).toString();
                    if (CalculationUtils.isNumeric((String)mCell) && CalculationUtils.isNumeric((String)mfCell)) {
                        BigDecimal mBigDecimal = BigDecimal.valueOf(Double.parseDouble(mCell));
                        BigDecimal mfBigDecimal = BigDecimal.valueOf(Double.parseDouble(mfCell));
                        BigDecimal cellVal = mfBigDecimal.divide(mBigDecimal);
                        r.setCell(i, j, cellVal);
                        continue;
                    }
                    r.setCell(i, j, Integer.valueOf(0));
                }
            }
            this.result = new DBRows(r, newLabels).setColTypes(((DBRows)this.result).getColTypes());
        } else if (this.vt == VType.DECIMAL) {
            int[] shape = m.getShape();
            for (int i = 0; i < shape[index0]; ++i) {
                for (int j = 0; j < shape[index1]; ++j) {
                    try {
                        r.setCell(i, j, Double.valueOf(((Number)m.getCell(i, j)).doubleValue() / ((Number)this.result).doubleValue()));
                        continue;
                    }
                    catch (Throwable e) {
                        r.setCell(i, j, Integer.valueOf(0));
                    }
                }
            }
            this.vt = VType.DBROWS;
            this.result = new DBRows(r, rows.getSortedColLabels()).setColTypes(rows.getColTypes());
        }
    }
}

