/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.VType;

public class ExtractRoot
extends AbstractCalculator {
    private DecimalFormat format;

    public ExtractRoot(String id) {
        this(id, 4);
    }

    public ExtractRoot(String id, int precise) {
        super(id);
        StringBuilder sb = new StringBuilder("######");
        if (precise > 0) {
            sb.append('.');
            for (int i = 0; i < precise; ++i) {
                sb.append('#');
            }
        }
        this.format = new DecimalFormat();
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        int index0 = 0;
        int index1 = 1;
        this.vt = params[index0].getVType();
        Serializable result = params[index0].getLatestResult(env);
        double p = ((Number)params[index1].getLatestResult(env)).doubleValue();
        if (this.vt == VType.DECIMAL) {
            double base = ((Number)result).doubleValue();
            this.result = new BigDecimal(this.format.format(StrictMath.pow(10.0, StrictMath.log10(base) / p)));
        } else if (this.vt == VType.DBROWS) {
            Matrix src = ((DBRows)result).getDatas();
            this.matrixET(src, p);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length != 2) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 2 params.", this.getClass().getSimpleName())});
        }
    }

    private void matrixET(Matrix src, double p) {
        Matrix m = new Matrix();
        int[] shape = src.getShape();
        int index0 = 0;
        int index1 = 1;
        for (int rowIdx = 0; rowIdx < shape[index0]; ++rowIdx) {
            for (int colIdx = 0; colIdx < shape[index1]; ++colIdx) {
                Serializable cllVal = src.getCell(rowIdx, colIdx);
                if (!(cllVal instanceof Number)) continue;
                Number base = (Number)cllVal;
                double b = base.doubleValue();
                cllVal = Double.valueOf(StrictMath.pow(10.0, StrictMath.log10(b) / p));
                m.setCell(rowIdx, colIdx, cllVal);
            }
        }
        this.result = new DBRows(m, ((DBRows)this.result).getSortedColLabels()).setColTypes(((DBRows)this.result).getColTypes());
    }
}

