/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.mservice.framework.mq.IMQProvider;
import kd.mmc.phm.mservice.framework.mq.event.MQEvent;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.VType;

public class IntegrateCalculator
extends AbstractCalculator {
    private String targetConsumerQueueId;
    private SimpleDateFormat date_fmt = new SimpleDateFormat("yyyy-MM-dd");
    private SimpleDateFormat datetime_fmt = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
    private SimpleDateFormat time_fmt = new SimpleDateFormat("hh:mm:ss");

    public IntegrateCalculator(String id, String targetConsumerQueueId) {
        super(id);
        this.targetConsumerQueueId = targetConsumerQueueId;
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        IMQProvider pro = env.getProvider().createMQProvider();
        MQEvent event = new MQEvent(env.getRunningId(), this.getId());
        event.setTargetQueueId(this.targetConsumerQueueId);
        pro.publishCalcEvent(this.getId(), event);
        pro.wait4Response(this.getId());
        String json = env.getProvider().createCacheProvider().getData(event.getEventId());
        JSONObject jObj = JSON.parseObject((String)json);
        this.vt = VType.valueOf(jObj.getString("vt"));
        switch (this.vt) {
            case DATE: {
                this.parse(this.date_fmt, jObj.getString("cnt"));
                break;
            }
            case DATETIME: {
                this.parse(this.datetime_fmt, jObj.getString("cnt"));
                break;
            }
            case TIME: {
                this.parse(this.time_fmt, jObj.getString("cnt"));
                break;
            }
            case DECIMAL: {
                this.result = new BigDecimal(jObj.getString("cnt"));
                break;
            }
            case STRING: {
                this.result = jObj.getString("cnt");
                break;
            }
            case ERROR: {
                this.result = "ERROR";
                break;
            }
            case DBROWS: {
                JSONArray cols = jObj.getJSONArray("cols");
                String[] sortedColLabels = new String[cols.size()];
                for (int i = 0; i < cols.size(); ++i) {
                    sortedColLabels[i] = cols.getString(i);
                }
                JSONArray rows = jObj.getJSONArray("rows");
                JSONArray colTypes = jObj.getJSONArray("colTypes");
                this.result = new DBRows(this.buildMatrix(rows, colTypes), sortedColLabels);
                break;
            }
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
    }

    private void parse(SimpleDateFormat fmt, String cnt) {
        try {
            this.result = fmt.parse(cnt);
        }
        catch (ParseException e) {
            this.vt = VType.ERROR;
            this.result = "ERROR";
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u65e5\u671f\u8f6c\u6362\u5931\u8d25\uff1a%s", (String)"IntegrateCalculator_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{cnt});
        }
    }

    private Matrix buildMatrix(JSONArray rows, JSONArray colTypes) {
        Matrix m = new Matrix();
        VType[] types = new VType[colTypes.size()];
        for (int i = 0; i < colTypes.size(); ++i) {
            types[i] = VType.valueOf(colTypes.getString(i));
        }
        for (int rowIdx = 0; rowIdx < rows.size(); ++rowIdx) {
            JSONArray row = rows.getJSONArray(rowIdx);
            for (int colIdx = 0; colIdx < colTypes.size(); ++colIdx) {
                Object cellVal;
                switch (types[colIdx]) {
                    case DECIMAL: {
                        cellVal = row.getBigDecimal(colIdx);
                        break;
                    }
                    case DATE: 
                    case DATETIME: {
                        cellVal = row.getDate(colIdx);
                        break;
                    }
                    case TIME: {
                        try {
                            cellVal = this.time_fmt.parse(row.getString(colIdx));
                            break;
                        }
                        catch (ParseException e) {
                            cellVal = null;
                            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u8f6c\u6362\u5f02\u5e38\uff1a%s", (String)"IntegrateCalculator_1", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{e.getMessage()});
                        }
                    }
                    default: {
                        cellVal = row.getString(colIdx);
                    }
                }
                m.setCell(rowIdx, colIdx, (Serializable)cellVal);
            }
        }
        return m;
    }
}

