/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.VType;

public class Logarithm
extends AbstractCalculator {
    public Logarithm(String id) {
        super(id);
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        int index0 = 0;
        int index1 = 1;
        this.vt = params[index0].getVType();
        this.result = params[index0].getLatestResult(env);
        double p = ((Number)params[index1].getLatestResult(env)).doubleValue();
        if (this.vt == VType.DECIMAL) {
            double base = ((Number)this.result).doubleValue();
            this.result = Double.valueOf(Math.log(p) / Math.log(base));
        } else if (this.vt == VType.DBROWS) {
            Matrix src = ((DBRows)this.result).getDatas();
            this.matrixLog(src, p);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length != 2) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 2 params.", this.getClass().getSimpleName())});
        }
    }

    private void matrixLog(Matrix src, double p) {
        Matrix m = new Matrix(false);
        int[] shape = src.getShape();
        int index0 = 0;
        int index1 = 1;
        for (int rowIdx = 0; rowIdx < shape[index0]; ++rowIdx) {
            for (int colIdx = 0; colIdx < shape[index1]; ++colIdx) {
                Number base = (Number)src.getCell(rowIdx, colIdx);
                if (base == null) continue;
                double b = base.doubleValue();
                m.setCell(rowIdx, colIdx, Double.valueOf(Math.log(p) / Math.log(b)));
            }
        }
        this.result = new DBRows(m, ((DBRows)this.result).getSortedColLabels()).setColTypes(((DBRows)this.result).getColTypes());
    }
}

