/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.common.util.CalculationUtils;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.VType;

public class Multiply
extends AbstractCalculator {
    public Multiply(String id) {
        super(id);
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        this.vt = params[0].getVType();
        this.result = params[0].getLatestResult(env);
        for (int i = 1; i < params.length; ++i) {
            Serializable right = params[i].getLatestResult(env);
            VType rightVT = params[i].getVType();
            if (rightVT == VType.DECIMAL) {
                this.matrixMultiply((Number)right);
                continue;
            }
            if (rightVT != VType.DBROWS) continue;
            this.matrixMultiply((DBRows)right);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length == 0) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 2 params.", this.getClass().getSimpleName())});
        }
    }

    private void matrixMultiply(Number num) {
        if (this.vt == VType.DBROWS) {
            Matrix m = ((DBRows)this.result).getDatas();
            if (m.isEmpty()) {
                return;
            }
            Matrix r = new Matrix();
            int[] shape = m.getShape();
            int index0 = 0;
            int index1 = 1;
            for (int i = 0; i < shape[index0]; ++i) {
                for (int j = 0; j < shape[index1]; ++j) {
                    Serializable cv = m.getCell(i, j);
                    if (cv == null) {
                        cv = Integer.valueOf(0);
                    } else if (!(cv instanceof Number)) {
                        r.setCell(i, j, (Serializable)((Object)"op failed."));
                        return;
                    }
                    r.setCell(i, j, Double.valueOf(num.doubleValue() * ((Number)cv).doubleValue()));
                }
            }
            this.result = new DBRows(r, ((DBRows)this.result).getSortedColLabels()).setColTypes(((DBRows)this.result).getColTypes());
        } else if (this.vt == VType.DECIMAL) {
            this.result = Double.valueOf(num.doubleValue() * ((Number)this.result).doubleValue());
        }
    }

    private void matrixMultiply(DBRows rows) {
        Matrix m = rows.getDatas();
        if (m.isEmpty()) {
            return;
        }
        Matrix r = new Matrix(false);
        int index0 = 0;
        int index1 = 1;
        if (this.vt == VType.DBROWS) {
            int[] shape0 = m.getShape();
            Matrix mf = ((DBRows)this.result).getDatas();
            int[] shape1 = mf.getShape();
            int rc = Math.min(shape0[index0], shape1[index0]);
            int cc = Math.min(shape0[index1], shape1[index1]);
            String[] newLabels = new String[cc];
            System.arraycopy(((DBRows)this.result).getSortedColLabels(), 0, newLabels, 0, cc);
            for (int i = 0; i < rc; ++i) {
                for (int j = 0; j < cc; ++j) {
                    String mfCell;
                    String mCell = Objects.isNull(m.getCell(i, j)) ? "" : m.getCell(i, j).toString();
                    String string = mfCell = Objects.isNull(mf.getCell(i, j)) ? "" : mf.getCell(i, j).toString();
                    if (CalculationUtils.isNumeric((String)mCell) && CalculationUtils.isNumeric((String)mfCell)) {
                        BigDecimal mBigDecimal = BigDecimal.valueOf(Double.parseDouble(mCell));
                        BigDecimal mfBigDecimal = BigDecimal.valueOf(Double.parseDouble(mfCell));
                        BigDecimal cellVal = mBigDecimal.multiply(mfBigDecimal);
                        r.setCell(i, j, cellVal);
                        continue;
                    }
                    r.setCell(i, j, (Serializable)((Object)(mCell + "*" + mfCell)));
                }
            }
            this.result = new DBRows(r, newLabels).setColTypes(((DBRows)this.result).getColTypes());
        } else if (this.vt == VType.DECIMAL) {
            int[] shape = m.getShape();
            for (int i = 0; i < shape[index0]; ++i) {
                for (int j = 0; j < shape[index1]; ++j) {
                    String mfCell;
                    String mCell = Objects.isNull(this.result) ? "" : this.result.toString();
                    String string = mfCell = Objects.isNull(r.getCell(i, j)) ? "" : r.getCell(i, j).toString();
                    if (CalculationUtils.isNumeric((String)mCell) && CalculationUtils.isNumeric((String)mfCell)) {
                        BigDecimal mBigDecimal = BigDecimal.valueOf(Double.parseDouble(mCell));
                        BigDecimal mfBigDecimal = BigDecimal.valueOf(Double.parseDouble(mfCell));
                        BigDecimal cellVal = mBigDecimal.multiply(mfBigDecimal);
                        r.setCell(i, j, cellVal);
                        continue;
                    }
                    r.setCell(i, j, (Serializable)((Object)(mCell + "*" + mfCell)));
                }
            }
            this.vt = VType.DBROWS;
            this.result = new DBRows(r, rows.getSortedColLabels()).setColTypes(rows.getColTypes());
        }
    }
}

