/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl.group;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.calculator.impl.IGroupRowsResolver;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.enums.VType;

public class Group
extends AbstractCalculator {
    private HashSet<String> groupCols;
    private HashMap<String, IGroupRowsResolver> agregateCols;

    public Group(String id, HashMap<String, IGroupRowsResolver> agregateCols, String ... groupCols) {
        super(id);
        this.vt = VType.DBROWS;
        this.agregateCols = agregateCols;
        this.groupCols = new HashSet();
        for (String col : groupCols) {
            this.groupCols.add(col);
        }
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        if (params == null || params.length == 0) {
            return;
        }
        ICalculator db = params[0];
        if (db.getVType() != VType.DBROWS) {
            return;
        }
        DBRows rows = (DBRows)db.getLatestResult(env);
        if (Objects.nonNull(rows)) {
            rows = rows.group(this.groupCols);
            this.result = rows.executeGroupFunction(this.agregateCols);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length != 1) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 1 param.", this.getClass().getSimpleName())});
        }
    }
}

