/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl.join;

import java.util.ArrayList;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.IDynamicColumnAware;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.enums.VType;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.fomula.Expr;
import kd.mmc.phm.mservice.model.fomula.ParseException;

public abstract class AbstractJoinCalculator
extends AbstractCalculator
implements IDynamicColumnAware {
    protected CompareSetting[] settings;
    protected String maskString;
    protected ArrayList<Object[]> expressions = new ArrayList();

    protected AbstractJoinCalculator(String id, String maskString, CompareSetting ... settings) {
        super(id);
        this.vt = VType.DBROWS;
        this.maskString = maskString;
        this.settings = settings;
        if (settings == null) {
            throw new KDBizException(SysConsts.Errors.EMPTY_COMPARESETTING, new Object[0]);
        }
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length != 2) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 2 params.", this.getClass().getSimpleName())});
        }
    }

    @Override
    public void addCalcColumn(String colId, String expression) {
        Expr expr;
        try {
            expr = new Expr(expression);
        }
        catch (ParseException e) {
            e.printStackTrace();
            Object expr2 = null;
            throw new KDBizException((Throwable)e, new ErrorCode("", ResManager.loadKDString((String)"\u6784\u9020\u8282\u70b9\u5931\u8d25\uff1a%s", (String)"AbstractJoinCalculator_0", (String)"mmc-phm-mservice", (Object[])new Object[0])), new Object[]{colId, expression});
        }
        this.expressions.add(new Object[]{colId, expr});
    }
}

