/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl.select;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;
import kd.mmc.phm.mservice.model.enums.VType;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.fomula.Expr;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.model.fomula.ParseException;

public class RowSelect
extends AbstractCalculator {
    private CompareSetting[] settings;
    private String maskString;

    public RowSelect(String id, CompareSetting ... settings) {
        this(id, (String)null, settings);
    }

    public RowSelect(String id, String maskString, CompareSetting ... settings) {
        super(id);
        this.maskString = maskString;
        this.settings = settings;
        this.vt = VType.DBROWS;
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        Expr expr;
        if (params[0].getVType() != VType.DBROWS) {
            return;
        }
        DBRows rows = (DBRows)params[0].getLatestResult(env);
        try {
            expr = new Expr(this.maskString);
        }
        catch (ParseException e) {
            throw new KDBizException(new ErrorCode("FAILED_TO_PARSE_FILTER", this.maskString), new Object[0]);
        }
        ExprContext ctx = new ExprContext();
        HashMap<String, Integer> colLabels = new HashMap<String, Integer>();
        ArrayList<DBRows> colValues = new ArrayList<DBRows>();
        for (int i = 0; i < this.settings.length; ++i) {
            CompareSetting setting = this.settings[i];
            DBRows result = rows.filter(setting.getValue(), setting);
            colLabels.put(String.valueOf("row" + i).toUpperCase(), i);
            colValues.add(result);
        }
        ctx.addPreDefinedParam("colLabels", colLabels);
        ctx.addPreDefinedParam("values", colValues.toArray(new Serializable[0]));
        rows = (DBRows)expr.execute(ctx);
        rows.refreshStatistics();
        this.result = rows;
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length == 0) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 1 param.", this.getClass().getSimpleName())});
        }
    }
}

