/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.calculator.impl.sort;

import java.util.ArrayList;
import kd.bos.exception.KDBizException;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.CalcEnv;
import kd.mmc.phm.mservice.model.KV;
import kd.mmc.phm.mservice.model.calculator.ICalculator;
import kd.mmc.phm.mservice.model.calculator.impl.AbstractCalculator;
import kd.mmc.phm.mservice.model.data.DBRows;

public class Sort
extends AbstractCalculator {
    private ArrayList<KV<String, Boolean>> cols;

    public Sort(String id, ArrayList<KV<String, Boolean>> cols) {
        super(id);
        this.cols = cols;
    }

    @Override
    protected void calc(CalcEnv env, ICalculator ... params) {
        this.result = params[0].getLatestResult(env);
        if (!(this.result instanceof DBRows)) {
            return;
        }
        DBRows rows = (DBRows)this.result;
        ArrayList<KV<Integer, Boolean>> indexs = new ArrayList<KV<Integer, Boolean>>();
        for (int i = 0; i < this.cols.size(); ++i) {
            int colIdx = rows.getColIdx((String)this.cols.get((int)i).key);
            indexs.add(new KV(colIdx, this.cols.get((int)i).value));
        }
        rows.getDatas().sortBy(indexs);
    }

    @Override
    protected void validateParams(ICalculator ... params) {
        if (params == null || params.length != 1) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("%s node needs 1 param.", this.getClass().getSimpleName())});
        }
        if (this.cols == null || this.cols.size() == 0) {
            throw new KDBizException(SysConsts.Errors.PARAMS_ERROR, new Object[]{String.format("empty sort columns for %s node.", this.getClass().getSimpleName())});
        }
    }
}

