/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.data;

import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.MapSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.fs.util.StringUtils;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.calculator.impl.IGroupRowsResolver;
import kd.mmc.phm.mservice.model.data.Matrix;
import kd.mmc.phm.mservice.model.enums.CompareOperator;
import kd.mmc.phm.mservice.model.enums.VType;
import kd.mmc.phm.mservice.model.filter.CompareSetting;
import kd.mmc.phm.mservice.model.fomula.Expr;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.utils.Utils;
import org.apache.log4j.Logger;

public class DBRows
implements Serializable {
    private static Logger logger = Logger.getLogger(DBRows.class);
    private static final long serialVersionUID = -1091706268633503566L;
    private Matrix datas;
    private HashMap<String, Integer> colLabels;
    private HashMap<String, VType> colTypes;
    private String[] sortedColLabels;
    private HashMap<String, HashSet<Integer>> groupSummarize;
    private HashSet<String> groupCols;
    private Set<String> notOutputFields = new HashSet<String>();
    private Map<String, String> alias2Name = new HashMap<String, String>(16);

    public DBRows(Matrix datas, String ... sortedColLabels) {
        this.datas = datas;
        if (sortedColLabels == null) {
            sortedColLabels = new String[]{};
        }
        this.sortedColLabels = sortedColLabels;
        this.colLabels = new HashMap();
        for (int i = 0; i < sortedColLabels.length; ++i) {
            this.colLabels.put(sortedColLabels[i], i);
        }
    }

    public DBRows setColTypes(HashMap<String, VType> colTypes) {
        this.colTypes = colTypes;
        return this;
    }

    public HashMap<String, VType> getColTypes() {
        return this.colTypes;
    }

    public VType getColType(String colLabel) {
        return this.colTypes.get(colLabel);
    }

    public String[] getSortedColLabels() {
        return this.sortedColLabels;
    }

    public void setNotOutputFields(Set<String> notOutputFields) {
        this.notOutputFields = notOutputFields;
    }

    public boolean isOutput(String fieldName) {
        return !this.notOutputFields.contains(fieldName);
    }

    public void setAlias2Name(Map<String, String> alias2Name) {
        this.alias2Name = alias2Name;
    }

    public Map<String, String> getAlias2Name() {
        return this.alias2Name;
    }

    public DBRows filter(Serializable compareVal, CompareSetting setting) {
        Integer colIdx = this.colLabels.get(setting.getCol().toUpperCase().trim());
        if (colIdx == null) {
            throw new KDBizException(new ErrorCode("EMPTY_COL_INDEX", String.format("column(%s) not found in table.", setting.getCol().trim())), new Object[0]);
        }
        CompareOperator op = setting.getOp();
        Matrix m = this.datas.filter(compareVal, colIdx, op);
        DBRows rows = new DBRows(m, this.sortedColLabels);
        rows.setColTypes(this.colTypes);
        rows.setAlias2Name(this.alias2Name);
        return rows;
    }

    public DBRows selectCols(String[] targetCols) {
        HashSet<String> _targetCols = new HashSet<String>();
        for (int i = 0; i < targetCols.length; ++i) {
            _targetCols.add(targetCols[i]);
        }
        Matrix m = new Matrix();
        int[] shape = this.datas.getShape();
        int indexI = 0;
        int indexJ = 1;
        for (int i = 0; i < shape[indexI]; ++i) {
            int colIdx = 0;
            for (int j = 0; j < shape[indexJ]; ++j) {
                if (!_targetCols.contains(this.sortedColLabels[j])) continue;
                m.setCell(i, colIdx++, this.datas.getCell(i, j));
            }
        }
        DBRows rows = new DBRows(m, targetCols);
        rows.setColTypes(this.colTypes);
        return rows;
    }

    public Matrix getDatas() {
        return this.datas;
    }

    public DBRows leftJoin(DBRows rows, ArrayList<Object[]> expressions, CompareSetting ... settings) {
        if (Objects.isNull(rows)) {
            String msg = String.format(ResManager.loadKDString((String)"DBRows \u5de6\u8fde\u63a5DBRows\u4e3a\u7a7a\uff0cDBRows\u5bf9\u8c61\u4fe1\u606f\uff1a%s", (String)"DBRows_0", (String)"mmc-phm-mservice", (Object[])new Object[0]), JSONObject.toJSON((Object)this).toString());
            throw new KDBizException(new ErrorCode("NullPointerException", msg), new Object[0]);
        }
        return DBRows.join(this, rows, expressions, new LRResolver(), settings);
    }

    public DBRows rightJoin(DBRows rows, ArrayList<Object[]> expressions, CompareSetting ... settings) {
        if (Objects.isNull(rows)) {
            String msg = String.format(ResManager.loadKDString((String)"DBRows \u53f3\u8fde\u63a5DBRows\u4e3a\u7a7a\uff0cDBRows\u5bf9\u8c61\u4fe1\u606f\uff1a%s", (String)"DBRows_1", (String)"mmc-phm-mservice", (Object[])new Object[0]), JSONObject.toJSON((Object)this).toString());
            throw new KDBizException(new ErrorCode("NullPointerException", msg), new Object[0]);
        }
        return DBRows.join(rows, this, expressions, new LRResolver(), settings);
    }

    public DBRows innerJoin(DBRows rows, ArrayList<Object[]> expressions, CompareSetting ... settings) {
        if (Objects.isNull(rows)) {
            String msg = String.format(ResManager.loadKDString((String)"DBRows \u5185\u8fde\u63a5DBRows\u4e3a\u7a7a\uff0cDBRows\u5bf9\u8c61\u4fe1\u606f\uff1a%s", (String)"DBRows_2", (String)"mmc-phm-mservice", (Object[])new Object[0]), JSONObject.toJSON((Object)this).toString());
            throw new KDBizException(new ErrorCode("NullPointerException", msg), new Object[0]);
        }
        return DBRows.join(this, rows, expressions, new InnerResolver(), settings);
    }

    private static DBRows join(DBRows left, DBRows right, ArrayList<Object[]> expressions, EmptyMatchRowResolver resolver, CompareSetting ... settings) {
        int i;
        HashMap<String, VType> right_colTypes;
        Objects.requireNonNull(left, ResManager.loadKDString((String)"DBRows left\u8fde\u63a5\u53c2\u6570\u4e3a\u7a7a", (String)"DBRows_3", (String)"mmc-phm-mservice", (Object[])new Object[0]));
        Objects.requireNonNull(right, ResManager.loadKDString((String)"DBRows right\u8fde\u63a5\u53c2\u6570\u4e3a\u7a7a", (String)"DBRows_4", (String)"mmc-phm-mservice", (Object[])new Object[0]));
        if (settings == null || settings.length == 0) {
            throw new KDBizException(SysConsts.Errors.EMPTY_TABLE_JOIN_CONDITIONS, new Object[0]);
        }
        int[] shape = left.datas.getShape();
        HashMap<Integer, HashSet<Integer>> relations = DBRows.calcTableRelations(shape[0], left, right, settings);
        Matrix m = new Matrix();
        int rowIdx = 0;
        int size = shape[0];
        String[] newLabels = DBRows.buildNewLables(left, right, expressions);
        DBRows ret = new DBRows(m, newLabels);
        ret.colTypes = new HashMap();
        HashMap<String, VType> left_colTypes = left.colTypes;
        if (Objects.nonNull(left_colTypes)) {
            ret.colTypes.putAll(left_colTypes);
        }
        if (Objects.nonNull(right_colTypes = right.colTypes)) {
            ret.colTypes.putAll(right_colTypes);
        }
        for (Object[] pair : expressions) {
            ret.colTypes.put(String.valueOf(pair[0]), VType.STRING);
        }
        ret.colTypes.entrySet().removeIf(entry -> !ret.colLabels.containsKey(entry.getKey()));
        HashMap<String, Integer> labelIndex = new HashMap<String, Integer>();
        for (i = 0; i < newLabels.length; ++i) {
            labelIndex.put(newLabels[i], i);
        }
        for (i = 0; i < size; ++i) {
            HashSet<Integer> targets = relations.get(i);
            if (targets == null || targets.isEmpty()) {
                if (!resolver.resolve(left, right, i, rowIdx, m)) continue;
                ++rowIdx;
                continue;
            }
            for (Integer tRowIdx : targets) {
                int outputColIdx = 0;
                for (int colIdx = 0; colIdx < left.sortedColLabels.length; ++colIdx) {
                    if (!left.isOutput(left.sortedColLabels[colIdx])) continue;
                    m.setCell(rowIdx, outputColIdx++, left.datas.getCell(i, colIdx));
                }
                for (int j = 0; j < right.sortedColLabels.length; ++j) {
                    if (!right.isOutput(right.sortedColLabels[j]) || left.colLabels.containsKey(right.sortedColLabels[j])) continue;
                    m.setCell(rowIdx, outputColIdx++, right.datas.getCell(tRowIdx, j));
                }
                ExprContext ctx = new ExprContext();
                ctx.addPreDefinedParam("colLabels", labelIndex);
                ctx.addPreDefinedParam("colTypes", ret.colTypes);
                ctx.addPreDefinedParam("values", m.getRow(rowIdx));
                int one = 1;
                int colCount = left.sortedColLabels.length + right.sortedColLabels.length;
                for (int k = 0; k < expressions.size(); ++k) {
                    Object[] expression = expressions.get(k);
                    Expr expr = (Expr)expression[one];
                    if (expr == null) continue;
                    m.setCell(rowIdx, colCount + k, (Serializable)expr.execute(ctx));
                }
                ++rowIdx;
            }
        }
        return ret;
    }

    public DBRows union(DBRows rows) {
        rows = new DBRows(this.datas.union(rows.datas), this.sortedColLabels);
        rows.setColTypes(this.colTypes);
        return rows;
    }

    public int getColIdx(String col) {
        return this.colLabels.get(col.toUpperCase());
    }

    public DBRows group(HashSet<String> groupCols) {
        this.groupSummarize = new HashMap();
        StringBuilder groupKey = new StringBuilder();
        int index = 0;
        for (int rowIdx = 0; rowIdx < this.datas.getShape()[index]; ++rowIdx) {
            for (String col : groupCols) {
                int colIdx = this.getColIdx(col);
                groupKey.append(String.valueOf(this.datas.getCell(rowIdx, colIdx)));
            }
            HashSet<Integer> summary = this.groupSummarize.get(groupKey.toString());
            if (summary == null) {
                summary = new HashSet();
                this.groupSummarize.put(groupKey.toString(), summary);
            }
            summary.add(rowIdx);
            groupKey.setLength(0);
        }
        DBRows rows = new DBRows(this.datas, this.sortedColLabels);
        rows.colTypes = this.colTypes;
        rows.groupCols = groupCols;
        rows.groupSummarize = this.groupSummarize;
        return rows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBRows executeGroupFunction(HashMap<String, IGroupRowsResolver> resolvers) {
        if (this.groupSummarize == null || this.groupSummarize.isEmpty()) {
            return this;
        }
        DBRows dBRows = this;
        synchronized (dBRows) {
            Matrix m = new Matrix();
            int newRowIdx = 0;
            ArrayList<Integer> cols = new ArrayList<Integer>();
            for (String col : this.colLabels.keySet()) {
                if (this.groupCols.contains(col)) continue;
                cols.add(this.colLabels.get(col));
            }
            for (String groupKey : this.groupSummarize.keySet()) {
                Integer colIdx;
                HashSet<Integer> groupRows = this.groupSummarize.get(groupKey);
                Integer rowIdx = groupRows.iterator().next();
                for (String col : this.groupCols) {
                    colIdx = this.colLabels.get(col.toUpperCase());
                    m.setCell(newRowIdx, colIdx, this.datas.getCell(rowIdx, colIdx));
                }
                ArrayList<Serializable[]> colDatas = this.datas.getCells(groupRows, cols);
                for (int i = 0; i < cols.size(); ++i) {
                    colIdx = cols.get(i);
                    IGroupRowsResolver resolver = resolvers.get(this.sortedColLabels[colIdx].toUpperCase());
                    if (resolver == null) {
                        m.setCell(newRowIdx, colIdx, this.datas.getCell(rowIdx, colIdx));
                        continue;
                    }
                    m.setCell(newRowIdx, colIdx, resolver.resolve(colDatas.get(i)));
                }
                ++newRowIdx;
            }
            DBRows rows = new DBRows(m, this.sortedColLabels);
            rows.colTypes = this.colTypes;
            return rows;
        }
    }

    public DBRows and(DBRows rows) {
        Matrix m = this.datas.and(rows.datas);
        DBRows ret = new DBRows(m, this.sortedColLabels);
        ret.colTypes = this.colTypes;
        return ret;
    }

    public DBRows or(DBRows rows) {
        Matrix m = this.datas.or(rows.datas);
        DBRows ret = new DBRows(m, this.sortedColLabels);
        ret.colTypes = this.colTypes;
        return ret;
    }

    public void refreshStatistics() {
        this.datas.refreshStatistics();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> labels = new ArrayList<String>();
        sb.append("\r\n");
        for (String key : this.sortedColLabels) {
            labels.add(key);
        }
        sb.append(Utils.formatListContent(labels));
        sb.append("\r\n");
        sb.append(this.datas);
        sb.append("\r\n");
        return sb.toString();
    }

    private static HashMap<Integer, HashSet<Integer>> calcTableRelations(int rowCount, DBRows left, DBRows rows, CompareSetting ... settings) {
        Objects.requireNonNull(left, ResManager.loadKDString((String)"DBRows left \u4e3a\u7a7a", (String)"DBRows_5", (String)"mmc-phm-mservice", (Object[])new Object[0]));
        Objects.requireNonNull(rows, ResManager.loadKDString((String)"DBRows rows \u4e3a\u7a7a", (String)"DBRows_6", (String)"mmc-phm-mservice", (Object[])new Object[0]));
        HashMap<Integer, HashSet<Integer>> relations = new HashMap<Integer, HashSet<Integer>>();
        block0: for (int i = 0; i < rowCount; ++i) {
            for (CompareSetting setting : settings) {
                String colLabel = setting.getCol();
                Integer integer = left.colLabels.get(colLabel);
                if (Objects.isNull(integer)) continue;
                int colIdx = integer;
                String expression = (String)((Object)setting.getValue());
                int colIdx2 = rows.colLabels.get(expression);
                HashSet<Integer> targets = new HashSet<Integer>();
                rows.datas.filter(left.datas.getCell(i, colIdx), colIdx2, setting.getOp(), targets);
                HashSet<Integer> set = relations.get(i);
                if (set == null) {
                    set = new HashSet();
                    relations.put(i, set);
                    set.addAll(targets);
                    continue;
                }
                if (targets.isEmpty() || set.isEmpty()) {
                    set.clear();
                    continue block0;
                }
                HashSet<Integer> mergeSet = new HashSet<Integer>();
                for (Integer idx : targets) {
                    if (!set.contains(idx)) continue;
                    mergeSet.add(idx);
                }
                relations.put(i, mergeSet);
            }
        }
        return relations;
    }

    private static String[] buildNewLables(DBRows left, DBRows right, ArrayList<Object[]> expressions) {
        String fieldName;
        int colIdx;
        ArrayList<String> mergeLabels = new ArrayList<String>();
        for (colIdx = 0; colIdx < left.sortedColLabels.length; ++colIdx) {
            fieldName = left.sortedColLabels[colIdx];
            if (!left.isOutput(fieldName)) continue;
            mergeLabels.add(fieldName);
        }
        for (colIdx = 0; colIdx < right.sortedColLabels.length; ++colIdx) {
            fieldName = right.sortedColLabels[colIdx];
            if (!right.isOutput(fieldName) || left.colLabels.containsKey(fieldName)) continue;
            mergeLabels.add(right.sortedColLabels[colIdx]);
        }
        int zero = 0;
        for (Object[] pair : expressions) {
            mergeLabels.add(String.valueOf(pair[zero]));
        }
        return mergeLabels.toArray(new String[0]);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DBRows buildDemoDBRows(String demoDataFileName) {
        try (BufferedReader in = new BufferedReader(new FileReader(demoDataFileName));){
            TabSepFileSpliter spliter = new TabSepFileSpliter(in);
            String[] colLabels = spliter.getColLabels();
            Matrix datas = Matrix.buildDemoMatrix(spliter);
            DBRows rows = new DBRows(datas, colLabels);
            HashMap<String, VType> colTypes = new HashMap<String, VType>();
            for (int i = 0; i < spliter.colLabels.size(); ++i) {
                colTypes.put((String)spliter.colLabels.get(i), (VType)((Object)spliter.colTypes.get(i)));
            }
            rows.setColTypes(colTypes);
            DBRows dBRows = rows;
            return dBRows;
        }
        catch (Exception e) {
            logger.error((Object)String.format("failed to init DBRows from file reader(file path: %s)", demoDataFileName), (Throwable)e);
            throw new KDBizException((Throwable)e, new ErrorCode("", "failed to init DBRows from file reader(file path: %s)"), new Object[]{demoDataFileName});
        }
    }

    public static ObjectSerializer createJSONSerializer() {
        return new DBRowsSerializer();
    }

    private static class InnerResolver
    implements EmptyMatchRowResolver {
        private InnerResolver() {
        }

        @Override
        public boolean resolve(DBRows left, DBRows right, int i, int rowIdx, Matrix m) {
            return false;
        }
    }

    private static class LRResolver
    implements EmptyMatchRowResolver {
        private LRResolver() {
        }

        @Override
        public boolean resolve(DBRows left, DBRows right, int i, int rowIdx, Matrix m) {
            int outputColIdx = 0;
            for (int colIdx = 0; colIdx < left.sortedColLabels.length; ++colIdx) {
                if (!left.isOutput(left.sortedColLabels[colIdx])) continue;
                m.setCell(rowIdx, outputColIdx++, left.datas.getCell(i, colIdx));
            }
            for (int j = 0; j < right.sortedColLabels.length; ++j) {
                if (!right.isOutput(right.sortedColLabels[j]) || left.colLabels.containsKey(right.sortedColLabels[j])) continue;
                m.setCell(rowIdx, outputColIdx++, null);
            }
            return true;
        }
    }

    private static interface EmptyMatchRowResolver {
        public boolean resolve(DBRows var1, DBRows var2, int var3, int var4, Matrix var5);
    }

    private static class DBRowsSerializer
    implements ObjectSerializer {
        private DBRowsSerializer() {
        }

        public void write(JSONSerializer writer, Object obj, Object fieldName, Type fieldType, int features) throws IOException {
            MapSerializer ms = new MapSerializer();
            DBRows rs = (DBRows)obj;
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("colTypes", rs.colTypes);
            map.put("sortedColLabels", rs.sortedColLabels);
            map.put("datas", rs.datas);
            map.put("alias2Name", rs.alias2Name);
            ms.write(writer, map, fieldName, fieldType, features);
        }
    }

    private static class TabSepFileSpliter
    implements Matrix.IFileRowDataSpliter {
        private ArrayList<String> colLabels = new ArrayList();
        private ArrayList<VType> colTypes = new ArrayList();
        private String nextLine;
        private BufferedReader reader;
        private SimpleDateFormat DATE_FMT;
        private SimpleDateFormat DATETIME_FMT;
        private SimpleDateFormat TIME_FMT;

        public TabSepFileSpliter(BufferedReader reader) {
            this.reader = reader;
            this.DATE_FMT = new SimpleDateFormat("yyyy-MM-dd");
            this.DATETIME_FMT = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
            this.TIME_FMT = new SimpleDateFormat("hh:mm:ss");
            this.parseHeader();
        }

        public final void parseHeader() {
            this.next();
            String[] labels = this.nextLine.split("\t");
            for (int i = 0; i < labels.length; ++i) {
                this.colLabels.add(labels[i]);
            }
            this.next();
            String[] types = this.nextLine.split("\t");
            for (int i = 0; i < types.length; ++i) {
                this.colTypes.add(VType.valueOf(types[i]));
            }
            this.next();
        }

        public String[] getColLabels() {
            return this.colLabels.toArray(new String[0]);
        }

        @Override
        public boolean isEOF() {
            return this.nextLine != null;
        }

        @Override
        public Serializable[] splitAndGetNextRow() {
            String[] cells = this.nextLine.split("\t");
            Serializable[] ret = new Serializable[cells.length];
            for (int i = 0; i < cells.length; ++i) {
                Object val;
                if (StringUtils.isEmpty((String)cells[i])) {
                    val = null;
                } else {
                    switch (this.colTypes.get(i)) {
                        case DATE: {
                            try {
                                val = this.DATE_FMT.parse(cells[i]);
                                break;
                            }
                            catch (ParseException e) {
                                val = null;
                                logger.error((Object)"parse date error", (Throwable)e);
                                throw new KDBizException((Throwable)e, new ErrorCode("", "parse time error"), new Object[]{e.getMessage()});
                            }
                        }
                        case DATETIME: {
                            try {
                                val = this.DATETIME_FMT.parse(cells[i]);
                                break;
                            }
                            catch (ParseException e) {
                                val = null;
                                logger.error((Object)"parse datetime error", (Throwable)e);
                                throw new KDBizException((Throwable)e, new ErrorCode("", "parse time error"), new Object[]{e.getMessage()});
                            }
                        }
                        case DECIMAL: {
                            val = new BigDecimal(cells[i]);
                            break;
                        }
                        case STRING: {
                            val = cells[i];
                            break;
                        }
                        case TIME: {
                            try {
                                val = this.TIME_FMT.parse(cells[i]);
                                break;
                            }
                            catch (ParseException e) {
                                val = null;
                                logger.error((Object)"parse time error", (Throwable)e);
                                throw new KDBizException((Throwable)e, new ErrorCode("", "parse time error"), new Object[]{e.getMessage()});
                            }
                        }
                        default: {
                            val = null;
                            logger.warn((Object)String.format("unknown cell's vt [idx: %s, colLabels: %s, colTypes: %s]", i, Utils.formatListContent(this.colLabels), Utils.formatListContent(this.colTypes)));
                        }
                    }
                }
                ret[i] = val;
            }
            this.next();
            return ret;
        }

        private void next() {
            try {
                this.nextLine = this.reader.readLine();
            }
            catch (IOException e) {
                this.nextLine = null;
                logger.error((Object)"failed to load more datas from file reader.", (Throwable)e);
                throw new KDBizException((Throwable)e, new ErrorCode("", "failed to load more datas from file reader."), new Object[]{e.getMessage()});
            }
        }
    }
}

