/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.data;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.MapSerializer;
import com.alibaba.fastjson.serializer.ObjectSerializer;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.TreeMap;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.util.StringUtils;
import kd.mmc.phm.common.consts.SysConsts;
import kd.mmc.phm.mservice.model.KV;
import kd.mmc.phm.mservice.model.enums.CompareOperator;
import kd.mmc.phm.mservice.utils.Utils;

public class Matrix
implements Serializable {
    private static final long serialVersionUID = 2835464216181701157L;
    private Serializable[][] rows = new Serializable[2000][0];
    private TreeMap<String, ArrayList<Integer>>[] colValStatistics;
    private int rowCount;
    private int colCount;
    private boolean isInitIndex;
    private HashMap<Integer, Integer> rowIdxMapping;

    public Matrix() {
        this(true);
    }

    public Matrix(boolean isInitIndex) {
        this.isInitIndex = isInitIndex;
    }

    public void setCell(int rowIdx, int colIdx, Serializable cellVal) {
        this.ensureSize(rowIdx, colIdx);
        this.rows[rowIdx][colIdx] = cellVal;
        if (this.isInitIndex) {
            this.doValueStatistics(rowIdx, colIdx, cellVal);
        }
    }

    public Serializable getCell(int rowIdx, int colIdx) {
        if (!this.checkRange(rowIdx, colIdx)) {
            return null;
        }
        return this.rows[rowIdx][colIdx];
    }

    public ArrayList<Serializable[]> getCells(HashSet<Integer> rows, ArrayList<Integer> cols) {
        ArrayList<Serializable[]> ret = new ArrayList<Serializable[]>(rows.size());
        for (Integer i : cols) {
            Serializable[] datas = new Serializable[rows.size()];
            int j = 0;
            for (Integer row : rows) {
                datas[j++] = this.rows[row][i];
            }
            ret.add(datas);
        }
        return ret;
    }

    public int[] getShape() {
        return new int[]{this.rowCount, this.colCount};
    }

    public boolean isEmpty() {
        return this.rowCount == 0 || this.colCount == 0;
    }

    public boolean isSingle() {
        return this.rowCount == 1 && this.colCount == 1;
    }

    public Serializable[] getRow(int rowIdx) {
        if (!this.checkRowRange(rowIdx)) {
            return null;
        }
        return this.rows[rowIdx];
    }

    public Serializable[] getCol(int colIdx) {
        Serializable[] ret = new Serializable[this.rowCount];
        for (Map.Entry<String, ArrayList<Integer>> entry : this.colValStatistics[colIdx].entrySet()) {
            for (Integer idx : entry.getValue()) {
                ret[idx.intValue()] = (Serializable)((Object)entry.getKey());
            }
        }
        return ret;
    }

    public Matrix filter(Serializable value, int colIdx, CompareOperator op) {
        return this.filter(value, colIdx, op, null);
    }

    public Matrix filter(Serializable value, int colIdx, CompareOperator op, HashSet<Integer> rowRecorder) {
        if (!this.isInitIndex) {
            throw new KDBizException(SysConsts.Errors.INDEX_NOT_INITED, new Object[0]);
        }
        if (this.isEmpty()) {
            return this;
        }
        Matrix m = this.initCopyMatrix();
        m.rowIdxMapping = new HashMap();
        switch (op) {
            case EQUAL: {
                this.doEqualSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case NOTEQUAL: {
                this.doNotEqualSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case GREATER: {
                this.doGreaterSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case CEILING: {
                this.doCeilingSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case LESS: {
                this.doLessSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case FLOOR: {
                this.doFloorSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case LIKE: {
                this.doLikeSelect(m, rowRecorder, colIdx, value);
                break;
            }
            case ISNOTNULL: {
                for (Serializable serializable : this.colValStatistics[colIdx].keySet()) {
                    if (serializable == null || StringUtils.isEmpty((String)serializable.toString())) continue;
                    ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(serializable));
                    this.rowCopy(selections, m, rowRecorder);
                }
                break;
            }
            case ISNULL: {
                for (Serializable serializable : this.colValStatistics[colIdx].keySet()) {
                    if (serializable != null && !StringUtils.isEmpty((String)serializable.toString())) continue;
                    ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(serializable));
                    this.rowCopy(selections, m, rowRecorder);
                }
                break;
            }
            case INCLUDE: {
                break;
            }
            case NOTINCLUDE: {
                break;
            }
        }
        return m;
    }

    public Set<String> getColIndex(int colIdx) {
        if (!this.isInitIndex) {
            throw new KDBizException(SysConsts.Errors.INDEX_NOT_INITED, new Object[0]);
        }
        return this.colValStatistics[colIdx].keySet();
    }

    public Matrix union(Matrix m) {
        Matrix small;
        Matrix big;
        if (this.rowCount <= m.rowCount) {
            big = m;
            small = this;
        } else {
            big = this;
            small = m;
        }
        Matrix union = new Matrix();
        union.rowCount = big.rowCount + small.rowCount;
        union.colValStatistics = big.colValStatistics;
        union.colCount = this.colCount;
        union.rows = new Serializable[union.rowCount][this.colCount];
        System.arraycopy(big.rows, 0, union.rows, 0, big.rowCount);
        System.arraycopy(small.rows, 0, union.rows, big.rowCount, small.rowCount);
        if (small.isEmpty()) {
            return union;
        }
        for (int i = 0; i < this.colCount; ++i) {
            for (Serializable serializable : small.colValStatistics[i].keySet()) {
                if (union.colValStatistics[i].containsKey(serializable)) {
                    for (Integer idx : small.colValStatistics[i].get(serializable)) {
                        union.colValStatistics[i].get(serializable).add(idx + big.rowCount);
                    }
                    continue;
                }
                ArrayList<Integer> list = new ArrayList<Integer>();
                for (Integer idx : small.colValStatistics[i].get(serializable)) {
                    list.add(idx + big.rowCount);
                }
                union.colValStatistics[i].put(Utils.toString(serializable), list);
            }
        }
        return union;
    }

    public Matrix and(Matrix m) {
        if (this.rowIdxMapping == null && m.rowIdxMapping == null) {
            return this;
        }
        if (this.rowIdxMapping == null) {
            return m;
        }
        if (m.rowIdxMapping == null) {
            return this;
        }
        Matrix ret = this.initCopyMatrix();
        ret.rowIdxMapping = new HashMap();
        ArrayList<Serializable[]> newRows = new ArrayList<Serializable[]>();
        for (Map.Entry<Integer, Integer> entry : this.rowIdxMapping.entrySet()) {
            Integer src = entry.getKey();
            if (!m.rowIdxMapping.containsKey(src)) continue;
            newRows.add(this.rows[entry.getValue()]);
            ret.rowIdxMapping.put(src, newRows.size() - 1);
        }
        ret.rows = (Serializable[][])newRows.toArray((T[])new Serializable[0][]);
        ret.rowCount = ret.rows.length;
        return ret;
    }

    public Matrix or(Matrix m) {
        if (this.rowIdxMapping == null && m.rowIdxMapping == null) {
            return this;
        }
        if (this.rowIdxMapping == null) {
            return this;
        }
        if (m.rowIdxMapping == null) {
            return m;
        }
        Matrix ret = this.initCopyMatrix();
        ret.rowIdxMapping = new HashMap();
        ret.rowIdxMapping.putAll(m.rowIdxMapping);
        ArrayList<Serializable[]> newRows = new ArrayList<Serializable[]>();
        for (Map.Entry<Integer, Integer> entry : this.rowIdxMapping.entrySet()) {
            Integer src = entry.getKey();
            if (m.rowIdxMapping.containsKey(src)) continue;
            newRows.add(this.rows[entry.getValue()]);
            ret.rowIdxMapping.put(src, m.rowCount + newRows.size() - 1);
        }
        ret.rows = new Serializable[m.rowIdxMapping.size() + newRows.size()][];
        ret.rowCount = ret.rows.length;
        System.arraycopy(m.rows, 0, ret.rows, 0, m.rowCount);
        System.arraycopy(newRows.toArray((T[])new Serializable[0][]), 0, ret.rows, m.rowCount, newRows.size());
        return ret;
    }

    public void refreshStatistics() {
        this.isInitIndex = true;
        for (int i = 0; i < this.rowCount; ++i) {
            for (int j = 0; j < this.colCount; ++j) {
                this.doValueStatistics(i, j, this.rows[i][j]);
            }
        }
    }

    public Matrix sortBy(ArrayList<KV<Integer, Boolean>> sortCols) {
        if (!this.isInitIndex) {
            throw new KDBizException(SysConsts.Errors.INDEX_NOT_INITED, new Object[0]);
        }
        if (this.isEmpty()) {
            return this;
        }
        Matrix m = this.initCopyMatrix();
        m.rows = new Serializable[this.rowCount][this.colCount];
        m.rowCount = this.rowCount;
        m.colValStatistics = new TreeMap[this.colValStatistics.length];
        int pointer = 0;
        m.rowIdxMapping = new HashMap();
        KV<Integer, Boolean> col = sortCols.get(0);
        TreeMap<String, ArrayList<Integer>> statistics = this.colValStatistics[(Integer)col.key];
        NavigableSet<String> keys = statistics.descendingKeySet();
        Iterator<String> colIter = (Boolean)col.value != false ? keys.iterator() : keys.descendingIterator();
        while (colIter.hasNext()) {
            ArrayList<Integer> selections = statistics.get(colIter.next());
            this.subRangeSort(selections, sortCols.subList(1, sortCols.size()));
            for (int i = 0; i < selections.size(); ++i) {
                m.rows[pointer] = this.rows[selections.get(i)];
                m.rowIdxMapping.put(pointer, selections.get(i));
                ++pointer;
            }
        }
        return m;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.rowCount == 0) {
            return "empty";
        }
        this.append(sb, this.rows[0]);
        for (int i = 1; i < this.rowCount; ++i) {
            sb.append("\r\n");
            this.append(sb, this.rows[i]);
        }
        return sb.toString();
    }

    private void subRangeSort(ArrayList<Integer> range, List<KV<Integer, Boolean>> subCols) {
        if (subCols.isEmpty()) {
            return;
        }
        KV<Integer, Boolean> col = subCols.get(0);
        TreeMap<String, ArrayList<Integer>> subSort = new TreeMap<String, ArrayList<Integer>>();
        for (int i = 0; i < range.size(); ++i) {
            String key = Utils.toString(this.rows[range.get(i)][(Integer)col.key]);
            ArrayList<Integer> rows = (ArrayList<Integer>)subSort.get(key);
            if (rows == null) {
                rows = new ArrayList<Integer>();
                subSort.put(key, rows);
            }
            rows.add(range.get(i));
        }
        NavigableSet keys = subSort.descendingKeySet();
        Iterator colIter = (Boolean)col.value != false ? keys.iterator() : keys.descendingIterator();
        range.clear();
        while (colIter.hasNext()) {
            ArrayList selections = (ArrayList)subSort.get(colIter.next());
            this.subRangeSort(selections, subCols.subList(1, subCols.size()));
            range.addAll(selections);
        }
    }

    private void doValueStatistics(int rowIdx, int colIdx, Serializable cellVal) {
        this.expandStatistics(colIdx + 1);
        TreeMap<String, ArrayList<Integer>> statistics = this.initColStatistics(colIdx);
        ArrayList<Integer> rows = statistics.get(Utils.toString(cellVal));
        if (rows == null) {
            rows = new ArrayList();
            statistics.put(Utils.toString(cellVal), rows);
        }
        rows.add(rowIdx);
    }

    private TreeMap<String, ArrayList<Integer>> initColStatistics(int colIdx) {
        TreeMap<String, ArrayList<Integer>> statistics = this.colValStatistics[colIdx];
        if (statistics == null) {
            this.colValStatistics[colIdx] = statistics = new TreeMap(new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    if (o1 == null && o2 != null) {
                        return -1;
                    }
                    if (o1 != null && o2 == null) {
                        return 1;
                    }
                    if (o1 == null && o2 == null) {
                        return 0;
                    }
                    return ((Comparable)Comparable.class.cast(o1)).compareTo(Comparable.class.cast(o2));
                }
            });
        }
        return statistics;
    }

    private void append(StringBuilder sb, Serializable[] row) {
        for (int i = 0; i < this.colCount; ++i) {
            sb.append(i < row.length ? String.valueOf(row[i]) : "NaN").append('\t');
        }
    }

    private Matrix initCopyMatrix() {
        Matrix m = new Matrix();
        m.colCount = this.colCount;
        m.rowCount = 0;
        m.colValStatistics = new TreeMap[this.colCount];
        m.isInitIndex = true;
        return m;
    }

    private void doEqualSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(value));
        this.rowCopy(selections, m, rowRecorder);
    }

    private void doNotEqualSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        ArrayList<Integer> others;
        ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(value));
        HashSet<Integer> validator = new HashSet<Integer>();
        if (selections == null || selections.isEmpty()) {
            others = new ArrayList<Integer>(this.rowCount);
        } else {
            others = new ArrayList(this.rowCount - selections.size());
            validator.addAll(selections);
        }
        for (int i = 0; i < this.rowCount; ++i) {
            if (validator.contains(i)) continue;
            others.add(i);
        }
        this.rowCopy(others, m, rowRecorder);
    }

    private void doGreaterSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        while ((value = (Serializable)((Object)this.colValStatistics[colIdx].higherKey(Utils.toString(value)))) != null) {
            ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(value));
            this.rowCopy(selections, m, rowRecorder);
            if (value != null) continue;
        }
    }

    private void doCeilingSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        do {
            if (!this.colValStatistics[colIdx].containsKey(value)) continue;
            ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(value));
            this.rowCopy(selections, m, rowRecorder);
        } while ((value = (Serializable)((Object)this.colValStatistics[colIdx].lowerKey(Utils.toString(value)))) != null);
    }

    private void doLessSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        while ((value = (Serializable)((Object)this.colValStatistics[colIdx].lowerKey(Utils.toString(value)))) != null) {
            ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(value));
            this.rowCopy(selections, m, rowRecorder);
            if (value != null) continue;
        }
    }

    private void doFloorSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        do {
            if (!this.colValStatistics[colIdx].containsKey(value)) continue;
            ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(value));
            this.rowCopy(selections, m, rowRecorder);
        } while ((value = (Serializable)((Object)this.colValStatistics[colIdx].higherKey(Utils.toString(value)))) != null);
    }

    private void doLikeSelect(Matrix m, HashSet<Integer> rowRecorder, int colIdx, Serializable value) {
        for (Serializable serializable : this.colValStatistics[colIdx].keySet()) {
            if (serializable.toString().indexOf(value.toString()) < 0) continue;
            ArrayList<Integer> selections = this.colValStatistics[colIdx].get(Utils.toString(serializable));
            this.rowCopy(selections, m, rowRecorder);
        }
    }

    private void expandStatistics(int newSize) {
        if (this.colValStatistics == null) {
            this.colValStatistics = new TreeMap[this.colCount == 0 ? 20 : this.colCount];
        } else if (newSize > this.colValStatistics.length) {
            TreeMap[] newColValStatistics = new TreeMap[this.colValStatistics.length + 10];
            System.arraycopy(this.colValStatistics, 0, newColValStatistics, 0, this.colValStatistics.length);
            this.colValStatistics = newColValStatistics;
        }
    }

    private void ensureSize(int rowIdx, int colIdx) {
        if (rowIdx >= 5000000) {
            throw new KDBizException(new ErrorCode("MATRIX_ROW_SIZE_OVERFLOW", String.valueOf(rowIdx)), new Object[0]);
        }
        if (this.rows.length <= rowIdx) {
            Serializable[][] newRows = new Serializable[this.rows.length + 10000][];
            System.arraycopy(this.rows, 0, newRows, 0, this.rows.length);
            this.rows = newRows;
        }
        if (this.rowCount <= rowIdx) {
            this.rowCount = rowIdx + 1;
        }
        if (this.colCount <= colIdx) {
            this.colCount = colIdx + 1;
        }
        if (this.rows[rowIdx] == null) {
            this.rows[rowIdx] = new Serializable[this.colCount == 1 ? 20 : this.colCount];
        } else if (colIdx >= this.rows[rowIdx].length) {
            Serializable[] newRow = new Serializable[this.rows[rowIdx].length + 10];
            System.arraycopy(this.rows[rowIdx], 0, newRow, 0, this.rows[rowIdx].length);
            this.rows[rowIdx] = newRow;
        }
    }

    private boolean checkRange(int rowIdx, int colIdx) {
        return this.checkRowRange(rowIdx) && this.rows[rowIdx].length > colIdx;
    }

    private boolean checkRowRange(int rowIdx) {
        return this.rows.length > rowIdx;
    }

    private void rowCopy(ArrayList<Integer> selections, Matrix m, HashSet<Integer> rowRecorder) {
        if (selections == null) {
            return;
        }
        if (rowRecorder != null) {
            rowRecorder.addAll(selections);
            return;
        }
        Serializable[][] newRows = new Serializable[m.rowCount + selections.size()][];
        System.arraycopy(m.rows, 0, newRows, 0, m.rowCount);
        for (int i = m.rowCount; i < m.rowCount + selections.size(); ++i) {
            int idx = selections.get(i - m.rowCount);
            newRows[i] = this.rows[idx];
            m.rowIdxMapping.put(idx, i);
            for (int j = 0; j < this.colCount; ++j) {
                m.doValueStatistics(i, j, newRows[i][j]);
            }
        }
        m.rows = newRows;
        m.rowCount += selections.size();
    }

    public static Matrix buildDemoMatrix(IFileRowDataSpliter rowSpliter) {
        Matrix m = new Matrix();
        int rowIdx = 0;
        while (rowSpliter.isEOF()) {
            Serializable[] row = rowSpliter.splitAndGetNextRow();
            for (int colIdx = 0; colIdx < row.length; ++colIdx) {
                m.setCell(rowIdx, colIdx, row[colIdx]);
            }
            ++rowIdx;
        }
        return m;
    }

    public static ObjectSerializer createJSONSerializer() {
        return new MatrixSerializer();
    }

    private static class MatrixSerializer
    implements ObjectSerializer {
        private MatrixSerializer() {
        }

        public void write(JSONSerializer writer, Object obj, Object fieldName, Type fieldType, int features) throws IOException {
            MapSerializer ms = new MapSerializer();
            Matrix m = (Matrix)obj;
            Serializable[][] datas = new Serializable[m.rowCount][];
            System.arraycopy(m.rows, 0, datas, 0, m.rowCount);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("colCount", m.colCount);
            map.put("rowCount", m.rowCount);
            map.put("rows", datas);
            ms.write(writer, map, fieldName, fieldType, features);
        }
    }

    public static interface IFileRowDataSpliter {
        public boolean isEOF();

        public Serializable[] splitAndGetNextRow();
    }
}

