/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.fomula;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.model.fomula.IToken;
import kd.mmc.phm.mservice.model.fomula.Lexer;
import kd.mmc.phm.mservice.model.fomula.ParseException;
import kd.mmc.phm.mservice.model.fomula.enums.TokenType;
import kd.mmc.phm.mservice.model.fomula.node.IFTokenNode;
import kd.mmc.phm.mservice.model.fomula.node.TokenNode;
import kd.mmc.phm.mservice.model.fomula.token.ArrayToken;
import kd.mmc.phm.mservice.model.fomula.token.ConstToken;
import kd.mmc.phm.mservice.model.fomula.token.OperatorToken;
import kd.mmc.phm.mservice.model.fomula.token.PlaceHoldToken;

public class Expr {
    private TokenNode root;
    private Lexer lexer;
    private HashSet<String> awaredCols;

    public Expr(String exprStr) throws ParseException {
        this.lexer = new Lexer(exprStr);
        this.root = this.parseTokens(this.lexer.parse());
    }

    public boolean isWellFormatted() {
        return this.root != null;
    }

    public synchronized HashSet<String> getAwaredColumns() {
        this.awaredCols = new HashSet();
        for (IToken token : this.lexer.getTokens()) {
            if (token.getType() != TokenType.COLUMN) continue;
            String[] tmp = token.toString().split("@");
            this.awaredCols.add(tmp[1]);
        }
        return this.awaredCols;
    }

    private TokenNode parseTokens(List<IToken> tokens) throws ParseException {
        Stack<TokenNode> bracketStack = new Stack<TokenNode>();
        Stack<TokenNode> middleBracketStack = new Stack<TokenNode>();
        Stack<TokenNode> logicStack = new Stack<TokenNode>();
        TokenNode operatorNode = null;
        TokenNode operandNode = null;
        TokenNode connectNode = null;
        TokenNode returnNode = null;
        TokenNode ifNode = null;
        ArrayList<IToken> returnSubTokens = new ArrayList<IToken>(0);
        block15: for (IToken token : tokens) {
            TokenNode node = new TokenNode(token);
            if (returnNode != null) {
                if (token.getType() != TokenType.SEMICOLON) {
                    returnSubTokens.add(token);
                    continue;
                }
                TokenNode ret = this.parseTokens(returnSubTokens);
                if (returnSubTokens.size() > 1 && ((IToken)returnSubTokens.get(0)).getType() == TokenType.LEFTMIDDLEBRACKET) {
                    ret.addFirst((IToken)returnSubTokens.get(0));
                    ret.addOperand((IToken)returnSubTokens.get(returnSubTokens.size() - 1));
                }
                returnNode.setRight(ret);
                for (TokenNode right = ret; right != null; right = right.getRight()) {
                    if (right.getRight() != null) {
                        continue;
                    }
                    right.addOperand(new ConstToken(";", TokenType.SEMICOLON));
                    break;
                }
                returnNode = null;
                returnSubTokens.clear();
                continue;
            }
            if (!middleBracketStack.isEmpty() && token.getType() != TokenType.RIGHTMIDDLEBRACKET) {
                middleBracketStack.push(node);
                continue;
            }
            switch (token.getType()) {
                case LEFTBRACKET: {
                    bracketStack.push(node);
                    continue block15;
                }
                case RIGHTBRACKET: {
                    TokenNode top = (TokenNode)bracketStack.pop();
                    ArrayList<IToken> subTokens = new ArrayList();
                    if (top.isSingleTokenNode()) {
                        subTokens.add(0, top.getFirst());
                    } else {
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    while (true) {
                        if ((top = (TokenNode)bracketStack.pop()).isBracketNode()) {
                            subTokens.add(0, new PlaceHoldToken(top));
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.LEFTBRACKET) break;
                        if (top.isSingleTokenNode()) {
                            subTokens.add(0, top.getFirst());
                            continue;
                        }
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    node = new TokenNode(this.parseTokens(subTokens));
                    if (ifNode != null) {
                        ((IFTokenNode)ifNode).setLogicNode(node);
                        continue block15;
                    }
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block15;
                    }
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(node);
                        continue block15;
                    }
                    if (connectNode != null) {
                        connectNode.setRight(node);
                        continue block15;
                    }
                    operandNode = node;
                    continue block15;
                }
                case COLUMN: 
                case ATTRIBUTEFETCHER: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block15;
                    }
                    operandNode = node;
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(operandNode);
                        continue block15;
                    }
                    if (connectNode == null) continue block15;
                    connectNode.setChild(operandNode);
                    operandNode = null;
                    continue block15;
                }
                case OPERATOR: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block15;
                    }
                    if (operatorNode == null) {
                        operatorNode = node;
                    }
                    if (!operatorNode.isFull()) {
                        if (operandNode == null) {
                            if (connectNode == null || !connectNode.isFull()) continue block15;
                            operandNode = connectNode.getRight();
                            connectNode.setRight(operatorNode);
                            operatorNode.setChild(operandNode);
                            operandNode = null;
                            continue block15;
                        }
                        if (operatorNode == null) continue block15;
                        operatorNode.setChild(operandNode);
                        continue block15;
                    }
                    if (((OperatorToken)node.getFirst()).getOperatorType().ordinal() <= ((OperatorToken)operatorNode.getFirst()).getOperatorType().ordinal()) continue block15;
                    node.setLeft(operatorNode.getRight());
                    operatorNode.setRight(node);
                    operatorNode = node;
                    continue block15;
                }
                case LEFTMIDDLEBRACKET: {
                    if (!middleBracketStack.isEmpty()) continue block15;
                    middleBracketStack.push(node);
                    continue block15;
                }
                case RIGHTMIDDLEBRACKET: {
                    TokenNode top;
                    ArrayList<IToken> subTokens = new ArrayList<IToken>();
                    while (true) {
                        if ((top = (TokenNode)middleBracketStack.pop()).isBracketNode()) {
                            subTokens.add(0, new PlaceHoldToken(top));
                            continue;
                        }
                        if (top.getFirst().getType() == TokenType.LEFTMIDDLEBRACKET) break;
                        if (top.isSingleTokenNode()) {
                            subTokens.add(0, top.getFirst());
                            continue;
                        }
                        subTokens.add(0, new PlaceHoldToken(top));
                    }
                    if (!middleBracketStack.isEmpty()) {
                        middleBracketStack.push(this.parseTokens(subTokens));
                        continue block15;
                    }
                    if (!bracketStack.isEmpty()) {
                        bracketStack.add(new TokenNode(new ArrayToken(subTokens)));
                        continue block15;
                    }
                    operandNode = new TokenNode(new ArrayToken(subTokens));
                    continue block15;
                }
                case CONNECT: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block15;
                    }
                    if (connectNode == null) {
                        connectNode = node;
                    }
                    if (!connectNode.isFull()) {
                        if (operatorNode != null) {
                            connectNode.setChild(operatorNode.getRoot());
                        } else if (operandNode != null) {
                            connectNode.setChild(operandNode);
                        }
                    }
                    if (connectNode.isFull()) {
                        node.setLeft(connectNode);
                        connectNode = node;
                    }
                    operatorNode = null;
                    operandNode = null;
                    continue block15;
                }
                case CONST: 
                case NUMBER: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block15;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                    } else if (operandNode.getLast().getType() == TokenType.COMMA) {
                        operandNode.addOperand(node.getFirst());
                    } else {
                        operandNode = node;
                    }
                    if (operatorNode == null || operatorNode.isFull()) continue block15;
                    operatorNode.setChild(operandNode);
                    continue block15;
                }
                case COMMA: {
                    if (!bracketStack.isEmpty()) {
                        bracketStack.push(node);
                        continue block15;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                        continue block15;
                    }
                    operandNode.addOperand(node.getFirst());
                    continue block15;
                }
                case PLACEHOLD: {
                    PlaceHoldToken tmp = (PlaceHoldToken)node.getFirst();
                    node = tmp.getNode();
                    if (operatorNode != null && !operatorNode.isFull()) {
                        operatorNode.setChild(node);
                        continue block15;
                    }
                    if (connectNode != null && !connectNode.isFull()) {
                        connectNode.setChild(node);
                        continue block15;
                    }
                    if (operandNode == null) {
                        operandNode = node;
                        continue block15;
                    }
                    if (operandNode.getLast().getType() != TokenType.COMMA) continue block15;
                    operandNode.addOperand(tmp);
                    continue block15;
                }
                case IF: {
                    if (ifNode == null) {
                        ifNode = new IFTokenNode(token);
                        continue block15;
                    }
                    logicStack.push(ifNode);
                    TokenNode tokenNode = ifNode;
                    ifNode = new IFTokenNode(token);
                    tokenNode.setChild(ifNode);
                    continue block15;
                }
                case ELSE: {
                    if (ifNode == null || !ifNode.isFull() || logicStack.isEmpty()) continue block15;
                    ifNode = (IFTokenNode)logicStack.pop();
                    continue block15;
                }
                case RETURN: {
                    returnNode = node;
                    returnSubTokens.clear();
                    if (ifNode == null) continue block15;
                    ifNode.setChild(returnNode);
                    continue block15;
                }
            }
            throw new ParseException("unknown token type");
        }
        if (logicStack.isEmpty() && ifNode != null) {
            return ifNode;
        }
        if (!logicStack.isEmpty()) {
            return (TokenNode)logicStack.peek();
        }
        if (connectNode != null && !connectNode.isFull() && operatorNode != null && operatorNode.getRoot() != null) {
            connectNode.setRight(operatorNode.getRoot());
        }
        return connectNode == null ? (operatorNode == null ? operandNode : operatorNode.getRoot()) : connectNode.getRoot();
    }

    public Object execute(ExprContext ctx) {
        this.root.action(ctx);
        return ctx.getStack().pop();
    }

    public String toString() {
        return this.root.toString();
    }

    public static void main(String[] args) throws ParseException {
        Expr expr = new Expr("( @row0 or @row1) and ( ( @row2 or @row3) and @row4) or ( ( ( @row5 or @row6) and @row7) and @row8)");
        System.out.print(expr);
        HashMap<String, Integer> colLabelIndex1 = new HashMap<String, Integer>();
        colLabelIndex1.put("A", 0);
        colLabelIndex1.put("B", 1);
        expr = new Expr("if (@A not in '222' AND @B = '2') return '1'; else return '0';");
        ExprContext ctx1 = new ExprContext();
        ctx1.addPreDefinedParam("colLabels", colLabelIndex1);
        ctx1.addPreDefinedParam("values", new Serializable[]{Integer.valueOf(333), Integer.valueOf(2)});
        System.out.println("\u7ed3\u679c\u662f" + expr.execute(ctx1));
        HashMap<String, Integer> colLabelIndex = new HashMap<String, Integer>();
        colLabelIndex.put("MATERIALATTR", 0);
        colLabelIndex.put("PLANSTRATEGY", 1);
        colLabelIndex.put("COL0", 2);
        colLabelIndex.put("COL1", 3);
        colLabelIndex.put("COL2", 4);
        String formula = "if (@MATERIALATTR  = '10030' AND @PLANSTRATEGY = '1234')  return '001'; else if (@MaterialAttr  = '10040') return @COL0 + @COL1 - @COL2; else return ['003', '002', '001'];";
        expr = new Expr(formula);
        System.out.println(expr);
        ExprContext ctx = new ExprContext();
        ctx.addPreDefinedParam("colLabels", colLabelIndex);
        ctx.addPreDefinedParam("values", new Serializable[]{"10030", "1234"});
        System.out.println("result: " + expr.execute(ctx));
        ctx.addPreDefinedParam("values", new Serializable[]{"10040", null, Integer.valueOf(2), Integer.valueOf(3), Integer.valueOf(5)});
        System.out.println("result: " + new Expr("@COL0 + @COL1").execute(ctx));
        System.out.println("result: " + expr.execute(ctx));
        ctx.addPreDefinedParam("values", new Serializable[]{"10050", null, null, null});
        System.out.println("result: " + expr.execute(ctx));
    }
}

