/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.fomula;

import java.util.ArrayList;
import java.util.List;
import kd.mmc.phm.mservice.model.fomula.IToken;
import kd.mmc.phm.mservice.model.fomula.ParseException;
import kd.mmc.phm.mservice.model.fomula.enums.ConnectType;
import kd.mmc.phm.mservice.model.fomula.enums.OperatorType;
import kd.mmc.phm.mservice.model.fomula.enums.TokenType;
import kd.mmc.phm.mservice.model.fomula.token.AttributeFetchToken;
import kd.mmc.phm.mservice.model.fomula.token.ColumnToken;
import kd.mmc.phm.mservice.model.fomula.token.ConnectToken;
import kd.mmc.phm.mservice.model.fomula.token.ConstToken;
import kd.mmc.phm.mservice.model.fomula.token.ElseToken;
import kd.mmc.phm.mservice.model.fomula.token.IFToken;
import kd.mmc.phm.mservice.model.fomula.token.OperatorToken;
import kd.mmc.phm.mservice.model.fomula.token.ParamToken;
import kd.mmc.phm.mservice.model.fomula.token.ReturnToken;

public class Lexer {
    private char[] chars;
    private int pos;
    private List<IToken> tokens = new ArrayList<IToken>();

    public Lexer(String exprStr) {
        System.out.println("src expr:" + exprStr);
        this.chars = exprStr.toCharArray();
    }

    private String nextToken() {
        boolean isTokenFound = false;
        int wordStart = -1;
        block4: while (this.pos != this.chars.length) {
            char c = this.chars[this.pos++];
            switch (c) {
                case '%': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    --this.pos;
                    if (!isTokenFound) continue block4;
                    return new String(this.chars, wordStart, this.pos - wordStart);
                }
                case '\n': 
                case '\r': 
                case ' ': {
                    if (!isTokenFound) continue block4;
                    return new String(this.chars, wordStart, this.pos - wordStart - 1);
                }
            }
            if (isTokenFound) continue;
            wordStart = this.pos - 1;
            isTokenFound = true;
        }
        return new String(this.chars, wordStart, this.pos - wordStart);
    }

    private String nextPhrase() {
        boolean isTokenFound = false;
        int wordStart = -1;
        while (true) {
            switch (this.chars[this.pos++]) {
                case '\"': 
                case '\'': {
                    if (!isTokenFound) {
                        isTokenFound = true;
                        wordStart = this.pos - 1;
                        break;
                    }
                    return new String(this.chars, wordStart, this.pos - wordStart);
                }
            }
        }
    }

    public List<IToken> parse() throws ParseException {
        ColumnToken col = null;
        ParamToken param = null;
        AttributeFetchToken current = null;
        this.pos = 0;
        block31: while (this.pos < this.chars.length) {
            char c = this.chars[this.pos];
            switch (c) {
                case ' ': {
                    ++this.pos;
                    continue block31;
                }
                case '@': {
                    String word = this.nextToken();
                    col = new ColumnToken(word, false);
                    this.tokens.add(col);
                    continue block31;
                }
                case '.': {
                    ++this.pos;
                    current = new AttributeFetchToken();
                    this.tokens.add(current);
                    current.setCol(col);
                    continue block31;
                }
                case '#': {
                    String word = this.nextToken();
                    param = new ParamToken(word, false);
                    if (current == null) continue block31;
                    current.setParam(param);
                    continue block31;
                }
                case '=': {
                    ++this.pos;
                    this.tokens.add(new OperatorToken(OperatorType.EQUALS));
                    continue block31;
                }
                case '>': {
                    ++this.pos;
                    if (this.chars[this.pos] == '=') {
                        ++this.pos;
                        this.tokens.add(new OperatorToken(OperatorType.EQUALSOVER));
                        continue block31;
                    }
                    this.tokens.add(new OperatorToken(OperatorType.OVER));
                    continue block31;
                }
                case '<': {
                    ++this.pos;
                    if (this.chars[this.pos] == '=') {
                        ++this.pos;
                        this.tokens.add(new OperatorToken(OperatorType.EQUALSLESS));
                        continue block31;
                    }
                    if (this.chars[this.pos] == '>') {
                        ++this.pos;
                        this.tokens.add(new OperatorToken(OperatorType.NOTEQUALS));
                        continue block31;
                    }
                    this.tokens.add(new OperatorToken(OperatorType.LESS));
                    continue block31;
                }
                case 'A': 
                case 'a': {
                    String word = this.nextToken();
                    if (!"and".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new ConnectToken(ConnectType.AND));
                    continue block31;
                }
                case 'O': 
                case 'o': {
                    String word = this.nextToken();
                    if (!"or".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new ConnectToken(ConnectType.OR));
                    continue block31;
                }
                case 'I': 
                case 'i': {
                    String word = this.nextToken();
                    if ("in".equalsIgnoreCase(word)) {
                        this.tokens.add(new OperatorToken(OperatorType.IN));
                        continue block31;
                    }
                    if ("is".equalsIgnoreCase(word)) {
                        word = this.nextToken();
                        if ("not".equalsIgnoreCase(word)) {
                            word = this.nextToken();
                            if (!"null".equalsIgnoreCase(word)) continue block31;
                            this.tokens.add(new OperatorToken(OperatorType.ISNOTNULL));
                            continue block31;
                        }
                        if (!"null".equalsIgnoreCase(word)) continue block31;
                        this.tokens.add(new OperatorToken(OperatorType.ISNULL));
                        continue block31;
                    }
                    if (!"if".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new IFToken());
                    continue block31;
                }
                case 'E': 
                case 'e': {
                    String word = this.nextToken();
                    if (!"else".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new ElseToken());
                    continue block31;
                }
                case 'R': 
                case 'r': {
                    String word = this.nextToken();
                    if (!"return".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new ReturnToken());
                    continue block31;
                }
                case 'L': 
                case 'l': {
                    String word = this.nextToken();
                    if (!"like".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new OperatorToken(OperatorType.LIKE));
                    continue block31;
                }
                case 'N': 
                case 'n': {
                    String word = this.nextToken();
                    if (!"not".equalsIgnoreCase(word)) continue block31;
                    word = this.nextToken();
                    if ("like".equalsIgnoreCase(word)) {
                        this.tokens.add(new OperatorToken(OperatorType.NOTLIKE));
                        continue block31;
                    }
                    if ("in".equalsIgnoreCase(word)) {
                        this.tokens.add(new OperatorToken(OperatorType.NOTIN));
                        continue block31;
                    }
                    if (!"between".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new OperatorToken(OperatorType.NOTBETWEEN));
                    continue block31;
                }
                case 'B': 
                case 'b': {
                    String word = this.nextToken();
                    if (!"between".equalsIgnoreCase(word)) continue block31;
                    this.tokens.add(new OperatorToken(OperatorType.BETWEEN));
                    continue block31;
                }
                case '(': {
                    ++this.pos;
                    this.tokens.add(new ConstToken("(", TokenType.LEFTBRACKET));
                    continue block31;
                }
                case ')': {
                    ++this.pos;
                    this.tokens.add(new ConstToken(")", TokenType.RIGHTBRACKET));
                    continue block31;
                }
                case '[': {
                    ++this.pos;
                    this.tokens.add(new ConstToken("[", TokenType.LEFTMIDDLEBRACKET));
                    continue block31;
                }
                case ']': {
                    ++this.pos;
                    this.tokens.add(new ConstToken("]", TokenType.RIGHTMIDDLEBRACKET));
                    continue block31;
                }
                case '\'': {
                    String word = this.nextPhrase();
                    this.tokens.add(new ConstToken(word, TokenType.CONST));
                    continue block31;
                }
                case '\"': {
                    String word = this.nextPhrase();
                    this.tokens.add(new ConstToken(word, TokenType.CONST));
                    continue block31;
                }
                case '+': {
                    ++this.pos;
                    this.tokens.add(new OperatorToken(OperatorType.PLUS));
                    continue block31;
                }
                case '-': {
                    String word;
                    ++this.pos;
                    if (this.tokens.size() > 0 && this.tokens.get(this.tokens.size() - 1).getType() == TokenType.OPERATOR || this.tokens.isEmpty()) {
                        word = this.nextToken();
                        if (word.startsWith("@")) {
                            col = new ColumnToken(word, true);
                            continue block31;
                        }
                        if (word.startsWith("#")) {
                            param = new ParamToken(word, true);
                            continue block31;
                        }
                        this.tokens.add(new ConstToken("-" + word, TokenType.NUMBER));
                        continue block31;
                    }
                    this.tokens.add(new OperatorToken(OperatorType.MINUS));
                    continue block31;
                }
                case '*': {
                    ++this.pos;
                    this.tokens.add(new OperatorToken(OperatorType.MULTIPLE));
                    continue block31;
                }
                case '/': {
                    ++this.pos;
                    this.tokens.add(new OperatorToken(OperatorType.DIVIDE));
                    continue block31;
                }
                case '%': {
                    ++this.pos;
                    this.tokens.add(new OperatorToken(OperatorType.REMAINDER));
                    continue block31;
                }
                case ',': {
                    ++this.pos;
                    this.tokens.add(new ConstToken(",", TokenType.COMMA));
                    continue block31;
                }
                case ';': {
                    ++this.pos;
                    this.tokens.add(new ConstToken(";", TokenType.SEMICOLON));
                    continue block31;
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    String word = this.nextToken();
                    this.tokens.add(new ConstToken(word, TokenType.NUMBER));
                    continue block31;
                }
            }
            throw new ParseException("unknown character");
        }
        return this.tokens;
    }

    public List<IToken> getTokens() {
        return this.tokens;
    }
}

