/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.phm.mservice.model.fomula.token;

import java.util.ArrayList;
import java.util.List;
import kd.mmc.phm.mservice.model.fomula.ExprContext;
import kd.mmc.phm.mservice.model.fomula.IToken;
import kd.mmc.phm.mservice.model.fomula.enums.TokenType;

public class ArrayToken
implements IToken {
    private List<IToken> subTokens;

    public ArrayToken(List<IToken> subTokens) {
        this.subTokens = subTokens;
    }

    @Override
    public void action(ExprContext ctx) {
        ArrayList<Object> vals = new ArrayList<Object>(this.subTokens.size());
        boolean idx = false;
        for (IToken token : this.subTokens) {
            if (token.getType() == TokenType.COMMA) continue;
            token.action(ctx);
            vals.add(ctx.getStack().pop());
        }
        ctx.getStack().push(vals.toArray());
    }

    @Override
    public TokenType getType() {
        return TokenType.CONST;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder();
        ret.append('[');
        for (IToken token : this.subTokens) {
            ret.append(token).append(", ");
        }
        ret.deleteCharAt(ret.length() - 1);
        ret.deleteCharAt(ret.length() - 1);
        ret.append(']');
        return ret.toString();
    }
}

